unit Password;

interface

uses
  Forms;

function EnterPassword(const Form : TForm) : Boolean;
function PasswordRequired : Boolean;
procedure SetPassword;

implementation

uses
  Registry, RegStr, SysUtils, Windows;

resourcestring
  sCoundNotFindPwdChangePassword = 'An error occurred accessing the system file ''mpr.dll''';
  sCouldNotFindVerifyScreenSavePwd = 'An error occurred accessing the system file ''password.cpl''';
  sCouldNotLoadMultipleProviderRouter = 'Could not load the system file ''mpr.dll''';
  sCouldNotLoadPasswordApplet = 'Could not load the system file ''password.cpl''';

function EnterPassword(const Form : TForm) : Boolean;

type
  TVerifyScreenSavePwd = function(ParentWindow : HWND) : Boolean; stdcall;

var
  PasswordApplet : LongInt;
  VerifyScreenSavePwd : TVerifyScreenSavePwd;

begin
  ShowCursor(True); // Show the mouse pointer
  try
    Result := False;
    PasswordApplet := LoadLibrary('password.cpl');
    if PasswordApplet = 0 then
      raise Exception.Create(sCouldNotLoadPasswordApplet);
    try
      VerifyScreenSavePwd := GetProcAddress(PasswordApplet, 'VerifyScreenSavePwd');
      if @VerifyScreenSavePwd = nil then
        raise Exception.Create(sCouldNotFindVerifyScreenSavePwd);
      Result := VerifyScreenSavePwd(Form.Handle)
    finally
      FreeLibrary(PasswordApplet)
    end
  finally
    ShowCursor(False) // Hide the mouse pointer
  end
end;
  
function PasswordRequired : Boolean;

var
  Registry : TRegistry;

begin
  Registry := TRegistry.Create;
  try
    if Registry.OpenKey(REGSTR_PATH_SCREENSAVE, False) then
      try
        Result := Registry.ReadBool(REGSTR_VALUE_USESCRPASSWORD)
      except
        Result := False
      end
    else
      Result := False
  finally
    Registry.Free
  end
end;

procedure SetPassword;

type
  TPwdChangePassword = procedure(RegKeyName : PChar; ParentWindow : HWND;
                                 Reserved1, Reserved2 : Integer); stdcall;

var
  MultipleProviderRouter : LongInt;
  PwdChangePassword : TPwdChangePassword;

begin
  MultipleProviderRouter := LoadLibrary('mpr.dll');
  if MultipleProviderRouter = 0 then
    raise Exception.Create(sCouldNotLoadMultipleProviderRouter);
  try
    PwdChangePassword := GetProcAddress(MultipleProviderRouter, 'PwdChangePasswordA');
    if @PwdChangePassword = nil then
      raise Exception.Create(sCoundNotFindPwdChangePassword);
    PwdChangePassword('SCRSAVE', 0, 0, 0)
  finally
     FreeLibrary(MultipleProviderRouter)
   end
end;

end.
