program LifeScreenSaver;

uses
  Forms,
  fmBaseScreen in 'fmBaseScreen.pas' {frmBaseScreen},
  fmRepeatingPattern in 'fmRepeatingPattern.pas' {frmRepeatingPattern},
  fmScreenSaver in 'fmScreenSaver.pas' {frmScreenSaver},
  fmScreenSaverPreview in 'fmScreenSaverPreview.pas' {frmScreenSaverPreview},
  fmSettingsDialog in 'fmSettingsDialog.pas' {frmSettingsDialog},
  Password in 'Password.pas',
  UOptions in 'UOptions.pas';

{$R *.RES}

var
  Param : String;

procedure ConfigureScreenSaver;

begin
  Application.CreateForm(TfrmSettingsDialog, frmSettingsDialog);
  Application.Run
end;

begin
  Application.Title := 'Life Screen Saver';
  // Process the command line parameters to decide what to do
  if ParamCount >= 1 then
  begin
    Param := ParamStr(1);
    if Param[1] in ['/', '-'] then
      Delete(Param, 1, 1);
    case Param[1] of
      'a', 'A' : SetPassword;
      'c', 'C' : ConfigureScreenSaver;
      'p', 'P' : begin
                   Application.CreateForm(TfrmScreenSaverPreview, frmScreenSaverPreview);
                   Application.Run
                 end;
      's', 'S' : begin
                   Application.CreateForm(TfrmScreenSaver, frmScreenSaver);
                   Application.Run
                 end
      else       ConfigureScreenSaver
    end
  end
  else
    ConfigureScreenSaver
end.
