{*******************************************************************************}
{                                                                               }
{ FileName     : ILfHist1.inc                                                   }
{                                                                               }
{ Author       : Ian Lane (Email: lanei@ideal.net.au)                           }
{                                                                               }
{ Synopsis     : Contains the definition of the TLifeHistory object. This is an }
{                object which stores TLifeGrid objects in a circular buffer.    }
{                                                                               }
{ See also     : ILfHist2.inc, ILfGrid1, ILfGrid2                               }
{                                                                               }
{ Distribution : This object is free for public use and objects may be freely   }
{                descended from it as long as credit is given to the author.    }
{                                                                               }
{                          Copyright (c) 1998 Ian Lane                          }
{                                                                               }
{*******************************************************************************}

  TLifeHistory = class
  private
    FList : TList;
    FMostRecent : Integer;
    function GetCount : Cardinal;
    function GetGrid(const Index : Cardinal) : TLifeGrid;
    function GetMaxNumberOfLevels : Cardinal;
    procedure SetMaxNumberOfLevels(const Value : Cardinal);
  public
    constructor Create(const NumberOfLevels : Cardinal);
    function Add(const Grid : TLifeGrid) : TLifeGrid;
    procedure Clear;
    function Contains(const Grid : TLifeGrid) : Integer;
    procedure LoadFromStream(const Stream : TStream);
    procedure SaveToStream(const Stream : TStream);
    destructor Destroy; override;
    property Count : Cardinal read GetCount;
    property Grids[const Index : Cardinal] : TLifeGrid read GetGrid; default;
    property MaxNumberOfLevels : Cardinal read GetMaxNumberOfLevels
                                          write SetMaxNumberOfLevels;
  end;
