{*******************************************************************************}
{                                                                               }
{ FileName     : ILfGrid1.inc                                                   }
{                                                                               }
{ Author       : Ian Lane (Email: lanei@ideal.net.au)                           }
{                                                                               }
{ Synopsis     : Contains the definition of the TLifeGrid object and related    }
{                types. This is a 2-dimensional array capable of having its     }
{                dimensions specified or changed at runtime.                    }
{                                                                               }
{ See also     : ILfGrid2.inc                                                   }
{                                                                               }
{ Distribution : This object is free for public use and objects may be freely   }
{                descended from it as long as credit is given to the author.    }
{                                                                               }
{                          Copyright (c) 1998 Ian Lane                          }
{                                                                               }
{*******************************************************************************}

  TGrid = Array[0..MaxGridHeight * MaxGridWidth - 1] of Boolean;
  PGrid = ^TGrid;
  TLifeGrid = class
  private
    FGrid : PGrid;
    FGridHeight : TPermissableGridHeight;
    FGridWidth : TPermissableGridWidth;
    procedure AllocGrid;
    function CellCoordToGridOffset(const X : TGridWidthRange;
                                   const Y : TGridHeightRange) : Cardinal;
    procedure FreeGrid;
    function GetCell(const X : TGridWidthRange; const Y : TGridHeightRange) : Boolean;
    function GetLiveCellCount : Integer;
    procedure SetCell(const X : TGridWidthRange; const Y : TGridHeightRange;
                      const Value : Boolean);
  public
    constructor Create(const GridWidth : TPermissableGridWidth;
                       const GridHeight : TPermissableGridHeight);
    constructor CreateEmpty;
    procedure Assign(const Source : TLifeGrid);
    procedure Clear;
    function DoesCellLive(const X : TGridWidthRange; const Y : TGridHeightRange) : Boolean;
    function Equal(const Source : TLifeGrid) : Boolean;
    procedure LoadFromStream(const Stream : TStream);
    function NumberOfNeighbours(const X : TGridWidthRange;
                                const Y : TGridHeightRange) : Integer;
    procedure SaveToStream(const Stream : TStream);
    procedure SetGridSize(const NewGridWidth : TPermissableGridWidth;
                          const NewGridHeight : TPermissableGridHeight);
    destructor Destroy; override;
    property Cells[const X : TGridWidthRange; const Y : TGridHeightRange] : Boolean
             read GetCell write SetCell; default;
    property GridHeight : TPermissableGridHeight read FGridHeight;
    property GridWidth : TPermissableGridWidth read FGridWidth;
    property LiveCellCount : Integer read GetLiveCellCount;
  end;
