unit Uhwopen;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, DsgnIntf, UhwFont;

{---------------------------------------------------------------------------}
type
  TUhwEditorDlg = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    OpenDialog1: TOpenDialog;
    Image1: TImage;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    FUhwStrukt:TUhwStrukt;
    procedure SetUhwStrukt (Value:TUhwStrukt);
    procedure DrawPreview;
  public
    property EditorUhwStrukt: TUhwStrukt read FUhwStrukt write SetUhwStrukt;
  end;

{---------------------------------------------------------------------------}
  TUhwStruktProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;
{---------------------------------------------------------------------------}
  TUhwEditor = class(TDefaultEditor)
  public
    procedure EditProperty(PropertyEditor: TPropertyEditor;
      var Continue, FreeEditor: Boolean); virtual;
  end;

var
  UhwEditorDlg: TUhwEditorDlg;

implementation

{$R *.DFM}

{===========================================================================}
procedure TUhwStruktProperty.Edit;
var
  Strukt  : TUhwStrukt;
  MyEditor: TUhwEditorDlg;
begin
  Strukt := TUhwStrukt(GetOrdValue);
  MyEditor := TUhwEditorDlg.Create(Application);
  try
    MyEditor.FUhwStrukt:=TUhwStrukt.Create;
    MyEditor.FUhwStrukt.InitTab;
    MyEditor.FUhwStrukt.Assign(Strukt);
    MyEditor.DrawPreview;
    MyEditor.ShowModal;
    if MyEditor.ModalResult=mrOk then
    begin
     if MyEditor.FUhwStrukt.r.Size=0 then
     begin
      Strukt.FreeTab;
      SetOrdValue(LongInt(Strukt));
     end else
     begin
      Strukt:=MyEditor.FUhwStrukt;
      SetOrdValue(LongInt(Strukt));
      Strukt.Parent.charspace:=strukt.r.odstep;
      Strukt.Parent.spacelength:=strukt.r.spacja;
     end;
    end;
    MyEditor.FUhwStrukt.FreeTab;
    MyEditor.FUhwStrukt.Free;
  finally
    MyEditor.Free;
  end;
end;

function TUhwStruktProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paSubProperties];
end;

{TUhwEditor}
{-----------------------------------------------------------------------------}
procedure TUhwEditor.EditProperty(PropertyEditor: TPropertyEditor;
  var Continue, FreeEditor: Boolean);
var PropName: string;
begin
  exit;
{  haltix('JAH');
  PropName := PropertyEditor.GetName;
  if (CompareText(PropName, 'ANGLES') = 0) then
  begin
    PropertyEditor.Edit;
    Continue := False;
  end;}
end;
{-----------------------------------------------------------------------------}
procedure TUhwEditorDlg.DrawPreview;
var r:TRect;
    a,b,x,y,i,ii:integer;
begin
  if (FUhwStrukt=nil) or (FUhwStrukt.r.Size=0) then
  with image1.canvas do
  begin
   brush.color:=clWhite;
   r:=Rect(0,0,width,height);
   fillrect(r);
  end else
  with image1.canvas do
  begin
   x:=0;
   i:=0;
   for a:=0 to 255 do
    if (FUhwStrukt.Tab[a]<>nil) then
    begin
     inc(i);
     if (FUhwStrukt.Tab[a]^.xx>x) then x:=FUhwStrukt.Tab[a]^.xx;
    end;
   y:=FUhwStrukt.FontHeight;

   ii:=trunc(sqrt(i))+1;

   with image1.picture.bitmap do
   begin
    width :=ii*x+10;
    if ii*y+10<160 then height:=160 else height:=ii*y+10;
    brush.style:=bsSolid;
    brush.color:=rgb(FUhwStrukt.r.Paleta[1],FUhwStrukt.r.Paleta[2],FUhwStrukt.r.Paleta[3]);
    r:=Rect(0,0,width,height);
    FillRect(r);
   end;
   i:=0;
   for a:=0 to ii-1 do
    for b:=0 to ii-1 do
    begin
     while (i<=255) and (FUhwStrukt.tab[i]=nil) do
      inc(i);
     if i<=255 then
      FUhwStrukt.CharOut(image1.canvas,5+b*x,5+a*y,chr(i),false);
     inc(i);
    end;

   image1.width :=image1.picture.bitmap.width;
   image1.height:=image1.picture.bitmap.height;
   button1.left:=image1.left+image1.width+8;
   button4.left:=button1.left;

   button3.left:=button1.Left;
   button3.top :=image1.top+image1.height-button3.height-4;

   button2.left:=button1.Left;
   button2.top :=button3.top-button3.height-8;

  end;

  clientwidth :=button1.left+button1.width+10;
  clientheight:=image1.top+image1.height+10;

end;
{-----------------------------------------------------------------------------}
procedure TUhwEditorDlg.Button1Click(Sender: TObject);
begin
 if opendialog1.Execute then
 begin
  if FUhwStrukt.Load (opendialog1.filename) then DrawPreview;
 end;
end;

{-----------------------------------------------------------------------------}
procedure TUhwEditorDlg.SetUhwStrukt (Value:TUhwStrukt);
begin
 FUhwStrukt:=Value;
 {FUhwStrukt.Assign(Value);}
end;
{-----------------------------------------------------------------------------}
procedure TUhwEditorDlg.FormCreate(Sender: TObject);
begin
 with image1.picture.bitmap do
 begin
  width:=image1.width;
  height:=image1.height;
 end;
end;

procedure TUhwEditorDlg.Button2Click(Sender: TObject);
begin
 modalresult:=mrCancel;
end;

procedure TUhwEditorDlg.Button4Click(Sender: TObject);
begin
 FUhwStrukt.FreeTab;
 DrawPreview;
end;

end.
