unit UhwLabel;

{    TUHWLABEL COMPONENT v0.3 (c) 1996,1998 UHO
     ukasz Knasiecki. UHO
     uhouho@geocities.com
     http://friko4.onet.pl/ko/uho/

     Part of UHO FREEWARE PROGRAM
     - you've got full source
     - you've got no limits for using and changing this even in commercial apps
     - you've got no feedback from me

     This component lets you to use labels with UhwFonts.
     Now You can use in Windows Smooth, Coloured etc. Fonts.

     INSTALL: Just register UhwReg file

     Code is quite dirty but it's no time to clean. Just try to go trough it.
     Look Methods/Properties Info in UhwFont.TXT and UhwFont.HLP

     Have Fun and Don't Worry about Bugs. Easy.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, UhwFont;

type TLabelPal =
(lpOriginal,lpUhwPalette,lpMonoWhite,lpMonoBlack,lpFromTo);

type
  TUhwLabel = class(tgraphiccontrol)
  private
    fPal:TUhwPal;
    FPalTyp:TLabelPal;
    FPalMono,FPalFrom,FPalTo:TColor;
    ffont: TUhwFont;
    fAutoSize,fUnderline,FWordWrap,fVisible:boolean;
    fUnderlineColor: TColor;
    fUnderlineY    : shortint;
    FAlignmentX: TAlignment;
    FAlignmentY: TAlignmentY;
    FOnMouseEnter, FOnMouseLeave : TNotifyEvent;
    procedure AdjustBounds;
    procedure MyPaint (doTxt,doUnderline:boolean);
    procedure Paint; override;
    function  GetTransparent: Boolean;
    procedure SetAlignmentX (Value: TAlignment);
    procedure SetAlignmentY (Value: TAlignmentY);
    procedure SetAutoSize(Value: Boolean);
    procedure SetFont(Value: TUhwFont);
    procedure SetPal (Value: TUhwPal);
    procedure SetPalTyp (Value: TLabelPal);
    procedure SetPalFrom(Value: TColor);
    procedure SetPalMono(Value: TColor);
    procedure SetPalTo  (Value: TColor);
    procedure SetTransparent(Value: Boolean);
    procedure SetUnderline (Value: Boolean);
    procedure SetUnderlineColor (Value: TColor);
    procedure SetUnderlineY (Value: Shortint);
    procedure SetVisible (Value: Boolean);
    procedure SetWordWrap (Value: boolean);
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CMMouseEnter(var msg: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var msg: TMessage); message CM_MOUSELEAVE;

  public
    constructor Create(AOwner: TComponent); override;
  published
    property Align;
    property AlignmentX : TAlignment  read FAlignmentX write SetAlignmentX;
    property AlignmentY : TAlignmentY read FAlignmentY write SetAlignmentY;
    property AutoSize: Boolean read FAutoSize write SetAutoSize default True;
    property Caption;
    property Color;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font:tuhwfont read ffont write setfont;
    property PaletteType: TLabelPal read FPalTyp write SetPalTyp;
    property PaletteFrom: TColor read FPalFrom write SetPalFrom;
    property PaletteTo  : TColor read FPalTo   write SetPalTo ;
    property PaletteMonoColor : TColor read FPalMono write SetPalMono;
    property ParentColor;
    property ParentShowHint;
    property ShowHint;
    property Transparent: Boolean read GetTransparent write SetTransparent default True;
    property UhwPal : TUhwPal read Fpal write setpal;
    property Underline : Boolean read FUnderline write SetUnderline default False;
    property UnderlineColor : TColor read fUnderlineColor write SetUnderlineColor default clRed;
    property UnderlineY : Shortint read fUnderlineY write SetUnderlineY default 0;
    property Visible : boolean read fVisible write SetVisible default true;
    property WordWrap: Boolean read FWordWrap write SetWordWrap default False;

    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseEnter : TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave : TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

{------------------ just a small util ----------------------------------------}
function CutWord(var s:string):string;
 var a:byte;
 begin
  a:=0;
  while (a+1<=length(s)) and (s[a+1]=' ') do   inc(a);
  while (a+1<=length(s)) and not (s[a+1] in [' ']) do  inc(a);
  if a=0 then result:='' else
   begin result:=copy(s,1,a); delete(s,1,a); end;
 end;


procedure Register;
begin
  RegisterComponents('UHO', [TUhwLabel]);
end;

{-----------------------------------------------------------------------------}
{-------------------       TUHOLABEL      ------------------------------------}
{-----------------------------------------------------------------------------}
constructor TUhwLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csOpaque];
  Width := 65;
  Height := 17;
  FAutoSize := True;
  FPalTyp := lpOriginal;
  FUnderline := False;
  FUnderlineColor := clRed;
  FWordWrap := False;
  fVisible  := True;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetWordWrap (Value: boolean);
begin
 if Value<>fWordWrap then
 begin
  fWordWrap:=Value;
  Invalidate;
 end;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetAlignmentX (Value: TAlignment);
begin
  if FAlignmentX <> Value then
  begin
    FAlignmentX := Value;
    Invalidate;
  end;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetAlignmentY (Value: TAlignmentY);
begin
  if FAlignmentY <> Value then
  begin
    FAlignmentY := Value;
    Invalidate;
  end;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetFont(Value: TUhwFont);
begin
 FFont:=Value;
 AdjustBounds;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetPal (Value: TUhwPal);
begin
 FPal:=Value;
 paint;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetPalTyp (Value: TLabelPal);
begin
 FPalTyp:=Value;
 case FPalTyp of
  lpMonoWhite: {if fpalmono=clBlack then }fPalMono:=clWhite;
  lpMonoBlack: {if fpalmono=clWhite then }fPalMono:=clBlack;
 end;
 paint;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetPalFrom(Value: TColor);
begin
 FPalFrom:=Value;
 Paint;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetPalTo  (Value: TColor);
begin
 FPalTo:=Value;
 Paint;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetPalMono(Value: TColor);
begin
 FPalMono:=Value;
 Paint;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.AdjustBounds;
begin
 if fAutoSize and (font<>nil) then
 begin
  width :=font.textwidth(caption);
  height:=font.fontheight+1;
 end;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetAutoSize(Value: Boolean);
begin
  if FAutoSize <> Value then
  begin FAutoSize := Value;
        AdjustBounds;
  end;
end;

{-----------------------------------------------------------------------------}

procedure TUhwLabel.MyPaint (doTxt,doUnderline:boolean);

const Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var Rect: TRect;
    x,y,a,i,itab:integer;
    s,sbig,s1,s2:string;
    q:boolean;
    tab:array[1..255] of byte;
    tmppal:TPal768;
begin
  if (ffont=nil) or (not fvisible) then exit;

  tmppal:=Font.Palette;

  case PaletteType of
   lpUhwPalette  : if Assigned(FPal) then font.palette:=uhwpal.palette;
   lpFromTo   : font.palette:=MakeFromToPalette(paletteFrom,paletteTo);
   lpMonoWhite: font.palette:=MakeFromToPalette(clBlack,paletteMonoColor);
   lpMonoBlack: font.palette:=MakeFromToPalette(clWhite,paletteMonoColor);
  end;

  with Canvas do
  begin
    if not Transparent then
    begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
    end;

    if wordwrap then
    begin
     s:=caption;
     while pos('  ',s)>0 do     {podwjne spacje won!}
      delete(s,pos('  ',s),1);
     sbig:=s;

     a:=1; itab:=0; i:=1; s1:='';
     repeat
      s2:='';
      q:=false;
      repeat
       if s1='' then s1:=CutWord(s);
       if s1='' then q:=true else
       if s2='' then begin s2:=s1; s1:='' end else
       if ffont.textwidth(s2+s1)<=width then
       begin
        s2:=s2+s1; s1:='';
       end else q:=true;
      until q;

      if s2<>'' then
      begin
       inc(itab);
       tab[itab]:=length(s2);
      end;
     until s2='';

    end else
    begin
     itab:=1;
     sbig:=caption;
     tab[1]:=length(sbig);
    end;

    i:=1;

    for a:=1 to itab do
    begin
     s1:=copy(sbig,i,tab[a]);
     while (s1<>'') and (s1[1]=' ') do delete(s1,1,1);
     inc(i,tab[a]);
     case fAlignmentX of
      taCenter       : x:=(width-ffont.textwidth(s1)) div 2;
      taLeftJustify  : x:=0;
      taRightJustify : x:=width-ffont.textwidth(s1);
     end;
     case AlignmentY of
      taCenterY       : y:=(height-ffont.fontheight*itab) div 2+(a-1)*ffont.fontheight;
      taTopJustify    : y:=(a-1)*ffont.fontheight;
      taBottomJustify : y:=height-ffont.fontheight*(itab-a+1);
     end;
     if s1<>'' then
     begin
      if doTxt then ffont.TextOut2 (canvas,x,y,s1);
      if doUnderline and UnderLine then
      begin pen.color:=UnderlineColor;
            {pen.style:=psSolid;}
            moveto(x,y+height+UnderlineY-1);
            lineto(x+ffont.TextWidth(s1)+1,y+height+UnderlineY-1);
      end;
     end;
    end;

  end;

  Font.Palette:=tmppal;

end;

{-----------------------------------------------------------------------------}
procedure TUhwLabel.Paint;
begin
 MyPaint(true,true);
end;
{-----------------------------------------------------------------------------}

function TUhwLabel.GetTransparent: Boolean;
begin
  Result := not (csOpaque in ControlStyle);
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetTransparent(Value: Boolean);
begin
  if Transparent <> Value then
  begin
    if Value then
      ControlStyle := ControlStyle - [csOpaque] else
      ControlStyle := ControlStyle + [csOpaque];
    Invalidate;
  end;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.CMTextChanged(var Message: TMessage);
begin
  Invalidate;
  AdjustBounds;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetUnderline (Value: Boolean);
begin
 if Value<>FUnderline then
 begin
  FUnderline:=Value;
  Invalidate;
 end;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetUnderlineColor (Value: TColor);
begin
 if Value<>FUnderlineColor then
 begin
  FUnderlineColor:=Value;
  MyPaint (false,true);
 end;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetUnderlineY (Value: Shortint);
begin
 if Value<>FUnderlineY then
 begin
  if Value>0 then Value:=-Value;
  FUnderlineY:=Value;
  Invalidate;
 end;
end;

{-----------------------------------------------------------------------------}
procedure TUhwLabel.SetVisible (Value: Boolean);
begin
 if fvisible<>value then
 begin
  fvisible:=value;
  invalidate;
 end;
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.CMMouseEnter(var msg: TMessage);
begin
 if Assigned(FOnMouseEnter) then FOnMouseEnter(self);
end;
{-----------------------------------------------------------------------------}
procedure TUhwLabel.CMMouseLeave(var msg: TMessage);
begin
 if Assigned(FOnMouseLeave) then FOnMouseLeave(self);
end;
{-----------------------------------------------------------------------------}

end.
