unit Uhwfont;

{    TUHWFONT COMPONENT v0.3 (c) 1996,1998 UHO
     ukasz Knasiecki. UHO
     uhouho@geocities.com
     http://friko4.onet.pl/ko/uho/

     Part of UHO FREEWARE PROGRAM
     - you've got full source
     - you've got no limits for using and changing this even in commercial apps
     - you've got no feedback from me

     This component lets you to use bitmap fonts with 256 colours.
     Now You can use in Windows Smooth, Coloured etc. Fonts.

     INSTALL: Just register UhwReg file

     Code is quite dirty but it's no time to clean. Just try to go trough it.
     Look Methods/Properties Info in UhwFont.TXT and UhwFont.HLP files

     Have Fun and Don't Worry about Bugs. Easy.
}


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type obr=array[1..65535] of byte;
     obrwsk=^obr;
     TUhwChar=record wsk:word; xx,yy,ydown:byte; end;
     TPal768=array[0..255] of TColor;
     TAlignmentY = (taTopJustify, taBottomJustify, taCenterY);
     T255 = record i:byte; d:array[1..255] of word; end;

function  LoadPal (var f:file;var p1:TPal768) : boolean;
function  SavePal (var f:file;var p1:TPal768) : boolean;

{----------------------------------------------------------------------------}

type
  TUhwFont = class;
  TUHWstrukt=class(TPersistent)
      protected
       procedure DefineProperties(Filer: TFiler); override;
      public
       parent:TUhwFont;
       font:obrwsk;
       tab:array[0..255] of ^tuhwchar;
       r:record
                    spacja,maxY,cTlo:byte;
                    odstep:shortint;
                    size:word;
                    paleta:Tpal768;
       end;
       procedure   InitTab;
       procedure   FreeTab;
       function    Load(s:string):boolean;
       function    save(s:string):boolean;

       procedure LoadFromStream(Stream: TStream);
       procedure SaveToStream(Stream: TStream);

       function    FontHeight : Integer;
       function    TextWidth(const Text: string): Integer;
       function    CharOut  (canvas:TCanvas;X,Y:integer; const Znak: char; ramka:boolean):integer; {result=width}
       procedure   TextOut1 (canvas0:TCanvas;X,Y:integer; const Text: string);
       procedure   TextOut2 (canvas0:TCanvas;X,Y:integer; const Text: string);
       procedure   Assign(source:TUhwStrukt);
     end;
{----------------------------------------------------------------------------}
  TUhwFont = class(tcomponent)
  private
   fuhwstrukt:TUhwStrukt;
   fpalname:string;
   fInterSpace:shortint;
   fSpaceLength:shortint;

   procedure SetInterSpace(value:shortint);
   procedure SetSpaceLength(value:shortint);
   procedure SetUhwStrukt(value:TUhwStrukt);
   function  CopyToFit (xx:word;text:string) : string;

   procedure SetPal(value:TPal768);
   function  GetPal:TPal768;

  public
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;

    procedure LoadFromFile(const Text: string);
    procedure SaveToFile(const Text: string);

    function  TextWidth(const Text: string): Integer;
    function  FontHeight : Integer;
    {--- i've written 2 writeout procs but the speed is unfortunately the same
         textout uses textout2                                             ---}
    procedure TextOut  (canvas0:TCanvas;X,Y:integer; const Text: string);
    procedure TextOut1  (canvas0:TCanvas;X,Y:integer; const Text: string);
    procedure TextOut2  (canvas0:TCanvas;X,Y:integer; const Text: string);
    procedure TextOutBox(canvas0:TCanvas;X,Y,XX,YY:integer;Text:string;
                         falignx:Talignment;faligny:TalignmentY);
    procedure TextOutBoxSolid(canvas0:TCanvas;X,Y,XX,YY:integer;Text:string;
                         falignx:Talignment;faligny:TalignmentY;backcolor:TColor);
    procedure TextOutBoxD(canvas0:TCanvas;X,Y,XX,YY:integer;text:obrwsk;
                         falignx:Talignment;faligny:TalignmentY);
    procedure GetTextOutBoxDCoord(var r:trect;myLeft,myWidth,
          XX,YY:integer;Text:obrwsk;falignx:Talignment;faligny:TalignmentY);
    function  TextBoxHeight(canvas0:TCanvas;XX:integer;const Text:string):integer;
    function  CharOut  (canvas:TCanvas;X,Y:integer; const ch: char; frame:boolean):integer; {result=width}
    function  isCharInSet(ch:char):boolean;

    property Palette :TPal768 read GetPal write SetPal;

  published
    property CharSpace :shortint read fInterSpace write SetInterSpace default 2;
    property SpaceLength:shortint read fSpaceLength write SetSpaceLength default 4;
    property UhwStrukt:TUhwStrukt read fUhwStrukt write SetUhwStrukt;
  end;
{----------------------------------------------------------------------------}
type
  TUhwPal = class(tcomponent)
  private
   fpal:TPal768;
   fpalname:string;
   procedure SetPalName(s:string);
  public
   constructor Create(AOwner: TComponent); override;
   procedure   LoadFromFile(const Text: string);
   procedure   SaveToFile(const Text: string);
   property    Palette  :TPal768 read FPal write FPal;
  published
    property FileName :string read FPalName write SetPalName;
  end;
{----------------------------------------------------------------------------}
function MakeFromToPalette(a1,a2:TColor):TPal768;
function MakeBlackPalette:TPal768;
function MakeWhitePalette:TPal768;


procedure Register;

implementation
uses DsgnIntf,uhwopen;
{-----------------------------------------------------------------------------}
{------------------------- small utils ---------------------------------------}
{-----------------------------------------------------------------------------}
function copyd(d:obrwsk;i1,i2:word):string;
var a:byte;
begin
 result:='';
 for a:=1 to i2 do
  result:=result+chr(d^[i1+a-1]);
end;
{-----------------------------------------------------------------------------}
function lend(d:obrwsk):word;
begin
 result:=0;
 while (d^[result+1]<>0) do inc(result);
end;
{-----------------------------------------------------------------------------}
function posd(small:string;var d:obrwsk):word;
var i,w,l:word; q:boolean;
begin
 i:=0; l:=lend(d); q:=false;
 while (d^[i+1]<>0) and (i+length(small)<=L) and not q do
 begin
  inc(i);
  if small=copyd(d,i,L) then q:=true;
 end;
 if q then result:=i else result:=0;
end;
{-----------------------------------------------------------------------------}
procedure deleted(var d:obrwsk;i1,i2:word);
begin
 if i1+i2>lend(d) then d^[1]:=0 else move(d^[i1+i2],d^[i1],lend(d)-(i1+i2)+2);
end;
{-----------------------------------------------------------------------------}
function CutWordD(d:obrwsk):string;
var a:word; L:word;
 begin
  a:=0; l:=lend(d);
  while (a+1<=L) and (d^[a+1]=32) do inc(a);
  while (a+1<=L) and not (d^[a+1] in [32]) do  inc(a);
  if a=0 then result:='' else
   begin
    result:=copyd(d,1,a);
    deleted(d,1,a);
   end;
 end;
{-----------------------------------------------------------------------------}
procedure infod(s:string);
begin
 s:=s+chr(0);
 Application.MessageBox(addr(s[1]),'Info', MB_OK);
end;
{-----------------------------------------------------------------------------}
function LoadPal (var f:file;var p1:TPal768):boolean;
var a,a1,a2,a3:byte;
begin
 try
  for a:=0 to 255 do
  begin
   blockread(f,a1,1);
   blockread(f,a2,1);
   blockread(f,a3,1);
   p1[a]:=rgb(a1{*4},a2{*4},a3{*4});
  end;
 except
  infod('Error loading color palette from file.'); exit;
 end;
end;
{-----------------------------------------------------------------------------}
function SavePal (var f:file;var p1:TPal768):boolean;
var a,a1,a2,a3:byte;
begin
 result:=false;
 try
  for a:=0 to 255 do
  begin
   a1:=GetRValue(p1[a]) {div 4}; blockwrite(f,a1,1);
   a2:=GetGValue(p1[a]) {div 4}; blockwrite(f,a2,1);
   a3:=GetBValue(p1[a]) {div 4}; blockwrite(f,a3,1);
  end;
 except
  infod('Error writing palette.'); exit;
 end;
 result:=true;
end;


{===========================================================}
{================ TUHWFONT =================================}
{===========================================================}
procedure Register;
begin
  RegisterComponents('UHO', [TUhwFont,TUhwPal]);
  RegisterComponentEditor(TUhwFont, TUhwEditor);
  RegisterPropertyEditor (TypeInfo(TUhwStrukt), nil, '', TUhwStruktProperty);
end;
{-----------------------------------------------------------------------------}
constructor Tuhwfont.Create(AOwner: TComponent);
var a:byte;
begin
 inherited Create(AOwner);
 finterspace:=2;
 fspacelength:=4;
 fuhwstrukt:=TUhwStrukt.Create;
 fuhwstrukt.parent:=self;
 fuhwstrukt.inittab;
end;
{-----------------------------------------------------------------------------}
destructor Tuhwfont.Destroy;
begin
 uhwstrukt.freetab;
 inherited Destroy;
end;
{-----------------------------------------------------------------------------}
function Tuhwfont.isCharInSet(ch:char):boolean;
begin
 result:=(ch=#32) or (uhwstrukt.tab[ord(ch)]<>nil);
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.SetInterSpace(value:shortint);
begin
 uhwstrukt.r.odstep:=value;
 finterspace:=value;
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.SetSpaceLength(value:shortint);
begin
 uhwstrukt.r.spacja:=value;
 fspacelength:=value;
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.SetPal(value:TPal768);
begin
 uhwstrukt.r.paleta:=value;
end;
{-----------------------------------------------------------------------------}
function Tuhwfont.GetPal:TPal768;
begin
 result:=uhwstrukt.r.paleta;
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.LoadFromFile(const Text: string);
var s:string;
begin
 if pos('.',text)=0 then s:=text+'.UHW' else s:=text;
 uhwstrukt.load(s);
 charspace :=uhwstrukt.r.odstep;
 spacelength:=uhwstrukt.r.spacja;
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.SaveToFile(const Text: string);
var s:string;
begin
 if pos('.',text)=0 then s:=text+'.UHW' else s:=text;
 uhwstrukt.r.odstep:=charspace;
 uhwstrukt.r.spacja:=spacelength;
 uhwstrukt.save(s);
end;
{-----------------------------------------------------------------------------}
function Tuhwfont.TextWidth(const Text: string): Integer;
var a,b:byte;
begin
 result:=UhwStrukt.TextWidth(text);
end;
{-----------------------------------------------------------------------------}
function Tuhwfont.CharOut  (canvas:TCanvas;X,Y:integer; const ch: char; frame:boolean):integer;
begin
 result:=UhwStrukt.CharOut(canvas,x,y,ch,frame);
end;
{-----------------------------------------------------------------------------}
{-----------------------------------------------------------------------------}
{function Tuhwfont.CharOut  (canvas:TCanvas;X,Y:integer; const Znak: char):integer;
var x0,y0:integer;
begin
 if data.tab[ord(znak)]=nil then
 begin
  if znak=' ' then result:=data.spacja else result:=0;
 end else
 with data.tab[ord(znak)]^ do
 begin
  for y0:=0 to yy-1 do
  for x0:=0 to xx-1 do
   if data.font^[wsk+x0+y0*xx]<>data.cTlo then
    bitmap.canvas.pixels[x0,y0+ydown]:=data.paleta[data.font^[wsk+x0+y0*xx]]
     else bitmap.canvas.pixels[x0,y0+ydown]:=clBlack;

  canvas.draw(x,y,bitmap);
  result:=xx;
 end;
end;}
{-----------------------------------------------------------------------------}
procedure Tuhwfont.TextOut (canvas0:TCanvas;X,Y:integer; const Text: string);
begin
 textout2(canvas0,x,y,text);
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.TextOut1 (canvas0:TCanvas;X,Y:integer; const Text: string);
begin
 uhwstrukt.textout1(canvas0,x,y,text);
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.TextOut2 (canvas0:TCanvas;X,Y:integer; const Text: string);
begin
 uhwstrukt.textout2(canvas0,x,y,text);
end;
{-----------------------------------------------------------------------------}
procedure d2Lines(d1:obrwsk;xx:word;var t:T255;f:TUHWFont);
var a,L:integer;
    d:obrwsk;
    q:boolean;
    s1,s2:string;
begin
 L:=Lend(d1); getmem(d,L+10); move(d1^[1],d^[1],L+1);
 repeat
  a:=posd('  ',d);                         {podwjne spacje won!}
  if a<>0 then deleted(d,a,1);
 until a=0;
 a:=1; t.i:=0; s1:='';
 repeat
  s2:='';
  q:=false;
  repeat
   if s1='' then s1:=CutWordd(d);
   if s1='' then q:=true else
  {if s1=#13 then begin s1:=''; q:=true; end else}
   if s2='' then begin s2:=s1; s1:='' end else
   if F.textwidth(s2+s1)<=xx then
   begin
    s2:=s2+s1; s1:='';
    if pos(#13,s2)>0 then q:=true;
   end else q:=true;
 until q;

 if s2<>'' then
 begin
  inc(t.i);
  t.d[t.i]:=length(s2);
 end;
until s2='';

freemem(d,L+10);

end;
{-----------------------------------------------------------------------------}
procedure String2Lines(s:string;xx:word;var t:T255;f:TUHWFont);
var d:obrwsk;
begin
 getmem(d,300); s:=s+#0;
 move(s[1],d^[1],length(s));
 D2Lines(d,xx,t,f);
 freemem(d,300);
end;
{-----------------------------------------------------------------------------}
function Tuhwfont.TextBoxHeight(canvas0:TCanvas;XX:integer;const Text:string):integer;
var tab:T255;
begin
  with Canvas0 do
  begin
    String2Lines(text,xx,tab,self);
    result:=self.fontheight*tab.i;
  end;
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.TextOutBoxD(canvas0:TCanvas;X,Y,XX,YY:integer;Text:obrwsk;
          falignx:Talignment;faligny:TalignmentY);
var x1,y1,a,i:integer;
    s1,s2:string;
    q:boolean;
    tab:T255;
begin
  with Canvas0 do
  begin
    d2Lines(text,xx,tab,self);
    i:=1;
    for a:=1 to tab.i do
    begin
     s1:=copyd(text,i,tab.d[a]);
     while (s1<>'') and (s1[1]=' ') do delete(s1,1,1);
     inc(i,tab.d[a]);
     case fAlignX of
      taCenter       : x1:=(xx-self.textwidth(s1)) div 2;
      taLeftJustify  : x1:=0;
      taRightJustify : x1:=xx-self.textwidth(s1);
     end;
     case fAlignY of
      taCenterY       : y1:=(yy-self.fontheight*tab.i) div 2+(a-1)*self.fontheight;
      taTopJustify    : y1:=(a-1)*self.fontheight;
      taBottomJustify : y1:=yy-self.fontheight*(tab.i-a+1);
     end;
     if s1<>'' then
     begin
      TextOut2 (canvas0,x+x1,y+y1,s1);
     end;
    end;
  end;
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.GetTextOutBoxDCoord(var r:TRect;myLeft,myWidth,
          XX,YY:integer;Text:obrwsk;falignx:Talignment;faligny:TalignmentY);
var x1,y1,xxleft,xxwidth,a,b,i,ispacja:integer;
    s1,s2:string;
    q:boolean;
    tab:T255;
begin
 d2Lines(text,xx,tab,self);
 i:=1; a:=1;
 repeat
  s1:=copyd(text,i,tab.d[a]);
  if myLeft<i+tab.d[a] then
  begin
   b:=myLeft-i+1;
   if b=1 then xxleft:=0 else
   begin
    xxLeft:=TextWidth(copy(s1,1,b-1));
   end;
   s2:=copy(s1,b,myWidth);
   xxwidth:=TextWidth(s2);
  end else s2:='';

  ispacja:=0; while (s1<>'') and (s1[1]=' ') do begin delete(s1,1,1); inc(ispacja); end;
  dec(xxLeft,ispacja*uhwstrukt.r.spacja);
  inc(i,tab.d[a]);

  if s2<>'' then
  begin
  {== x ==}
   case fAlignX of
    taCenter       : x1:=(xx-self.textwidth(s1)) div 2;
    taLeftJustify  : x1:=0;
    taRightJustify : x1:=xx-self.textwidth(s1);
   end;

   case fAlignY of
    taCenterY       : y1:=(yy-self.fontheight*tab.i) div 2+(a-1)*self.fontheight;
    taTopJustify    : y1:=(a-1)*self.fontheight;
    taBottomJustify : y1:=yy-self.fontheight*(tab.i-a+1);
   end;

   r:=Rect(x1+xxLeft,y1,x1+xxLeft+xxWidth,y1+fontheight+1);

  end;
  inc(a);
 until (a>tab.i) or (s2<>'');
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.TextOutBoxSolid(canvas0:TCanvas;X,Y,XX,YY:integer;Text:string;
                         falignx:Talignment;faligny:TalignmentY;backcolor:TColor);
begin
 with canvas0 do
 begin
  pen.style:=psClear;
  brush.style:=bsSolid;
  brush.color:=backcolor;
  rectangle(x,y,x+xx,y+yy);
 end;
 TextOutBox(canvas0,x,y,xx,yy,text,falignx,faligny);
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.TextOutBox(canvas0:TCanvas;X,Y,XX,YY:integer;Text:string;
          falignx:Talignment;faligny:TalignmentY);
var d:obrwsk;
begin
 getmem(d,1000);
 text:=text+#0;
 move(text[1],d^[1],length(text));
 TextOutBoxD(canvas0,x,y,xx,yy,d,falignx,faligny);
 freemem(d,1000);
end;
{-----------------------------------------------------------------------------}
function  Tuhwfont.FontHeight : Integer;
begin result:=uhwstrukt.r.maxy; end;
{-----------------------------------------------------------------------------}
function  Tuhwfont.CopyToFit (xx:word;text:string) : string;
var s1:string;

 function CutWord:string;
 var a:byte;
 begin
  a:=0;
  while (a+1<=length(text)) and (text[a+1]=' ') do
   inc(a);

  while (a+1<=length(text)) and (text[a+1]<>' ') do
   inc(a);
  if a=0 then result:='' else
  begin
   result:=copy(text,1,a);
   delete(text,1,a);
  end;
 end;

begin
 result:='';
 repeat
  s1:=cutWord;
  if result='' then result:=s1 else
   if textwidth(result+' '+s1)<=xx then result:=result+' '+s1
    else s1:='';
 until s1='';
end;
{-----------------------------------------------------------------------------}
procedure Tuhwfont.SetUhwStrukt(value:TUhwStrukt);
begin
 UhwStrukt.Assign(value);
end;

{-----------------------------------------------------------------------------}
{---------------------  TUHWSTRUKT -------------------------------------------}
{-----------------------------------------------------------------------------}

procedure TUHWstrukt.InitTab;
var a:byte;
begin
 r.size:=0;
 for a:=0 to 255 do
  tab[a]:=nil;
end;
{-----------------------------------------------------------------------------}
procedure TUHWStrukt.freeTab;
var a:byte;
begin
 if r.size>0 then freemem(font,r.size);
 r.size:=0;
 for a:=0 to 255 do
  if tab[a]<>nil then begin dispose(tab[a]); tab[a]:=nil; end;
end;
{-----------------------------------------------------------------------------}
const iUhwVersion=2;
      UhwVersion:array[1..iuhwversion] of string[7]=('UHOFONT','UHWFNT1');
      UhwHeader='UHWFNT1';

function TUhwStrukt.Load(s:string):boolean;
var plik : file;
    a,i,ile,index:word;
    bajt:byte;
    v:byte;
    s1:string[7];
begin

 freeTab;

 result:=false;

 AssignFile(plik,s);
 try
  Reset(plik,1);
 except
  infod('File:'+s+' not found.'); exit;
 end;
 try
  s:='';
  for a:=1 to 11 do s:=s+' ';
  blockread(plik,s[1],11);
 except
  infod('Error loading header: '+s);
  try closefile(plik); except; end;
  exit;
 end;

 v:=0;
 s1:=copy(s,1,7);
 for a:=1 to iUhwVersion do
  if s1=UhwVersion[a] then v:=a;

 if v=0 then
 begin
  try closefile(plik); except; end;
  infod('It is not an UHW File!'); exit;
 end;

 r.spacja:=ord(s[8]);
 r.odstep:=ord(s[9]);
 r.ctlo:=ord(s[10]);
 ile:=ord(s[11]);
 r.size:=filesize(plik);
 r.maxY:=0;

 if not LoadPal(plik,r.paleta) then
 begin
  try closefile(plik); except; end;
  infod('Error loading palette from Uhw'); exit;
 end;

 if v=1 then                   {version 0.1-0.2 had 64 values palette and no space,odstep}
 begin
  for a:=0 to 255 do
  begin
   r.paleta[a]:=RGB(4*getRValue(r.paleta[a]),
                    4*getGValue(r.paleta[a]),
                    4*getBValue(r.paleta[a]));
  end;
  r.spacja:=4;
  r.odstep:=1;
 end;

 getmem(font,r.size);
 index:=1;

{ FOR A:=0 to 255 do tab[bajt]:=nil;}

 FOR A:=1 to ILE do
 BEGIN
  try
   blockread(plik,bajt,1);
   new(tab[bajt]);
   with tab[bajt]^ do
   begin
    blockread(plik,Ydown,1);
    blockread(plik,xx,1);
    blockread(plik,yy,1);
    if yy+ydown>r.maxy then r.maxy:=yy+ydown;
    wsk:=index;
    i:=xx*yy;
    blockread(plik,font^[index],i);
    inc(index,i);
   end;
  except
   infod('Error loading char nr='+inttostr(a));
   try closefile(plik); except; end;
   free;
  end;
 END;
 closefile(plik);
 result:=true;
end;
{-----------------------------------------------------------------------------}
function TUhwStrukt.Save(s:string):boolean;
var plik : file;
    a,i,ile,index:word;
    bajt:byte;
begin

 result:=false;
 if s='' then begin infod('Specify UHWFont Filename'); exit; end;

 AssignFile(plik,s);
 try
  ReWrite(plik,1);
 except
  infod('Cannot create file:'+s); exit;
 end;

 ile:=0;
 for a:=0 to 255 do if tab[a]<>nil then inc(ile);
 s:=UHWheader+chr(r.spacja)+chr(r.odstep)+chr(r.cTlo)+chr(ile);
 try
  blockwrite(plik,s[1],length(s));
 except
  infod('Error writing header of UhwFont File.');
  exit;
 end;

 if not SavePal(plik,r.paleta) then
 begin
  try closefile(plik); except; end;
  infod('Error writing palette to UhwFont File'); exit;
 end;

 index:=1;
 a:=0;

 try

 REPEAT
  inc(a);
  if tab[a]<>nil then
  begin
   bajt:=a; blockwrite(plik,bajt,1);
   with tab[a]^ do
   begin
    blockwrite(plik,Ydown,1);
    blockwrite(plik,xx,1);
    blockwrite(plik,yy,1);
    i:=xx*yy;
    blockwrite(plik,font^[wsk],i);
   end;
  end;
 UNTIL a=255;
 closefile(plik);

 except
  infod('Error writing Chars to UhwFont File.');
  try closefile(plik); except; end;
 end;
 result:=true;
end;
{-----------------------------------------------------------------------------}
function  TuhwStrukt.FontHeight : Integer;
begin
 result:=r.maxy;
end;
{-----------------------------------------------------------------------------}
function Tuhwstrukt.TextWidth(const Text: string): Integer;
var a,b:byte;
begin
 result:=0;
 a:=0;
 while a+1<=length(text) do
 begin
  inc(a); b:=ord(text[a]);
  case b of
  32: inc(result,r.spacja);
  255:inc(result,10);
  else if tab[b]<>nil then
   begin
    inc(result,tab[b]^.xx);
    if a<length(text) then inc(result,r.odstep);
   end;
  end;
 end;
end;
{-----------------------------------------------------------------------------}
function TuhwStrukt.CharOut  (canvas:TCanvas;X,Y:integer; const Znak: char; ramka:boolean):integer;
var x0,y0:integer;
begin
 if tab[ord(znak)]=nil then
 begin
  if znak=#32 then result:=r.spacja-r.odstep else
   if znak=#255 then result:=10-r.odstep else result:=0;
 end else
 with tab[ord(znak)]^ do
 begin
   for y0:=0 to yy-1 do
    for x0:=0 to xx-1 do
    if font^[wsk+x0+y0*xx]<>r.cTlo then
    BEGIN
     canvas.pixels[x+x0,y+y0+ydown]:=r.paleta[font^[wsk+x0+y0*xx]];
     if ramka {and (data.font^[wsk+x0+y0*xx] in [6..16])} then
     with canvas do
     begin
      if (y0=0) or (self.font^[wsk+x0+(y0-1)*xx]=r.cTlo) then pixels[x+x0,y+y0+ydown-1]:=0;
      if (y0=yy-1) or (self.font^[wsk+x0+(y0+1)*xx]=r.cTlo) then pixels[x+x0,y+y0+ydown+1]:=0;
      if (x0=0) or (self.font^[wsk+x0-1+y0*xx]=r.cTlo) then pixels[x+x0-1,y+y0+ydown]:=0;
      if (x0=xx-1) or (self.font^[wsk+x0+1+y0*xx]=r.cTlo) then pixels[x+x0+1,y+y0+ydown]:=0;

      if (x0=0)    or (y0=0)    or (self.font^[wsk+x0-1+(y0-1)*xx]=r.cTlo) then pixels[x+x0-1,y+y0+ydown-1]:=0;
      if (x0=xx-1) or (y0=0)    or (self.font^[wsk+x0+1+(y0-1)*xx]=r.cTlo) then pixels[x+x0+1,y+y0+ydown-1]:=0;
      if (x0=0)    or (y0=yy-1) or (self.font^[wsk+x0-1+(y0+1)*xx]=r.cTlo) then pixels[x+x0-1,y+y0+ydown+1]:=0;
      if (x0=xx-1) or (y0=yy-1) or (self.font^[wsk+x0+1+(y0+1)*xx]=r.cTlo) then pixels[x+x0+1,y+y0+ydown+1]:=0;

     end;
    END;
  result:=xx;
 end;
end;
{-----------------------------------------------------------------------------}
procedure TuhwStrukt.TextOut1 (canvas0:TCanvas;X,Y:integer; const Text: string);
var a:byte;
begin
 if r.size=0 then exit;
 a:=1;
 while a<=length(text) do
 begin
  x:=x+CharOut(canvas0,x,y,text[a],false)+r.odstep;
  inc(a);
 end;
end;
{-----------------------------------------------------------------------------}
procedure TuhwStrukt.TextOut2 (canvas0:TCanvas;X,Y:integer; const Text: string);
var a:byte;
    bitmap:Tbitmap;
    x0,y0:integer;
begin
 if r.size=0 then exit;
 bitmap:=Tbitmap.Create;
 bitmap.width:=textwidth(text);
 bitmap.height:=fontheight;
 with bitmap do
  canvas.copyrect(rect(0,0,width,height),canvas0,rect(x,y,x+width,y+height));
 a:=1; x0:=0; y0:=0;
 while a<=length(text) do
 begin
  if (text[a]=' ') or (tab[ord(text[a])]<>nil) then
   x0:=x0+CharOut(bitmap.canvas,x0,y0,text[a],false)+r.odstep;
  inc(a);
 end;
 canvas0.draw(x,y,bitmap);
 bitmap.free;
end;
{-----------------------------------------------------------------------------}
procedure  TUhwStrukt.Assign(source:TUhwStrukt);
var a:byte;
begin
 freeTab;
 r:=source.r;
 parent:=source.parent;

 for a:=0 to 255 do
 begin
  if source.tab[a]=nil then tab[a]:=nil else
  begin
   new(tab[a]);
   tab[a]^:=source.tab[a]^;
  end;
 end;

 getmem(font,r.size);
 move(source.font^,font^,r.size);
end;
{-----------------------------------------------------------------------------}
procedure TUhwStrukt.DefineProperties(Filer: TFiler);
begin
{   infod('defined');}
   inherited DefineProperties(Filer);
   Filer.DefineBinaryProperty('UhwStrukt', LoadFromStream, SaveToStream, true);
end;
{-----------------------------------------------------------------------------}
procedure TUhwStrukt.LoadFromStream(Stream: TStream);
var t:TUhwChar;
    a:byte;
begin
   FreeTab;
   Stream.ReadBuffer(r,SizeOf(r));
{   infod('load:'+str2(r.size));}
   if r.size=0 then exit;
   for a:=0 to 255 do
   begin
    Stream.ReadBuffer(t,sizeof(t));
    if t.xx<>0 then
    begin
     new(tab[a]);
     tab[a]^:=t;
    end;
   end;
   Getmem(font,r.size);
   Stream.ReadBuffer(font^, r.size);
end;
{-----------------------------------------------------------------------------}
procedure TUhwStrukt.SaveToStream(Stream: TStream);
var t:TUhwChar;
    a:byte;
begin
{   infod('save:'+str2(r.size));}
   Stream.WriteBuffer(r,     SizeOf(r));
   if r.size=0 then exit;
   for a:=0 to 255 do
   begin
    if tab[a]<>nil then t:=tab[a]^ else t.xx:=0;
    Stream.WriteBuffer(t,sizeof(t));
   end;
   Stream.WriteBuffer(font^, r.size);
end;

{-----------------------------------------------------------------------------}
{---------------------------  TUHWPAL ----------------------------------------}
{-----------------------------------------------------------------------------}
 constructor TUhwPal.Create(AOwner: TComponent);
 begin
  inherited Create(aowner);
  filename:='';
  fillchar(fpal,768,3);
 end;
{-----------------------------------------------------------------------------}
 procedure TUhwPal.SetPalName(s:string);
 begin
  fpalname:=s;
  if s='' then exit;
  if pos('.',s)=0 then s:=s+'.COL';
  if not (csDesigning in ComponentState) then
  begin
   if pos(':',s)=0 then s:=ExtractFilePath(paramstr(0))+s;
  end;
  loadfromfile(s);
 end;
{-----------------------------------------------------------------------------}
 procedure TUhwPal.LoadFromFile(const text:string);
 var f:file;
 begin
  try
   assignfile(f,text);
   reset(f,1);
   if not loadPal(f,fpal) then infod('Error loading Palette from File:'+text);
   closefile(f);
  except
   infod('Error loading Palette from:'+text);
  end;
 end;
{-----------------------------------------------------------------------------}
 procedure TUhwPal.SaveToFile(const text:string);
 var f:file;
 begin
  try
   assignfile(f,text);
   rewrite(f,1);
   if not savePal(f,fpal) then infod('Error writing Palette to file:'+text);
   closefile(f);
  except
   infod('Error writing palette to:'+text);
  end;
 end;
{-----------------------------------------------------------------------------}
function MakeFromToPalette(a1,a2:TColor):TPal768;

function util(i,v1,v2:byte):byte;
begin
 result:=v1+trunc (i*({v1+}(v2-v1)/255));
end;

var a:byte;
begin
 for a:=0 to 255 do
  result[a]:=rgb(util(a,getrvalue(a1),getrvalue(a2)),
                 util(a,getgvalue(a1),getgvalue(a2)),
                 util(a,getbvalue(a1),getbvalue(a2)));
end;

function MakeBlackPalette:TPal768;
begin
 result:=MakeFromToPalette(clWhite,clBlack);
end;

function MakeWhitePalette:TPal768;
begin
 result:=MakeFromToPalette(clBlack,clWhite);
end;

end.

