unit UAlnEdit;      {UnitAlignEdit}

interface

uses
  WinProcs,WinTypes, Messages, Classes, Controls, StdCtrls, Clipbrd;

type
  TAlignEdit = class(TEdit)
  private
    FAlignment:TAlignment;
  protected
    procedure CreateParams(var Params:TCreateParams); override;
    procedure KeyPress(var Key:Char); override;
    procedure SetAlignment(Value:TAlignment);
    procedure CMEnter(var Msg: TCMGotFocus); message CM_ENTER;
    procedure WMPaste(var Message: TWMPaste);   message WM_PASTE;
  public
    constructor Create(AOwner:TComponent); override;
  published
    property Alignment: TAlignment read FAlignment write SetAlignment default taLeftJustify;
  end;

procedure Register;

implementation

Constructor TAlignEdit.Create(AOwner:TComponent);
begin
   inherited Create(AOwner);
   FAlignment:=taLeftJustify;
end;

procedure TAlignEdit.CreateParams(var Params: TCreateParams);
const
   Alignments: array[TAlignment] of Longint=(ES_LEFT,ES_RIGHT,ES_CENTER);
begin
   inherited CreateParams(Params);
   Params.Style:=Params.Style or ES_MULTILINE or Alignments[FAlignment];
end;

procedure TAlignEdit.KeyPress(var Key:Char);
begin
   inherited KeyPress(Key);
   if (Key=#13) or (Key=#10) then Key:=#0;
end;

procedure TAlignEdit.SetAlignment(Value:TAlignment);
begin
   if FAlignment<>Value then begin
      FAlignment:=Value;
      RecreateWnd;
   end;
end;

procedure TAlignEdit.CMEnter(var Msg:TCMGotFocus);
begin
  if AutoSelect and not (csLButtonDown in ControlState) then SelectAll;
  inherited;
end;

{This code sent to me by Michael Richter mri@ba-glauchau.de}
procedure TAlignEdit.WMPaste(var Message: TWMPaste);
var
  SGlobalHandel  :THandle;
  Ptr            :PChar;
  Size           :Longint;
  i              :Longint;
  s              :string;
begin
 s:='';
 if OpenClipboard(Handle) then begin
  try
   if Clipboard.HasFormat(CF_TEXT) then begin
    SGlobalHandel:=GetClipboardData(CF_TEXT);
    if SGlobalHandel<>0 then begin
     Size:=GlobalSize(SGlobalHandel);
     Ptr :=GlobalLock(SGlobalHandel);
     if Ptr<>nil then begin
      i:=0;
      while (i<size) and (Ptr[i]>=#32) do begin
       s:=s+Ptr[i];
       inc(i);
      end;
     end;
     GlobalUnlock(SGlobalHandel);
     end;
   end;
  finally
   CloseClipboard;
  end;
 end;
 SelText:=s;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TAlignEdit]);
end;

end.
