unit Wavefrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, FileCtrl, Grids, Outline, DirOutln,
  Waveplay;

type
  TWaveForm = class(TForm)
    LabelDirs: TLabel;
    Path: TLabel;
    DirectoryOutline: TDirectoryOutline;
    LabelDrives: TLabel;
    DriveComboBox: TDriveComboBox;
    FileListBox: TFileListBox;
    LabelFiles: TLabel;
    OkBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    WavePlayer1: TWavePlayer;
    procedure DirectoryOutlineChange(Sender: TObject);
    procedure FileListBoxDblClick(Sender: TObject);
    procedure FileListBoxChange(Sender: TObject);
    procedure DriveComboBoxChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WaveForm: TWaveForm;

implementation

{$R *.DFM}

procedure TWaveForm.DriveComboBoxChange(Sender: TObject);
begin
  DirectoryOutline.Drive := DriveComboBox.Drive
end;

procedure TWaveForm.DirectoryOutlineChange(Sender: TObject);
begin
  Path.Caption := DirectoryOutline.Directory;
  FileListBox.Directory := DirectoryOutline.Directory;
end;

procedure TWaveForm.FileListBoxChange(Sender: TObject);
begin
  if (FileListBox.ItemIndex >= 0) then
  begin
    OkBitBtn.Enabled := True;
    try
      Screen.Cursor := crHourGlass;
      try
        with FileListBox do
          WavePlayer1.Wave.LoadFromFile(Items[ItemIndex]);
        WavePlayer1.Play;
      except
        WavePlayer1.Wave.Free;
      end;
    finally
      Screen.Cursor := crDefault;
    end;
  end else OkBitBtn.Enabled := False;
end;

procedure TWaveForm.FileListBoxDblClick(Sender: TObject);
begin
  ModalResult := mrOk
end;

end.
