{*******************************************************
            TWave class Property Editor

This unit contains the code for the TWave class property
editor. This is a dialog based editor which plays the
sound files before you make your selection.

                Paul Warren
       HomeGrown Software Development
     (c) 1995 Langley British Columbia.
              (604) 530-9097
       e-mail:  hg_soft@uniserve.com
  Home page: http://haven.uniserve.com/~hg_soft

********************************************************}

unit Wavedit;

interface

uses DsgnIntf;

type
  TWaveEditor = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

uses SysUtils, Controls, Graphics, TypInfo, WaveFrm, WavePlay;

{ tells Delphi that this is a dialog type property
  editor }
function TWaveEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog]
end {GetAttributes};

{ override of the edit method - this is the nuts
  and bolts of the property editor }
procedure TWaveEditor.Edit;
begin
  with TWaveForm.Create(nil) do
  try
    {WavePlayer1.Wave := TWave(GetOrdValue);}
    if ShowModal = mrOk then
    if (GetPropType^.Name = 'TWave') then
      SetOrdValue(LongInt(WavePlayer1.Wave));
  finally
    Free;
  end
end {Edit};

{ register the property editor for type TWave }
procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TWave), nil,'', TWaveEditor);
end;

end.