unit Sndbtn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, WavePlay, MMSystem;

type
  TSndBitBtn = class(TBitBtn)
  private
    { Private declarations }
    FSound: TWave;
    procedure SetSound(NewSound: TWave);
  protected
    { Protected declarations }
    procedure Play(Sender: TObject);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Click; override;
  published
    { Published declarations }
    property Sound: TWave read FSound write SetSound;
  end;

procedure Register;

implementation

{ construct TSndBitBtn }
constructor TSndBitBtn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  { create class instance }
  FSound := TWave.Create;
end;

destructor TSndBitBtn.Destroy;
begin
  { must make this call or crash and burn }
  sndPlaySound(nil, 0);
  { free class instance }
  FSound.Free;
  inherited Destroy;
end;

{ method to play WaveAudio data }
procedure TSndBitBtn.Play(Sender: TObject);
begin
  sndPlaySound(FSound.WaveData.Memory, snd_Sync or snd_Memory);
end;

procedure TSndBitBtn.Click;
begin
  Play(Self);
  inherited Click;
end;

procedure TSndBitBtn.SetSound(NewSound: TWave);
begin
  FSound.Assign(NewSound);
end;

procedure Register;
begin
  RegisterComponents('Misc', [TSndBitBtn]);
end;

end.
