unit Imagesnd;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, WavePlay, MMSystem;

type
  TImageSnd = class(TImage)
  private
    { Private declarations }
    FSndTrack: TWave;
    procedure SetSndTrack(NewTrack: TWave);
  protected
    { Protected declarations }
    procedure Play(Sender: TObject);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property SndTrack: TWave read FSndTrack write SetSndTrack;
  end;

procedure Register;

implementation

{ construct TImageSnd }
constructor TImageSnd.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  { create class instance }
  FSndTrack := TWave.Create;
  inherited OnClick := Play;
end;

destructor TImageSnd.Destroy;
begin
  { must make this call or crash and burn }
  sndPlaySound(nil, 0);
  { free class instance }
  FSndTrack.Free;
  inherited Destroy;
end;

{ method to play WaveAudio data }
procedure TImageSnd.Play(Sender: TObject);
begin
  sndPlaySound(FSndTrack.WaveData.Memory, snd_ASync or snd_Memory);
end;

procedure TImageSnd.SetSndTrack(NewTrack: TWave);
begin
  FSndTrack.Assign(NewTrack);
end;

procedure Register;
begin
  RegisterComponents('Misc', [TImageSnd]);
end;

end.
