unit Expunit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Convey, Menus, Buttons, Rep;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    ComboBox1: TComboBox;
    Button2: TButton;
    ComboBox2: TComboBox;
    Image1: TImage;
    BitBtn1: TBitBtn;
    SpeedButton1: TSpeedButton;
    Label1: TLabel;
    Edit1: TEdit;
    Memo1: TMemo;
    CheckBox1: TCheckBox;
    RadioButton1: TRadioButton;
    ListBox1: TListBox;
    ScrollBar1: TScrollBar;
    ScrollBox1: TScrollBox;
    SpeedButton2: TSpeedButton;
    BitBtn2: TBitBtn;
    Label2: TLabel;
    Replica1: TReplica;
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    WinCIndex: array[0..100] of integer;
    Larry: Tbitmap;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  I,Count: Integer;
begin
{Create a New Larry Bitmap from Speedbutton1's glyph and store it for drawing later...}
larry:=TBitmap.create;
Larry.width:=SpeedButton1.glyph.width;
larry.height:=SpeedButton1.glyph.height;
larry.Assign(SpeedButton1.glyph);

{Fill ComboBox1 and 2 and Maintain an Index -WinCIndex- of TWinControls}
count:=0;
  for I := 0 to ComponentCount -1 do
     if (Components[I] is TWinControl) then
     begin
       Combobox1.items.add (Components[i].name);
       Combobox2.items.add (Components[i].name);
       WinCindex[count]:=I;
       Inc(Count);
     end;
  combobox1.itemindex:=0;
  combobox2.itemindex:=0;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
Button1.caption:='Draw On ' + combobox1.items[combobox1.itemindex];
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
Button2.caption:='Capture ' + combobox2.items[combobox2.itemindex];
end;

procedure TForm1.Button1Click(Sender: TObject);

begin

Replica1.getcanvas((components[WinCindex[combobox1.itemindex]] as TWincontrol).handle);

Replica1.Canvas.StretchDraw((components[WinCindex[combobox1.itemindex]] as TWincontrol).ClientRect
                           ,larry);

end;

procedure TForm1.Button2Click(Sender: TObject);
var
   ComponentRect: Trect;
begin
ComponentRect:=(components[WinCindex[combobox2.itemindex]] as TWincontrol).clientrect;

{Get Selected ComboBox2 Component's canvas}
Replica1.getcanvas((components[WinCindex[combobox2.itemindex]] as TWincontrol).handle);

{ReSize Image1.Picture.Bitmap to width and height of Selected WinControl}
Image1.Picture.Bitmap.width:=(components[WinCindex[combobox2.itemindex]] as TWincontrol).width;
Image1.Picture.Bitmap.height:=(components[WinCindex[combobox2.itemindex]] as TWincontrol).height;

{Copy...}
Image1.Picture.Bitmap.canvas.copyrect(ComponentRect,
                                      Replica1.canvas,
                                      ComponentRect);
end;

end.
