{ ****************************************************************** }
{                                                                    }
{   VCL component TProgress                                          }
{                                                                    }
{   Enhanced progress bar                                            }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\program files\component create\progress.cd }
{   on 26 Aug 1998 at 21:07                                          }
{                                                                    }
{   Copyright  1998 by Carmi Grushko                                }
{                                                                    }
{ ****************************************************************** }

unit Progress;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics;

type
  TProgress = class(TGraphicControl)
    private
      { Private fields of TProgress }
        FBackColor : TColor;
        FBorderColor : TColor;
        FFromColor : TColor;
        FProgress : Integer;
        FText : TCaption;
        FTextFont : TFont;
        FToColor : TColor;

      { Private methods of TProgress }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
        function GetBackColor : TColor;
        procedure SetBackColor(Value : TColor);
        function GetBorderColor : TColor;
        procedure SetBorderColor(Value : TColor);
        function GetFromColor : TColor;
        procedure SetFromColor(Value : TColor);
        function GetProgress : Integer;
        procedure SetProgress(Value : Integer);
        procedure SetText(Value : TCaption);
        function GetTextFont : TFont;
        procedure SetTextFont(Value : TFont);
        function GetToColor : TColor;
        procedure SetToColor(Value : TColor);
        procedure Paint; override;
        function ReverseBits(number : byte) : byte;
        procedure WMSize(var Message: TWMSize); message WM_SIZE;

    protected
      { Protected fields of TProgress }

      { Protected methods of TProgress }
        procedure Click; override;
        procedure Loaded; override;

    public
      { Public fields and properties of TProgress }

      { Public methods of TProgress }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        function RGBReverse (number : tcolor) : tcolor;

    published
      { Published properties of TProgress }
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property BackColor : TColor
             read GetBackColor write SetBackColor
             default clWhite;
        property BorderColor : TColor read GetBorderColor write SetBorderColor;
        property FromColor : TColor
             read GetFromColor write SetFromColor
             default clLime;
        property Progress : Integer
             read GetProgress write SetProgress
             default 0;
        property Text : TCaption read FText write SetText;
        property TextFont : TFont read GetTextFont write SetTextFont;
        property ToColor : TColor
             read GetToColor write SetToColor
             default clRed;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TProgress with Additional as its
       default page on the Delphi component palette }
     RegisterComponents('Additional', [TProgress]);
end;

{ Method to set variable and property values and create objects }
procedure TProgress.AutoInitialize;
begin
     FBackColor := clWhite;
     FFromColor := clLime;
     FProgress := 0;
     FTextFont := TFont.Create;
     FToColor := clRed;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TProgress.AutoDestroy;
begin
     FTextFont.Free;
end; { of AutoDestroy }

function TProgress.GetBackColor : TColor;
begin
     Result := FBackColor;
end;

procedure TProgress.SetBackColor(Value : TColor);
begin
     FBackColor := Value;
     canvas.brush.color:=value;
     { If changing this property affects the appearance of
       the component, call Invalidate here so the image will be
       updated. }
      Invalidate;
end;

function TProgress.GetBorderColor : TColor;
begin
     Result := FBorderColor;
end;

procedure TProgress.SetBorderColor(Value : TColor);
begin
     FBorderColor := Value;
     canvas.pen.color:=value;
     { If changing this property affects the appearance of
       the component, call Invalidate here so the image will be
       updated. }
      Invalidate;
end;

function TProgress.GetFromColor : TColor;
begin
     Result := FFromColor;
end;

procedure TProgress.SetFromColor(Value : TColor);
begin
     FFromColor := Value;

     { If changing this property affects the appearance of
       the component, call Invalidate here so the image will be
       updated. }
      Invalidate;
end;

function TProgress.GetProgress : Integer;
begin
     Result := FProgress;
end;

procedure TProgress.SetProgress(Value : Integer);
begin
     if (Value <= 100) and (Value <> FProgress) then 
     begin
          FProgress := Value;
          Paint;
     end;
end;

procedure TProgress.SetText(Value : TCaption);
begin
     FText := Value;
     Paint;
end;

function TProgress.GetTextFont : TFont;
begin
     Result := canvas.font;
end;

procedure TProgress.SetTextFont(Value : TFont);
begin
     { Use Assign method because TFont is an object type }
     canvas.Font.Assign(Value);

     { If changing this property affects the appearance of
       the component, call Invalidate here so the image will be
       updated. }
      Invalidate;
end;

function TProgress.GetToColor : TColor;
begin
     Result := FToColor;
end;

procedure TProgress.SetToColor(Value : TColor);
begin
     FToColor := Value;

     { If changing this property affects the appearance of
       the component, call Invalidate here so the image will be
       updated. }
      Invalidate;
end;

{ Override OnClick handler from TGraphicControl }
procedure TProgress.Click;
begin
     { Call method of parent class }
     inherited Click;
end;

constructor TProgress.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     width:=217;
     height:=40;

     canvas.copymode:=cmSrcInvert;
     {canvas.brush.style:=bsClear;}
     { Code to perform other tasks when the component is created }

end;

destructor TProgress.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TProgress.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }

end;

procedure TProgress.Paint;
var x,y : real; 
    r,g,b : byte; 
    i,z : longint; 
    temp : tcolor; 
    TextBuf : tbitmap;
    Buffer : tbitmap;
    x1,y1,x2,y2: longint;
    
begin
     Buffer := TBitmap.Create;
     Buffer.Height := Height;
     Buffer.Width := Width;

     TextBuf := TBitmap.Create;
     TextBuf.height:=canvas.textheight(text);
     TextBuf.width:=canvas.textwidth(text);
     TextBuf.canvas.font:=canvas.font;

     with Buffer.Canvas do 
     begin
          temp:=pen.color;

          brush.color := backcolor;
          pen.color := bordercolor;
          Rectangle (0,0, width, height);


          z:=round((progress/100)*(width-2));
          
          for i:=1 to z do 
          begin
               moveto (i,1);
               x:=i/(width-2);
               y:=1.0-x;

               R:=round((x*GetRValue(tocolor)) + (y*GetRValue(fromcolor)));
               G:=round((x*GetGValue(tocolor)) + (y*GetGValue(fromcolor)));
               B:=round((x*GetBValue(tocolor)) + (y*GetBValue(fromcolor)));

               pen.color:=rgb(r,g,b);
               lineto (i,height-1);
          end;

          pen.color:=temp;
     end;
     
     TextBuf.canvas.font.color:=clBlack;
     TextBuf.canvas.textout (0,0,text);

     y2:=(height div 2) - (TextBuf.height div 2);
     x2:=(width div 2) - (TextBuf.width div 2);

     for y1:=0 to TextBuf.height-1 do
         for x1:=0 to TextBuf.width-1 do 
         begin
              if TextBuf.canvas.pixels[x1,y1]=clBlack then 
                 Buffer.canvas.pixels[x1+x2,y1+y2]:=RGBReverse(TextBuf.canvas.pixels[x1+x2,y1+y2]);
         end;

     Canvas.CopyMode := cmSrcCopy;
     canvas.draw (0,0, Buffer);
         
end;

function TProgress.RGBReverse (number : tcolor) : tcolor;
var r,g,b : byte;
begin
 r:=reversebits(getrvalue(number));
 g:=reversebits(getgvalue(number));
 b:=reversebits(getbvalue(number));
 result:= rgb(r,g,b);
end;

function TProgress.ReverseBits(number : byte) : byte;
         function SetBit (BitNumber : byte ; number : byte ; value : boolean) : byte;
         var x: longint;
         begin
          if bitnumber=1 then x:=1;
          if bitnumber=2 then x:=2;
          if bitnumber=3 then x:=4;
          if bitnumber=4 then x:=8;
          if bitnumber=5 then x:=16;
          if bitnumber=6 then x:=32;
          if bitnumber=7 then x:=64;
          if bitnumber=8 then x:=128;

          if value then number:=number or x;
          if not value then number:=number xor x;
          result:=number;
         end;

         function IsBitSet (BitNumber,number : byte) : boolean;
         var x: byte;
         begin
          result:=false;
          if bitnumber=1 then x:=1;
          if bitnumber=2 then x:=2;
          if bitnumber=3 then x:=4;
          if bitnumber=4 then x:=8;
          if bitnumber=5 then x:=16;
          if bitnumber=6 then x:=32;
          if bitnumber=7 then x:=64;
          if bitnumber=8 then x:=128;

          if number and x = x then result:=true;
         end;


var i : byte;
begin
 for i:=1 to 8 do
  if IsBitSet (i,number) then number:=SetBit (i,number,false) else number:=SetBit (i,number,true);
 result:=number;
end;

procedure TProgress.WMSize(var Message: TWMSize);
var
     W, H: Integer;
begin
     inherited;

     { Copy the new width and height of the component
       so we can use SetBounds to change both at once }
     W := Width;
     H := Height;

     { Code to check and adjust W and H }

     { Update the component size if we adjusted W or H }
     if (W <> Width) or (H <> Height) then
        inherited SetBounds(Left, Top, W, H);

     { Code to update dimensions of any owned sub-components
       by reading their Height and Width properties and updating
       via their SetBounds methods }

     Message.Result := 0;
end;


end.
