unit Totd;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons;

type
  TfTipOfTheDay = class(TForm)
    Bevel1: TBevel;
    bClose: TBitBtn;
    Panel1: TPanel;
    lTitle: TLabel;
    iBulb: TImage;
    lTip: TLabel;
    bNext: TBitBtn;
    cbShowTips: TCheckBox;
    bPrevious: TBitBtn;
    procedure bCloseClick(Sender: TObject);
    procedure bClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    Tips : TStringList;
    procedure GetTip (Next : Boolean);
  public
    { Public declarations }
    CurrentTip : Integer;
  end;

var
  fTipOfTheDay: TfTipOfTheDay;

implementation

{$R *.DFM}

procedure TfTipOfTheDay.bCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfTipOfTheDay.GetTip (Next : Boolean);
var
  Tip, Title : String;
  L : Integer;
begin
  { locate next/previous tip }
  if Next then
    inc (CurrentTip)
  else
    dec (CurrentTip);
  if CurrentTip<0 then CurrentTip:=Tips.Count-1;
  if CurrentTip>=Tips.Count then CurrentTip:=0;
  { get tip and level }
  Tip:=Tips.Strings[CurrentTip];
  case Tip[1] of
    '^'  : Title:='Today''s tip...';
    '?'  : Title:='Did you know...';
    '''' : Title:='Today''s quote...';
    '!'  : Title:='Today''s joke...';
    '#'  : Title:='Today''s message...';
  else
    Title:='';
  end; { case }
  lTitle.Caption:=Title;
  lTip.Caption:=format (Copy(Tip, 2, 255), [#13, #13, #13, #13, #13]); { show it! }
end;

procedure TfTipOfTheDay.bClick(Sender: TObject);
begin
  GetTip (Sender=bNext); { get a tip }
end;

procedure TfTipOfTheDay.FormCreate(Sender: TObject);
begin
  CurrentTip:=0;
  Tips:=TStringList.Create;
  try
    Tips.LoadFromFile ('TIPS.TXT');
  finally
    if Tips.Count=0 then
    begin
      bNext.Enabled:=False;
      bPrevious.Enabled:=False;
    end
    else
    bClick (bNext);
  end; { Try }
end;

procedure TfTipOfTheDay.FormDestroy(Sender: TObject);
begin
  Tips.Free;
end;

end.
