unit Win95gau;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls ,StdCtrls;

type
  TWin95Gauge = class(TGraphicControl)
  private
    FMinValue: Longint;
    FMaxValue: Longint;
    FCurValue: Longint;
    FBoxes: Byte;
    FBoxColor: TColor;
    FBoxW : Integer;
    FBoxH : Integer;
    FColor: TColor;
    FParentColor : Boolean;
    procedure SetBoxWidth(Value: Integer);
    procedure SetBoxHeight(Value: Integer);
    procedure SetMinValue(Value: Longint);
    procedure SetMaxValue(Value: Longint);
    procedure SetProgress(Value: Longint);
    procedure SetBoxColor(Value:TColor);
    procedure SetColor(Value:TColor);
    procedure SetParentColor(Value:Boolean);
    function GetPercentDone: Longint;
    procedure SetBoxes(Value:byte);
    procedure CheckBounds;
    procedure DrawBox;
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure AddProgress(Value: Longint);
    property PercentDone: Longint read GetPercentDone;
  published
    property Align;
    property Boxes: byte read FBoxes write SetBoxes default 15;
    property BoxColor: TColor read FBoxColor write SetBoxColor default clNavy;
    property BoxHeight: Integer read FBoxH write SetBoxHeight default 18;
    property BoxWidth: integer read FBoxW write SetBoxWidth default 12;
    property Color: TColor read FColor write SetColor default clSilver;
    property Enabled;
    property Height;
    property Width;
    property MinValue: Longint read FMinValue write SetMinValue default 0;
    property MaxValue: Longint read FMaxValue write SetMaxValue default 100;
    property ParentColor:Boolean read FParentColor write SetParentColor default True;
    property ParentFont;
    property ParentShowHint;
    property Progress: Longint read FCurValue write SetProgress;
    property ShowHint;
    property Visible;
  end;

procedure Register;

implementation

type
  TBltBitmap = class(TBitmap)
    procedure MakeLike(ATemplate: TBitmap);
  end;

	procedure TBltBitmap.MakeLike(ATemplate: TBitmap);
	begin
	  Width := ATemplate.Width;
	  Height := ATemplate.Height;
	  Canvas.Brush.Color := clWindowFrame;
	  Canvas.Brush.Style := bsSolid;
	  Canvas.FillRect(Rect(0, 0, Width, Height));
	end;


{ This function solves for x in the equation "x is y% of z". }
function SolveForX(Y, Z: Longint): Integer;
begin
  SolveForX := Trunc( Z * (Y * 0.01) );
end;

{ This function solves for y in the equation "x is y% of z". }
function SolveForY(X, Z: Longint): Integer;
begin
  if Z = 0 then SolveForY := 0
  else SolveForY := Trunc( (X * 100) / Z );
end;

{ TGauge }
constructor TWin95Gauge.Create(AOwner: TComponent);
begin
  	inherited Create(AOwner);
  	ControlStyle := ControlStyle + [csFramed, csOpaque];
  	FMinValue := 0;
  	FMaxValue := 100;
  	FCurValue := 0;
    FBoxes := 15;
    FBoxH := 18;
    FBoxW := 12;
    Width := 100;
    Height := 30;
    FBoxColor := clNavy;
    FColor := clSilver;
    FParentColor := True;
end;

function TWin95Gauge.GetPercentDone: Longint;
begin
	GetPercentDone := SolveForY(FCurValue - FMinValue, FMaxValue - FMinValue);
end;

procedure TWin95Gauge.SetBoxWidth(Value:Integer);
begin
   if (Value>256) or (Value<4) then
      MessageDlg('Valid Range 4 ~ 256.',mtWarning,[mbOk],0)
   else begin
      FBoxW := value;
      Width := FBoxes*(FBoxW)+4;
	    Height := FBoxH+3;
 	    SetBounds(Left,Top,Width,Height);
      Invalidate;
   end;
end;

procedure TWin95Gauge.SetParentColor(Value:Boolean);
begin
  FParentColor:=Value;
  Refresh;
end;

procedure TWin95Gauge.SetBoxHeight(Value:Integer);
begin
   if (Value>256) or (Value<4) then
      MessageDlg('Valid Range 4 ~ 256.',mtWarning,[mbOk],0)
    else begin
      FBoxH:=value;
      Width := FBoxes*(FBoxW)+4;
 	    Height := FBoxH+3;
 	    SetBounds(Left,Top,Width,Height);
      Invalidate;
    end;
end;

procedure TWin95Gauge.SetBoxColor(Value:TColor);
begin
  if Value<>FBoxColor then begin
    FBoxColor:=Value;
   	Refresh;
  end;
end;

procedure TWin95Gauge.SetColor(Value:TColor);
begin
  if Value<>FColor then begin
    FColor:=Value;
   	Refresh;
  end;
end;

procedure TWin95Gauge.SetBoxes;
begin
	if FBoxes<>Value then begin
    	if Value<1 then Value:=1;
    	FBoxes:=Value;
    	Width := FBoxes*(FBoxW)+4;
	    Height := FBoxH+3;
	    SetBounds(Left,Top,Width,Height);
      Invalidate;
    end;
end;

(*		*)
procedure TWin95Gauge.CheckBounds;
var maxboxes:word;
begin
	  maxboxes := (Width-4) div (FBoxW);
    if maxboxes<1 then maxboxes:=1;
    if Height<7 then Height:=7;
    if Height>259 then Height:=259;
    FBoxes := maxboxes;
    Width := (maxboxes*FBoxW)+4;
    FBoxH:=Height-3;
    SetBounds(Left,Top,Width,Height);
end;

procedure TWin95Gauge.DrawBox;
var FillSize,k: byte;
    tr : TRect;
    TheRect : TRect;
    bitmap : TBitmap;
    W,H : integer;
begin
  	with Canvas do begin
        try
            	TheRect := ClipRect;
    	     Frame3D(Canvas,TheRect,clGray,clWhite,1);
             bitmap := TBitmap.Create;
             W := TheRect.Right-TheRect.Left+1;
             H := TheRect.Bottom-TheRect.Top+1;
             bitmap.Width := W;
             bitmap.Height := H;
             if FParentColor then begin
                  if (Parent is TForm) then bitmap.canvas.Brush.Color := TForm(Parent).Color;
                  if (Parent is TPanel) then bitmap.canvas.Brush.Color := TPanel(Parent).Color;
                  if (Parent is TGroupBox) then bitmap.canvas.Brush.Color := TGroupBox(Parent).Color;
             end
             else
              bitmap.canvas.Brush.Color := FColor;
   		bitmap.Canvas.Brush.Style := bsSolid;
             bitmap.canvas.FillRect(Rect(0,0,W,H));
            if Enabled then bitmap.canvas.Brush.Color := FBoxColor
            else            bitmap.canvas.Brush.Color := clGray;
    	(**)
   	    FillSize := SolveForX(PercentDone, FBoxes);
             if FillSize>FBoxes then FillSize := FBoxes;
             tr := Rect(TheRect.Left,TheRect.Top,FBoxW,FBoxH);
            for k:=1 to FillSize do begin
             bitmap.canvas.FillRect(tr);
             OffsetRect(tr,FBoxW,0);
           end;
	    (**)
             Canvas.CopyRect(TheRect,bitmap.Canvas,Bounds(0,0,W,H));
             Bitmap.Free;
        except
             Bitmap.Free;
        end;
   end;
end;

(*		*)
procedure TWin95Gauge.Paint;
begin
	CheckBounds;
  DrawBox;
end;

procedure TWin95Gauge.SetMinValue(Value: Longint);
begin
  if Value <> FMinValue then
  begin
    FMinValue := Value;
    Refresh;
  end;
end;

procedure TWin95Gauge.SetMaxValue(Value: Longint);
begin
  if Value <> FMaxValue then
  begin
    FMaxValue := Value;
    Refresh;
  end;
end;

procedure TWin95Gauge.SetProgress(Value: Longint);
begin
	if (FCurValue <> Value) and (Value >= FMinValue) and (Value <= FMaxValue) then
  	begin
    	FCurValue := Value;
    	Refresh;
  	end;
end;

procedure TWin95Gauge.AddProgress(Value: Longint);
begin
	Progress := FCurValue + Value;
  	Refresh;
end;

(*			*)
procedure Register;
begin
  RegisterComponents('ASD', [TWin95Gauge]);
end;

end.
