(* COPYRIGHT CATSOFT 30/07/1996 *)
unit TNAVI;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons;
CONST NUMBTN = 16;
type

TNaviBar  = class(TcustomPanel)
 PRIVATE
    fActiveButton : BYTE;
    fOnValueChange : tNotifyEvent;
    procedure SetActiveButton(value :BYTE);
(*    procedure SetButtons(value :boolean);*)
    procedure itclick(Sender :tObject);
    procedure WMresize(var Message: TWMsize); message WM_size;
 published
    property Align;
    property BevelInner;
    property BevelOuter;
    property BorderStyle;
    property BevelWidth;
    property Caption ;
    property Color;
    property Ctl3D;
    property Cursor;
    property Enabled;
    property Height default 22;
    property Locked;
    property ParentColor;
    property ParentCtl3D;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Width default 448;
    property Visible;
    property ActiveButton :BYTE read fActiveButton write SetActiveButton default 1;
    {set button Save on or off}
{    property Saveoff : boolean  read fButtonoff write SetButtons default true;}
    property Onclick : tNotifyEvent read fOnValueChange write fOnValueChange;
(*{    property OnValueChange :tNotifyEvent;} *)
 public
   BTNS : ARRAY[1..NUMBTN] OF TSPEEDBUTTON;
   constructor Create(aOwner :tComponent); override;
   Destructor Destroy; Override;
   procedure setit(const n : byte; b : boolean);
 END;

procedure Register;

implementation

{$r NAVIGATR.RES}

procedure TNaviBar.setit(const n : byte; b : boolean);
begin
if n > numbtn then exit;
btns[n].enabled := b;
btns[n].showhint := b;
btns[n].invalidate;
end;

procedure TNaviBar.WMresize;
begin
height := BTNS[1].height + 6;
caption := '';
if width > btns[NUMBTN].left + (btns[NUMBTN].width * 2) then
begin
  btns[15].left := width - (btns[15].width * 3);
  btns[NUMBTN].left := btns[15].left + btns[15].width;
end
else
begin
  btns[15].left := btns[14].left +  (btns[14].width * 2);
  btns[NUMBTN].left := btns[15].left + btns[15].width;
end;
inherited;
end;

(*procedure TNaviBar.SetButtons(value :boolean);
begin
 fButtonoff := value;
 BTNS[4].enabled := fButtonoff;
{ invalidate;}
end;
*)
procedure TNaviBar.SetActiveButton(value :BYTE);
begin
  fActiveButton := value;
end;

Destructor TNaviBar.Destroy;
var i : byte;
begin
for i := 1 to NUMBTN do
 removecontrol(btns[i]);
inherited Destroy;
end;

CONSTRUCTOR TNaviBar.Create(aOwner :tComponent);
VAR I : BYTE;
    M : INTEGER;
begin
inherited Create(aOwner);
M := 0;
FOR I := 1 TO NUMBTN DO
BEGIN
  BTNS[I] := TSPEEDBUTTON.CREATE(SELF);
  BTNS[I].showhint := true;
  case i of
   1:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_2'));
     BTNS[I].hint := 'Insert new record';
     end;
   2:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_1'));
     BTNS[I].hint := 'Search a record';
     end;
   3:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_3'));
     BTNS[I].hint := 'Delete current record';
     end;
   4:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_4'));
     BTNS[I].hint := 'Save changes';
     BTNS[I].ENABLED := FALSE;
     end;
   5:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_5'));
     BTNS[I].hint := 'Clone current record';
     end;
   6:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_6'));
     BTNS[I].hint := 'List records';
     end;
   7:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_13'));
     BTNS[I].hint := 'Mark record';
     end;
   8:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_14'));
     BTNS[I].hint := 'Print record';
     end;
   9:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_15'));
     BTNS[I].hint := 'Clear field';
     end;
   10:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_16'));
     BTNS[I].hint := 'Clear screen';
     end;
   11:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_7'));
     BTNS[I].hint := 'First record';
     end;
   12:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_8'));
     BTNS[I].hint := 'Previous record';
     end;
   13:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_9'));
     BTNS[I].hint := 'Next record';
     end;
   14:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_10'));
     BTNS[I].hint := 'Last record';
     end;
   15:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_11'));
     BTNS[I].hint := 'General Help';
     end;
   16:begin BTNS[I].GLYPH.HANDLE := LOADBITMAP(HINSTANCE, PCHAR('BITMAP_12'));
     BTNS[I].hint := 'Exit';
     end;
  end;
  BTNS[I].tag := i;
  BTNS[I].TOP := 3;
  BTNS[I].NUMGLYPHS := 2;
  BTNS[I].VISIBLE := TRUE;
  BTNS[I].onclick := itclick;
  IF (I = 5) or (i = 9) or (i = 11) or (i = 15) THEN
    M := M + BTNS[I].WIDTH ;
  BTNS[I]. LEFT := (I - 1) * BTNS[I].WIDTH + M + 6;
  INSERTCONTROL(BTNS[I]);
END;
height := BTNS[1].height + 6;
caption := '';
fActiveButton := 0;
end;

procedure TNaviBar.itclick;
begin
 IF BTNS[4].ENABLED THEN
    BTNS[4].ENABLED := FALSE;
if Assigned(FOnValueChange) then
    FOnValueChange(Self);
end;

procedure Register;
begin
  RegisterComponents('Add ons', [TNaviBar]);
end;

end.
