unit Tips;

{***********************************************

Hi, my name's Nuno and I'm from Portugal.
This is my first component, so sorry about the
mess. I know the code isn't the best but I'm
trying to improve.
The component is a Tip Dialog like in the Microsoft
Applications

This component has 4 files:
  - TIPS.PAS         Core of the component
  - TIPS.DCR         Component Palette Icon
  - FORMTIPS.PAS     Coding for the form
  - FORMTIPS.DFM     Corresponding form file

To install the component it's easy. Just choose
in the IDE 'Options'|'Install Components'|'Add'
and then place the this filename '<path>\TIPS.PAS'

This component is freeware, do what you like with
him, but don't blame me if something goes wrong.
This is my contribution to the freeware components.

Thanks to all the guys that had maked or are making
freeware components, it's because of them that I,
and many other, had learned a lot.

'PLEASE! If you have any component that you could share
with others. SHARE IT.
Think like this, if anybody, for instance, give one
component for the public domain, he doesn't lose
almost nothing (maybe some hours, some coffes,
some popcorns and cokes)! But think! There are
thousands of guys out there that could make
something, so it represents thousands of components
( some bad and some good ) but nevertheless it's
information passing through.

Enjoy this component. If you make any modification
please let me know. Comments and/or suggestions
are welcome.

Nuno Miguel Antunes
PORTUGAL <- great place
Internet e-mail: nmp@rumos.pt

******************************************}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FormTips;

type
  TTips = class(TComponent)
  private
    FHeader : string;
    FTipHelp : string;
    FTitle : string;
    FShowAtStart : boolean;
    FTips : TStringList;
    function GetTipsCount: word;
    procedure SetTips(Value:TStringList);
  protected
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
    Function Execute : boolean;
  published
    Property Title : string read FTitle write FTitle ;
    Property Header : string read FHeader write FHeader ;
    Property TipHelp : string read FTipHelp write FTipHelp;
    Property ShowAtStart : boolean read FShowAtStart write FShowAtStart ;
    Property Tips : TStringList read FTips write SetTips;
    Property TipsCount : word read GetTipsCount;
end;

Var
  TipsDlg : TTipForm;

procedure Register;

implementation

procedure Register;
begin
  { Register component }
  RegisterComponents('Add Ons 10',[TTIPS]);
end;

constructor TTips.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  { Create TStringList to store Tips }
  FTips := TStringList.Create;
end;

destructor TTips.Destroy;
begin
  { Free TStringList }
  FTips.Free;
  inherited Destroy;
end;

procedure TTips.SetTips(Value:TStringList);
begin
  If FTips <> Value then
     FTips.Assign( Value )
end;

function TTips.GetTipsCount:Word;
begin
  Result := Tips.Count;
end;

function TTips.Execute: Boolean;
begin
     { Create tips dialog in memory }
     TipsDlg := TTipForm.Create(Application);

     { Place property values }
     TipsDlg.Caption := Title;
     TipsDlg.TipHeader.Caption := Header;
     TipsDlg.TipHelp.Caption := TipHelp;
     TipsDlg.ShowAtStart.Checked := ShowAtStart;
     TipsDlg.TipText.Caption := '';
     TipsDlg.Tips.Assign( Tips );

     With TipsDlg do begin
        Result := (ShowModal = IDOK);
     end;

     { Store value from dialog before freeing}
     ShowAtStart := TipsDlg.ShowAtStart.Checked;

     { Free tips dialog from memory }
     TipsDlg.Free;
end;


end.

