unit FormTips;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TTipForm = class(TForm)
    Panel1: TPanel;
    TipText: TLabel;
    ShowAtStart: TCheckBox;
    Ok: TButton;
    Next: TButton;
    Image1: TImage;
    TipHelp: TLabel;
    TipHeader: TLabel;
    Bevel1: TBevel;
    procedure OkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure NextClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
     Tips : TStringList;
    { Public declarations }
  end;

implementation

{$R *.DFM}

Var
  NumTip : Word;

procedure TTipForm.OkClick(Sender: TObject);
begin
  Close;
end;

procedure TTipForm.FormCreate(Sender: TObject);
begin
  Tips := TStringList.Create;
end;

procedure TTipForm.FormShow(Sender: TObject);
begin
  If Tips.Count = 0 Then
     Tips.Add('There is no tip... Im not in the mude.');

  If Tips.Count = 1 Then
     Next.Enabled := False;

  Randomize;
  NumTip := Random( Tips.Count );
  TipText.Caption := Tips.Strings[ NumTip ];
end;

procedure TTipForm.NextClick(Sender: TObject);
begin
  NumTip := Random( Tips.Count );
  TipText.Caption := Tips.Strings[ NumTip ];
end;

procedure TTipForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Tips.Free;
end;

end.
