{=============================================}
{                                             }
{ James L. Allison                            }
{ 1703 Neptune Lane                           }
{ Houston, Texas  77062                       }
{ INTERNET:71565.303@compuserve.com           }
{                                             }
{ Released to public domain.                  }
{ Nov 6, 1994                                 }
{                                             }
{=============================================}

{=============================================}
{converted to a Delphi component              }
{ by D. Heijl                                 }
{ Danny.Heijl@cevi.be                         }
{ dec 17, 1996                                }
{=============================================}


unit Traverse;
interface

uses
  SysUtils, Classes;
  {+F}

type

  EFtwException = class(Exception);

{
  Action is returned by the OnProces_File function
}

  Action = (Finished, FindMore);

{
  OnProcess_File is a user written procedure that does something
  to a file.  It then returns either Finished, telling Walk_Tree
  to quit, or CONTINUE, telling Walk_Tree to keep going.
}

  TOnProcess_File = function (Path: string; Info: tSearchRec): Action of object;

  TFtw = class (Tcomponent)
  private
    FOnProcessFile : TOnProcess_File;
    FRecursive     : Boolean;
    FStartPath     : TFilename;
    FAttr          : Integer;
    FFilter        : string;
    FFilePattern   : string;

    procedure Walk_Tree(Start: string;
                        Attr: Integer;          {see FindFirst}
                        Recursive: boolean;     {walk into subtrees}
                        DoIt: TOnProcess_File); {called for each hit}

  public
    property Attr         : Integer         read FAttr          write Fattr;

    constructor Create(AOwner: Tcomponent); override;
    destructor Destroy; override;

    function Execute: Boolean;

  published
    property OnProcessFile: TOnProcess_File read FOnProcessFile write FOnProcessFile;
    property Recursive    : Boolean         read FRecursive     write FRecursive
                            default True;
    property StartPath    : TFilename       read FStartPath     write FStartPath;
    property Filter       : string          read FFilter        write FFilter;
  end;


{
  In the following, start is the path name of the directory where
  traversal is to start.  IT DOES NOT HAVE A TRAILING \ OR A
  FILE PATTERN.
}



(*----------------------------------------------------------------------------*)
implementation

(*----------------------------------------------------------------------------*)

constructor Tftw.Create(AOwner: Tcomponent);
begin
  inherited Create(Aowner);
  FStartPath := 'c:\';
  FRecursive := True;
  FOnProcessFile := nil;
  FFilter := '*.*';
  FAttr := faAnyFile;

end;

destructor Tftw.Destroy;
begin
   inherited Destroy;
end;


procedure TFtw.Walk_Tree(Start: string;
                    Attr: Integer;
                    Recursive: boolean;
                    DoIt: TOnProcess_File);


  var
    SR: tSearchRec;
    Temp: string;
    Status:integer;

  begin

    if Start[Length(Start)] = '\' then
{$IFDEF WIN32}
      SetLength(Start, Length(Start) -1); { strip trailing '\' just in case}
{$ELSE}
      Delete(Start,Length(Start), 1);
{$ENDIF}
    Temp := Start + FFilePattern;
    Status:=FindFirst(Temp, Attr, SR);

    while Status = 0 do
      begin
        if DoIt(Start, SR) = Finished then EXIT;

        if ((SR.Attr and faDirectory) <> 0)
           and (SR.name <> '.')
           and (SR.name <> '..')
           and Recursive
           then Walk_Tree(Start + '\' + SR.name, Attr, Recursive, DoIt);

        Status:=FindNext(SR);
      end;

    FindClose(Sr);          { Needed for WIN32, harmless for WIN16 -dh- } 
  end;

function TFtw.Execute: Boolean;
begin
  if not assigned(FOnProcessFile) then begin
    Result := False;
    raise EFtwException.Create('TFtw : OnProcessFile function has not been assigned');
    exit;
  end else begin
    FFilePattern := FFilter;
    if FFilePattern[1] <> '\' then insert('\',FFilePattern,1);
    if Length(FFilePattern) = 0 then FFilePattern := '\*.*';

    Walk_Tree(FStartPath, FAttr, Frecursive, FOnProcessFile);

    Result := True;
  end;
end;

end.

