unit Ufromtod;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Mask, ExtCtrls, Buttons, Grids, Calendar,
  UCalenda;

Const IdiomBadFromDate='"From" Date invalid';
      IdiomBadToDate  ='"To" Date invalid';
      IdiomLowerToDate='The "To" Date is lower than "From" Date';
      IdiomCaption    ='DATE RANGE SELECTION (FROM --> TO)';
      IdiomWholeYear   ='&Whole year';
      IdiomThisYear    ='&This Year till TODAY';

type
  TFromToDlg = class(TForm)
    Months: TRadioGroup;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Button1: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Button2: TButton;
    Anys: TComboBox;
    Label3: TLabel;
    FromEdit: TMaskEdit;
    ToEdit: TMaskEdit;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    PUp: TSpeedButton;
    PDown: TSpeedButton;
    procedure MonthsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AnysChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Button1Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure BitBtn1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure FromEditChange(Sender: TObject);
    procedure Calendari1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FromEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ToEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Calendari1DblClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    Procedure Fill;
  public
    { Public declarations }
    Calendar1:TCalendari;
    E:TMaskEdit;
    procedure Calendari;
    Procedure HideCalendar;
  end;

Function DaysInMonth(Mes,Anyo:Word):Word;

implementation

{$R *.DFM}

Function DaysInMonth(Mes,Anyo:Word):Word;
Const DiasMeses:Array[1..12] of Byte=(31,28,31,30,31,30,31,31,30,31,30,31);
Begin
  if Mes=2 then
  Begin
    if ((Anyo mod 4)=0) and
      ( ((Anyo mod 100)<>0) or ((Anyo mod 1000)=0) ) then result:=29
                                                     else result:=28;
  End
  Else result:=DiasMeses[Mes];
End;

procedure TFromToDlg.MonthsClick(Sender: TObject);
Var Any:Word;
begin
  Any:=StrToInt(Anys.Text);
  With Months do
  Begin
    FromEdit.Text:=DateToStr(EncodeDate(Any,ItemIndex+1,1));
    ToEdit.Text:=DateToStr(EncodeDate(Any,ItemIndex+1,DaysInMonth(ItemIndex+1,Any)));
  End;
end;

Procedure TFromToDlg.Fill;
Var t,Any,Mes,Dia:Word;
begin
  Months.Items.Clear;
  for t:=1 to 12 do Months.Items.Add(LongMonthNames[t]);
  DecodeDate(Date,Any,Mes,Dia);
  With Anys do
  Begin
    Items.Clear;
    for t:=Any-5 to Any+10 do Items.Add(IntToStr(t));
    ItemIndex:=5;
  End;
  with Months do ItemIndex:=Mes-1;
end;

procedure TFromToDlg.FormCreate(Sender: TObject);
Begin
  Calendar1:=TCalendari.Create(Self);
  Calendar1.Visible:=False;
  Calendar1.Parent:=Self;
  Calendar1.OnDblClick:=Calendari1DblClick;
  SpeedButton1.Glyph:=PDown.Glyph;
  SpeedButton2.Glyph:=PDown.Glyph;
  Button1.Caption:=IdiomThisYear;
  Button2.Caption:=IdiomWholeYear;
  Fill;
end;

procedure TFromToDlg.AnysChange(Sender: TObject);
begin
  MonthsClick(Self);
end;

procedure TFromToDlg.Button2Click(Sender: TObject);
Var any:Word;
Begin
  Any:=StrToInt(Anys.Text);
  FromEdit.Text:=DateToStr(EncodeDate(Any,1,1));
  ToEdit.Text:=DateToStr(EncodeDate(Any,12,31));
  Months.ItemIndex:=-1;
end;

procedure TFromToDlg.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
Var tmpDesde,tmpFins :TDateTime;
    Correcte:Boolean;
begin
  if ModalResult=mrCancel then Exit;
  Correcte:=True;
  try
    tmpDesde:=StrToDate(FromEdit.Text);
  except
   on Exception do
   Begin
     ShowMessage(IdiomBadFromDate);
     correcte:=False;
   End;
  end;
  try
    tmpFins:=StrToDate(ToEdit.Text);
  except
   on Exception do
   Begin
     ShowMessage(IdiomBadToDate);
     correcte:=False;
   End;
  end;
  if correcte And (tmpDesde>tmpFins) then
  Begin
    ShowMessage(IdiomLowerToDate);
    Correcte:=False;
  End;
  CanClose:=Correcte;
end;

procedure TFromToDlg.Button1Click(Sender: TObject);
Var Any,Mes,Dia:Word;
begin
  DecodeDate(Date,Any,Mes,Dia);
  Anys.ItemIndex:=5;
  Months.ItemIndex:=Mes-1;
  FromEdit.Text:=DateToStr(EncodeDate(Any,Mes,1));
  ToEdit.Text:=DateToStr(EncodeDate(Any,Mes,Dia));
end;

procedure TFromToDlg.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
  begin
    Key := #0;
    PostMessage(Handle, WM_NEXTDLGCTL, 0, 0);
  end;
end;

procedure TFromToDlg.BitBtn1Click(Sender: TObject);
begin
  ModalResult:=mrOk;
end;

procedure TFromToDlg.SpeedButton1Click(Sender: TObject);
begin
  if Calendar1.Visible and (E=FromEdit) then HideCalendar
  else
  Begin
    SpeedButton1.Glyph:=PUp.Glyph;
    E:=FromEdit;
    Calendari;
  end;
end;

procedure TFromToDlg.Calendari;
Var P:TControl;
begin
  With Calendar1 do
  Begin
    CalendarDate:=StrToDate(E.Text);
    Left:=E.Left;
    P:=E.Parent;
    While P<>Self do
    Begin
      Left:=Left+P.Left;
      P:=P.Parent;
    end;
    Top:=E.Top+E.Height;
    P:=E.Parent;
    While P<>Self do
    Begin
      Top:=Top+P.Top;
      P:=P.Parent;
    end;
    Visible:=True;
    SetFocus;
  end;
end;

procedure TFromToDlg.SpeedButton2Click(Sender: TObject);
begin
  if Calendar1.Visible and (E=ToEdit) then HideCalendar
  else
  Begin
    SpeedButton2.Glyph:=PUp.Glyph;
    E:=ToEdit;
    Calendari;
  end;
end;

procedure TFromToDlg.FromEditChange(Sender: TObject);
begin
  if Calendar1.Visible and (Sender=E) then Calendari;
end;

procedure TFromToDlg.Calendari1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_RETURN then HideCalendar;
end;

procedure TFromToDlg.HideCalendar;
Begin
  SpeedButton1.Glyph:=PDown.Glyph;
  SpeedButton2.Glyph:=PDown.Glyph;
  E.Text:=Calendar1.DateSt;
  E.SetFocus;
  Calendar1.Visible:=False;
end;

procedure TFromToDlg.FromEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_DOWN then SpeedButton1Click(Self);
end;

procedure TFromToDlg.ToEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_DOWN then SpeedButton2Click(Self);
end;

procedure TFromToDlg.Calendari1DblClick(Sender: TObject);
begin
  HideCalendar;
end;

procedure TFromToDlg.FormShow(Sender: TObject);
Var d,m1,m2,y1,y2:Word;
begin
  Caption:=IdiomCaption;
  DecodeDate(StrToDate(FromEdit.Text),y1,m1,d);
  DecodeDate(StrToDate(ToEdit.Text),y2,m2,d);
  if (y1=y2) and (m1=m2) then Months.ItemIndex:=m1-1
                         else Months.ItemIndex:=-1;
end;

procedure TFromToDlg.FormDestroy(Sender: TObject);
begin
  Calendar1.Destroy;
end;

end.
