unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, IniFiles,
  Unit2, Ubag, DB, DBTables, DBCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    lb1: TListBox;
    Memo1: TMemo;
    Button2: TButton;
    Memo2: TMemo;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  FormPlace: TBag;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  ix: integer;
  sName,sValue: string;
begin
  with TBag.Create(nil) do try
    SetString('newitem1','newvalue1');
    SetString('newitem2','newvalue2');
    IniFile := 'c:\windows\system.ini';
    IniSect := 'DRIVERS';
    ReadIni;
    for ix := 1 to Count do begin
      GetByIndex(ix,sName,sValue);
      lb1.items.add(sName+'  =  '+sValue);
    end;
    Inifile := 'c:\temp.ini';
    Inisect := 'XXXXXX';
    WriteIni;
    DelValue('newitem2');
    DelValue('newitem2');
    Inisect := 'YYYYY';
    WriteIni;
  finally
    Free;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var tf: TFont;
begin
  with TBag.Create(nil) do begin
    try
      Memo2.Color := GetColor('Memo_C',Memo1.Color);
      Memo2.Font := GetFont('Memo_F',Memo1.Font);
    finally
      Free;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Form2 := nil;
  FormPlace := TBag.Create(nil);
  with FormPlace do begin
    Inifile := 'c:\tbag.ini';
    Inisect := 'MIKE';
    ReadIni;
    GetFormPlace('MAIN_FORMPLACE',Self);
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with FormPlace do begin
    SetFormPlace('MAIN_FORMPLACE',Self);
    if Form2 <> nil then SetFormPlace('SUB_FORMPLACE',Form2 as Tform);
    WriteIni;
    Free;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if Form2 = nil then begin
    Form2 := TForm2.Create(Application);
    FormPlace.GetFormPlace('SUB_FORMPLACE',Form2 as Tform);
  end;
  Form2.Show;
end;

end.
