unit AmUnLock;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, Buttons; 

type
  Tfrm_LockPassword = class(TForm)
    txt_password: TMaskEdit;
    label1: TLabel;
    txt_verify: TMaskEdit;
    cmd_OK: TBitBtn;
    cmd_cancel: TBitBtn;
    Label2: TLabel;
    procedure cmd_OKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frm_LockPassword: Tfrm_LockPassword;

implementation

{$R *.DFM}

procedure Tfrm_LockPassword.cmd_OKClick(Sender: TObject);
begin
  // set password to min 5 chars
	if Length(txt_password.Text) < 5 then
  begin
  	ShowMessage ('Password should be at least 5 characters long.');
    txt_password.SetFocus;
  end

  // strip leading blanks from passwords
  // do case insensitive compare
  else if UpperCase(Trim(txt_password.Text)) <> UpperCase(Trim(txt_verify.Text)) then
  begin
    ShowMessage ('Passwords do not match.');
    txt_verify.SetFocus;
  end

  else
  	ModalResult := mrOK;
end;

end.

