{
TAmLockApp Component

Author:         Dr. Sumeet Kumar
Last Modified:  9th August 1996

Inspired By:    Chapter 11 in "Zen of Windows 95 Programming" by Lou Grinzo
                The code follows the structure suggested by Lou in the book
                - in fact I have copied the C++ code en bloc and then modfied
                  it for Delphi and converted it to a component.

Purpose:
  * To provide a component that allows the user to "Lock" the application
    with a password e.g. when leaving the computer for a while.
  * When the application is "Locked", it is iconized and the icon changed.
    All open documents are preserved intact.
  * The application cannot be restored unless the same password is reentered.

  Thus, it is possible to protect private/sensitive data from prying eyes
  while the user is away from the computer. As soon as he/she returns, it only
  remains to click on the icon, re enter the password and he/she can start working
  again without a break.

Usage:
  1. Drop the component onto the applications main form (from the Samples Page).
  2. Load appropriate icons for the applications Locked and Unlocked states
  	 into the LockedIcon and UnlockedIcon properties.
  3. On the Main form, in response to a menu selection, call the components
  	 OnLockUnlock to Lock the application.

  That's it - the component does the rest.

Delph Versions:
	 * 2.0
	 * should work with Delphi 1.0 also - I haven't tried it

Constituent Files:
 * AmLock.pas & .dcr : the component unit and .dcr file
 * AmLckPwd.pas & .dfm: The Lock Password Form
 * AmUnLock.pas & .dfm: The Un Lock Password Form
 * Readme.txt
	

Nature:
  FREEWARE - copy it, modify it, distribute it but please don't cahrge for it.

A Request:
  Whether you like, love or hate this component, please let me have your feedback
  Also I would appreciate copies of any modifications/improvements you may make.

My Email address:
  sumeet@giasbg01.vsnl.net.in

About Myself:
  I am a General Surgeon addicted to programming. In the day I practice Surgery
  in Bangalore, India and by night I fool around with the computer.

  I have been developing clinic and hosiptal oriented software with MS Access 2.0
  for the past 3 years and have switched to Delphi recently.

}

unit AmLock;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons;

type

	TAmLockApp = class(TComponent)
	  private
      bLocked: Boolean;
      strPassword: string;
    	FLockedIcon: TIcon;
      FUnLockedIcon: TIcon;

      procedure SetLockedIcon (Value: TIcon);
      procedure SetUnLockedIcon (Value: TIcon);

      function RetrieveLockedStatus: Boolean;
      function SaveLockedState: Boolean;
      function LockPWDlg: Boolean;
      function UnlockPWDlg: Boolean;
      function IsLocked: Boolean;
      procedure DoLockUnlock;

			function  HookProc(var Message: TMessage): boolean;

    protected

    public
			constructor Create(AOwner: TComponent); override;
	    destructor Destroy; override;

      procedure OnLockUnlock;

    published
  		property LockedIcon: TIcon read FLockedIcon write SetLockedIcon;
			property UnLockedIcon: TIcon read FUnLockedIcon write SetUnLockedIcon;

  end;

procedure Register;

{==========================================================}
implementation
uses
	AmLckPwd, AmUnLock;


{------------------------------------------------------------------------------------}//
// Call this from the main form in order to lock the application
procedure TAmLockApp.OnLockUnlock;
begin
  // We only call DoLockUnlock() on a verified state change.
  if(IsLocked) then
	begin
    if not (UnlockPWDlg) then       // FALSE: We're now unlocked
      DoLockUnlock;
	end
  else
	begin
    if (LockPWDlg) then          // TRUE: We're now locked
      DoLockUnlock;
	end;
end;

{==========================================================}
constructor TAmLockApp.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  bLocked := False;
  strPassword := '';
  FLockedIcon := TIcon.Create;
  FUnLockedIcon := TIcon.Create;

  // install MainWindow hook - this allows us to trap WM_SYSCOMMAND messages
  Application.HookMainWindow(HookProc);
end;

destructor TAmLockApp.Destroy;
begin
  // deinstall MainWindow hook
	Application.UnHookMainWindow(HookProc);

  // free icons
  FLockedIcon.Free;
  FUnLockedIcon.Free;

  inherited Destroy;
end;

{------------------------------------------------------------------------------------}
// Set methods for icons
procedure TAmLockApp.SetLockedIcon (Value: TIcon);
begin
	FLockedIcon.Assign(Value);
end;

procedure TAmLockApp.SetUnLockedIcon (Value: TIcon);
begin
	FUnLockedIcon.Assign(Value);
end;
{----------------------------------------------------------}
// trap and handle WM_SYSCOMMAND [SC_RESTORE , SC_MAXIMIZE] messages
function TAmLockApp.HookProc(var Message: TMessage): Boolean;
begin
  Result := False;
  with message do
  begin
    case msg of
      WM_SYSCOMMAND:
      // if Locked, restore/maximize only if valid password entered
      	begin
        	if (wParam = SC_RESTORE) or (wParam = SC_MAXIMIZE) then
          begin
            if (IsLocked) then
              OnLockUnlock;
            if IsLocked then
              msg := WM_NULL;
          end;
	      end; // WM_SYSCOMMAND:
    end; // case
  end; // with
end; // proc
{----------------------------------------------------------}
// this function is useful if you choose to store the password in
// a persistent form between sessions
function TAmLockApp.RetrieveLockedStatus: Boolean;
begin
  // set locked to false in case retrieval fails for some reason
  bLocked := FALSE;

  // retrieve password here

  // return Value
  Result :=  bLocked;
end;

{------------------------------------------------------------------------------------}
// see comments for RetrieveLockedStatus above
function TAmLockApp.SaveLockedState: Boolean;
begin
  // return true anyway
  Result := TRUE;

 // save password here

end;

{------------------------------------------------------------------------------------}
// show Lock Password Dialog
function TAmLockApp.LockPWDlg: Boolean;
var
	AForm: Tfrm_LockPassword;
begin
  AForm := Tfrm_LockPassword.Create(Application);
  try
    AForm.ShowModal;
    if AForm.ModalResult = mrOK then
    begin
      // password is case insensitive to decrease hassle for user
      strPassword := UpperCase(Trim(AForm.txt_password.Text));
      bLocked := True;
    end
    else
    begin
      bLocked := False;
    end;
  finally
	 	Result := bLocked;
  	AForm.Free;
  end;

end;

{------------------------------------------------------------------------------------}
// show UnLock Password Dialog
function TAmLockApp.UnlockPWDlg: Boolean;
var
	AForm: Tfrm_UnlockPassword;
begin

  AForm := Tfrm_UnlockPassword.Create(Application);
  try
    AForm.ShowModal;
    if AForm.ModalResult = mrOK then
    begin
      if UpperCase(AForm.txt_password.Text) = UpperCase(strPassword) then
      	bLocked := False
      else
      begin
        ShowMessage('Invalid Password.');
      	bLocked := True;
      end;
    end
    else
    begin
      bLocked := False;
    end;
  finally
		Result :=  bLocked;
  	AForm.Free;
  end;

end;

{------------------------------------------------------------------------------------}
// wrapper function to return Locked status
// may be modified to do other work also at same time
function TAmLockApp.IsLocked: Boolean;
begin
  Result :=  bLocked;
end;

{------------------------------------------------------------------------------------}
// this code actually implements the State Change
// This code assumes that it is only called when needed, i.e. when the
// program's locked status has actually changed.

procedure TAmLockApp.DoLockUnlock;
begin
  if (IsLocked) then
  begin
     if (FLockedIcon <> nil) and not (FLockedIcon.Empty) then
     	Application.Icon := FLockedIcon;

      {I didn't know how to do this part in Delphi - perhaps someone will help?}
      // Is DND normally enabled?  If so, disable it.
      // DragAcceptFiles(FALSE);

     // Minimize ourself
     PostMessage(Application.Handle, WM_SYSCOMMAND,SC_MINIMIZE,0);
  end
  else
  begin
     if (FUnLockedIcon <> nil) and not (FLockedIcon.Empty) then
     	Application.Icon := FUnLockedIcon;

			 {I didn't know how to do this part in Delphi - perhaps someone will help?}
       // Is DND normally enabled?  If so, re-enable it.
       // DragAcceptFiles(TRUE);

       // Restore ourself
       PostMessage(Application.Handle, WM_SYSCOMMAND,SC_RESTORE,0);
  end;
end;

{==========================================================}
procedure Register;
begin
	RegisterComponents('Samples', [TAmLockApp]);
end;

{------------------------------------------------------------------------------------}
initialization

end.
{----------------------------------------------------------}

