unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages,
  Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DB, DBTables,
  TabRep, DBGrids, Unit2, Grids;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    Table2: TTable;
    DataSource2: TDataSource;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Table1FAX: TStringField;
    Table1TaxRate: TFloatField;
    Table2OrderNo: TFloatField;
    Table2CustNo: TFloatField;
    Table2SaleDate: TDateTimeField;
    Table2ItemsTotal: TCurrencyField;
    TR1: TTableReport;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    TR2: TTableReport;
    TR3: TTableReport;
    Button6: TButton;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    Button4: TButton;
    Table3: TTable;
    TR4: TTableReport;
    Table3NAME: TStringField;
    Table3SIZE: TSmallintField;
    Table3WEIGHT: TSmallintField;
    Table3AREA: TStringField;
    Table3BMP: TBlobField;
    Button5: TButton;
    Button7: TButton;
    Table2EmpNo: TIntegerField;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Table1AfterOpen(DataSet: TDataset);
    procedure Button6Click(Sender: TObject);
    procedure TR2RecordPrinted(Sender: TObject; Pos: Integer);
    procedure Button4Click(Sender: TObject);
    procedure TR2OldPage(Sender: TObject; Pos: Integer);
    procedure TR2AfterPrint(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

const fl: boolean = false;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  TR1.Options(Self)
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  TR1.Fields(Self, Form2)
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  TR1.PView(Self,Form2)
end;

procedure TForm1.Table1AfterOpen(DataSet: TDataset);
begin
  Table1.SetRangeEnd;
  Table1Company.Text:='F';
  Table1.ApplyRange
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  TR2.PView(Self,nil)
end;

procedure TForm1.TR2RecordPrinted(Sender: TObject; Pos: Integer);
begin
  TR3.PrintF(Self,nil,TR2.Device);
  if TR3.PFHead then begin
    fl:=true;
    TR3.PFHead:=false;
    TR3.saveToFile(1)
  end
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  TR1.Print(Self,Form2)
end;

procedure TForm1.TR2OldPage(Sender: TObject; Pos: Integer);
begin
  if not TR3.PFHead then begin
    TR3.PFHead:=true;
    TR3.SaveToFile(1)
  end
end;

procedure TForm1.TR2AfterPrint(Sender: TObject);
begin
  if fl then begin
    TR3.PFHead:=true;
    TR3.saveToFile(1)
  end
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  TR4.PView(Self,nil)
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  TR4.Print(Self,nil)
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Caption:=Application.EXEName
end;

end.
