#ifndef __SWPLOGIC_H
	#define __SWPLOGIC_H
#ifdef __cplusplus
extern "C"
{
#endif
#include <windows.h>
#define WM_SWEEPTIMER WM_USER + 100
#define WM_BLANKCELL  WM_USER + 101

typedef HANDLE HSWP;
typedef FARPROC FLIPPROC;
typedef enum SHOWN { TOP = 0, BOTTOM = 1} SHOWNTYPE;

typedef enum  OPTYPE  {OP_PLAY,OP_FLAG,OP_PLAYSHIFTED }
							OPERATION;
               

typedef enum  GMSTATE { BADGAMEHANDLE 			= -7,
                        UNKNOWN 	  				= -9,
                        WON 		  					= 1,
												LOST		  					= 2,
												PLAYING 	  				= 3,
												TIMEDOUT	  				= 4,
												WAITING_AFTERWIN   	= 5,
								 				WAITING_AFTERLOSS  	= 6,
												WAITING_AFTERRESET 	= 7,
												UNPLAYING          	= 8}

               GAMESTATE;

typedef enum  LOGICERR_TAG  {
												GM_MORETOPLAY  =  2,
												GM_OK           =  1,
                        GMERR_LOST         = -1,
                 				GMERR_MEMFAILURE   = -2,
												GMERR_TOOMANYMINES = -3,
								 				GMERR_TOOMANYPIECES= -4,
								 				GMERR_GAMENOTINIT  = -5,
												GMERR_NOTENOUGHBUF = -6,
												GMERR_BADGAMEHANDLE= -7,
												GMERR_PIECEALREADYPLAYED = -8,
												GMERR_UNKNOWN          = -9,
                        GMERR_OUTOFRANGE       = -10,
												GMERR_INVALIDHWND      = -11,
												GMERR_TOOMANYGAMES     = -12,
												GMERR_TIMER            = -13,
												GMERR_INDEXOUTOFRANGE  = -14,
                        GMERR_TIMEDOUT         = -15
								      }LOGICERR;

typedef enum PIECEVAL_TAG  {
												PV_MEMFAILURE     = -2,
                        PV_BADGAMEHANDLE  = -7,
												INVALID_PIECE      =  -1,
												UP 			  				 =   0,
												UPFLAG     				 =   1,
												UPQUESTION         =   2,
								 				WRONGGUESS 				 =   3,
								 				ANOTHERWRONGGUESS  =   4,
                 				MINE               =   5,
								 		    DNFLAG             =   6,
												EIGHT              =   7,  /* Yes there is a method */
								 		    SEVEN              =   8,  /* to this madness Eight = 6 */
								 		    SIX                =   9,
								 		    FIVE               =   10,
								 		    FOUR               =  11,
								 		    THREE              =  12,
								 		    TWO                =  13,
								 		    ONE                =  14,
												NONE               =  15
												}PIECEVAL ;
								   
                 

HSWP  		 	FAR PASCAL 	_export logInitGame (int Rows, int Cols,
																					 int Mines, HWND hwndTimer,
																					 LOGICERR *reason);
LOGICERR   	FAR PASCAL  _export logFreeGame(HSWP);
PIECEVAL   	FAR PASCAL  _export logGetValue(HSWP,int I, int J);
LOGICERR 		FAR PASCAL 	_export logSetFlag(HSWP hswp, int I, int J);
PIECEVAL 		FAR PASCAL 	_export logGetSideShown(HSWP hswp, int I, int J);
GAMESTATE		FAR PASCAL 	_export logGetGameState(HSWP hswp);
WORD FAR 		PASCAL 			_export logGetMineCount(HSWP hswp);
LOGICERR	  FAR PASCAL _export logPlay(HSWP hswp,	int I, int J, BOOL isShifted);
LOGICERR    FAR PASCAL _export logIncrementGameTime(HSWP hswp);

#ifdef __cplusplus
}
#endif


#endif