unit SwpLogic;

interface
uses WinTypes, WinProcs, Messages;
const  WM_SWEEPTIMER  = WM_USER + 100;
       WM_BLANKCELL    = WM_USER + 101;
type
   HSWP     = THandle;
   FLIPPROC = TFarproc;
   SHOWNTYPE   = ( TOP, BOTTOM ) ;

   const
     {GMSTATE}
     gmstBADGAMEHANDLE = -7;
     gmstUNKNOWN       = -9;
     gmstWON           =  1;
     gmstLOST	       =  2;
     gmstPLAYING       =  3;
     gmstTIMEDOUT      =  4;
     gmstWAITING_AFTERWIN   = 5;
     gmstWAITING_AFTERLOSS  = 6;
     gmstWAITING_AFTERRESET = 7;

     logGM_OK              =  1;
     logGMERR_LOST         = -1;
     logGMERR_MEMFAILURE   = -2;
     logGMERR_TOOMANYMINES = -3;
     logGMERR_TOOMANYPIECES= -4;
     logGMERR_GAMENOTINIT  = -5;
     logGMERR_NOTENOUGHBUF = -6;
     logGMERR_BADGAMEHANDLE= -7;
     logGMERR_PIECEALREADYPLAYED = -8;
     logGMERR_UNKNOWN          = -9;
     logGMERR_OUTOFRANGE       = -10;
     logGMERR_INVALIDHWND      = -11;
     logGMERR_TOOMANYGAMES     = -12;
     logGMERR_TIMER            = -13;
     logGMERR_INDEXOUTOFRANGE  = -14;

     pvMEMFAILURE     = -2;
     pvBADGAMEHANDLE      = -7;
     pvINVALID_PIECE      =  -1;
     pvUP		  =   0;
     pvUPFLAG     	  =   1;
     pvQUESTIONUP         =   2;
     pvWRONGGUESS 	  =   3;
     pvANOTHERWRONGGUESS  =   4;
     pvMINE               =   5;
     pvDNFLAG             =   6;
     pvEIGHT              =   7;
     pvSEVEN              =   8;
     pvSIX                =   9;
     pvFIVE               =   10;
     pvFOUR               =  11;
     pvTHREE              =  12;
     pvTWO                =  13;
     pvONE                =  14;
     pvNONE               =  15;

function logInitGame (Rows,Cols, Mines : Integer ;
                      hwndTimer : HWnd;
                      var reason : Integer)       : HSWP; far;

function logPlay(hsweep : HSWP;	I, J : Integer; Shifted : Integer)   : Integer ;far;
function logGetValue(hsweep : HSWP;I,J : Integer) : Integer; far;

function logFreeGame(hsweep : HSWP)               : Integer;far;

function logSetFlag(hsweep : HSWP; I, J : Integer): Integer;far;
function logGetSideShown(hsweep : HSWP;
                         I, J : Integer)          : Integer;far;

function logGetGameState(hsweep :HSWP )           : Integer; far;
function logGetMineCount(hsweep :HSWP)            : Integer; far;
function logIncrementGameTime(hsweep : HSWP)      : Integer; far;
implementation
  function logInitGame;  external 'SWPLOGIC';
  function logPlay     ; external 'SWPLOGIC';
  function logGetValue ; external 'SWPLOGIC';
  function logFreeGame ; external 'SWPLOGIC';
  function logSetFlag  ; external 'SWPLOGIC';
  function logGetSideShown; external 'SWPLOGIC';
  function logGetGameState; external 'SWPLOGIC';
  function logGetMineCount;external 'SWPLOGIC';
  function logIncrementGameTime;external 'SWPLOGIC';
end.



