unit Grid;
interface
uses
WinTypes,WinProcs,Messages,Forms,Grids,Menus,SwpLogic,ExtCtrls,Controls,Classes,
  StdCtrls;
type
FACETYPE = (FACEDOWN ,FACECOOL,FACESAD,FACETENSE,FACEUP);
GAMETYPE = (BEGINNER,INTERMEDIATE,EXPERT,CUSTOM);
TSweepForm = class(TForm)
{This is where the game pieces are put }
    GameGrid               : TDrawGrid;
{Panel Objects for drawing highlighted areas on the game board }
    FormPanel              : TPanel;
    ScorePanel             : TPanel;
    GamePanel              : TPanel;
    TimePanel              : TPanel;
    MinePanel              : TPanel;
{Menu Variables}
    SweepMenu              : TMainMenu;
      New2                 : TMenuItem;
      Beginner1            : TMenuItem;
      Intermediate1        : TMenuItem;
      Expert1              : TMenuItem;
      Exit1                : TMenuItem;
      About1               : TMenuItem;
{TImages That hold Invisible Bitmaps}
    AllButtons             : TImage;       {Source of GameGrid's Buttons}
    FACES                  : TImage;
    LEDS                   : TImage;
{TImages That are Visible but are sourced from invisible Bmps above}
    FacePictureBox        : TImage;
    MinesPicture          : TImage;
    TimePicture           : TImage;
    GameTimer: TTimer;
{Menu Related Functions}
    procedure NewGame(gType : GAMETYPE;Mines,HorzTiles, VertTiles : Integer ) ;
    procedure Intermediate1Click(Sender: TObject);
    procedure Beginner1Click(Sender: TObject);
    procedure Expert1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure New2Click(Sender: TObject);
{Grid Related Functions}
    procedure PaintCell(Sender: TObject; Col, Row: Longint; Rect: TRect;
      State: TGridDrawState);
    function GetGameTile(I,J:Integer;State: TGridDrawState):Integer;
    procedure GameGridMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GameGridMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GameGridMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SetShiftedSelection(X,Y : Integer; onOff : Boolean);
{Form Handling Functions}
    procedure PlaceControls;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GameTimerTimer(Sender: TObject);
{Face Handleing Functions}
    procedure FacePictureBoxClick(Sender: TObject);
    procedure FacePictureBoxMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ToggleFace(Face : FACETYPE);
    procedure FacePictureBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FacePictureBoxMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
{LED Handling Function}
    procedure PrintDigits(NTime : Integer;LEDPICTURE : TImage);
    procedure About1Click(Sender: TObject);
  private
    hGameHandle                                        : HSWP;
    gmType                                             : GameType;
    LastSel                                            : TGridRect;
    MouseDown,Shifted,EatClick                         : Boolean;
    LastX, LastY, NHorzTiles, NVertTiles, NMines       : Integer;
{User defined Message Handling Functions}
    procedure HandleGameTime(var msg : TMessage); message WM_SWEEPTIMER;
    procedure HandleFlipCell(var msg : TMessage); message WM_BLANKCELL;
    procedure HandleFocusTo (var msg : TMessage); message WM_SETFOCUS;
    procedure CheckGameState;
  public
end;
var
  SweepForm: TSweepForm;
implementation
const DIG_SET : Set Of Char = ['-',' ','9','8','7','6','5','4','3','2','1','0'];
const TileWidth  = 16;    {Width  of Allutons BMP}
const TileHeight = 16;    {Height of a Single Button Element in Tall Bitmap}
const FaceWidth  = 24;    {Width  of FACES BMP}
const FaceHeight = 24;    {Height of a Single FACE Element in Tall Bitmap}
const LedWidth   = 13;    {Width of LED Bitmaps}
const LedHeight  = 23;    {Height of a Single LED Element in Tall Bitmap}
{$R *.DFM}
{$R*.RES}

procedure TSweepForm.NewGame(gType : GAMETYPE;Mines,HorzTiles, VertTiles : Integer ) ;
var  iErr : Integer;
begin
  gmType := gType;
  Nmines := Mines;  NHorzTiles := HorzTiles;   NVertTiles := VertTiles;
  logFreeGame(hGameHandle);
  GameTimer.Enabled := False;
  hGameHandle := logInitGame(NVertTiles,NHorzTiles,NMines, Handle,iErr);
  PlaceControls;
end;

procedure TSweepForm.Intermediate1Click(Sender: TObject);
begin
  NewGame(INTERMEDIATE,40,16,16);
end;

procedure TSweepForm.Beginner1Click(Sender: TObject);
begin
   NewGame(BEGINNER,10,8,8);
end;

procedure TSweepForm.Expert1Click(Sender: TObject);
begin
   NewGame(EXPERT,99,30,16);
end;

procedure TSweepForm.PlaceControls;
  var I , J : Integer;  R : TRect;
begin
     Width := 14*2 + NHorzTiles*TileWidth + 1;
     Height := GameGrid.Top + NVertTiles*TileHeight +  GameGrid.Left +
               (GetSystemMetrics(SM_CYCAPTION)+
                GetSystemMetrics(SM_CYMENU )) +1;
     FormPanel.Width := Width - 2;
     FormPanel.Height := Height - (GetSystemMetrics(SM_CYCAPTION)+
                                   GetSystemMetrics(SM_CYMENU ))-2;
     GamePanel.Width  := NHorzTiles*TileWidth + 6;
     GamePanel.Height := NVertTiles*TileHeight + 6;
     ScorePanel.Left := GamePanel.Left;
     ScorePanel.Width := GamePanel.Width;
     TimePanel.Left := ScorePanel.Width - (TimePanel.Width +  MinePanel.Left) ;

     GameGrid.Width := NHorzTiles*TileWidth;
     GameGrid.Height := NVertTiles*TileHeight;
     GameGrid.ColCount := NHorzTiles;  GameGrid.RowCount := NVertTiles;

     FacePictureBox.Left := Width div 2  - (FacePictureBox.Width )  ;
     ToggleFace(FACEUP);
     PrintDigits(0,TimePicture);
     PrintDigits(NMines,MinesPicture) ;
     for I := 0 To nVertTiles - 1 do
       for J := 0 To nHorzTiles - 1 do
         PaintCell(nil, J,I,R,[gdFixed]);
end;

procedure TSweepForm.Exit1Click(Sender: TObject);
begin
   PostQuitMessage(0);
end;

function TSweepForm.GetGameTile(I,J:Integer;State: TGridDrawState):Integer;
  var gameState : Integer;
begin
  If ((gdSelected in State) and (MouseDown)) Then Begin
    gameState := logGetGameState(hGameHandle);
    if ((gameState = gmstPLAYING)             or
        (gameState = gmstWAITING_AFTERRESET)) then
         Result := logGetSideShown(hGameHandle,I,J)
  End
  Else Result := logGetValue(hGameHandle,I,J);
end;

procedure TSweepForm.PaintCell(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
  var  RectS,RectD :TRect;
       I,J         : Integer;
        gmState    : Integer;
       h : THandle;
begin
     h := GetCapture;
     if (h = GameGrid.Handle) Then
       if ((LastX < 0 ) or  (LastX > GameGrid.Width) or
           (LastY < 0)  or  (LastY > GameGrid.Height) )   then
             if (gdSelected in State) Then
                Exit;
     RectD.left := Col*TileWidth;
     RectD.top  := Row*TileHeight;
     rectD.right  := (RectD.Left + TileWidth);
     RectD.Bottom := (RectD.Top  + TileHeight);
     RectS.Top := GetGameTile(Row,Col,State)*TileHeight;

     RectS.Left := 0;
     RectS.Bottom := RectS.Top+TileHeight;
     RectS.Right := RectS.Left+TileWidth;
     GameGrid.Canvas.CopyRect(RectD,AllButtons.Canvas,RectS);
end;

procedure TSweepForm.PrintDigits(NTime : Integer; LEDPICTURE : TImage );
function LedCharToIndex(Ch :char):Integer;
begin
    Case ch of
      '0'..'9' : Result := 11 - (Ord(ch) - Ord('0'));
      '-'      : Result := 0;
      ' '      : Result := 1;
      Else
       ReSult := -1
    End;
end;
   var RectS,RectD : TRect;
       I           : Integer;
       PStr        : Array[0..3] of char;
       Dig         : Integer;
begin
    wvsprintf(Pstr,'%03d',NTime);
    for I := 0 to 2 do begin
         RectD.left   := I*LedWidth;
         RectD.top    := 0;
         rectD.right  := RectD.Left+LedWidth;
         RectD.Bottom := LedHeight;
         Dig := LedCharToIndex(Pstr[I]);
         If (Dig >= 0) Then Begin
           RectS.Top    := Dig*LEDHeight;
           RectS.Left   := 0;
           RectS.Bottom := RectS.Top+LEDHeight;
           RectS.Right  := LedWidth;
           LedPicture.Canvas.CopyRect(RectD,LEDS.Canvas,RectS );
         End;
     end;
end;

procedure TSweepForm.FormCreate(Sender: TObject);
var Err : Integer;
begin
    LastX := -1;     LastY := -1;
    EatClick := False;
    GameTimer.Enabled := False;
    MouseDown := False;
    Shifted := FALSE;
    NVertTiles := 8;    NHorzTiles := 8;
    NMines := 10;
    ToggleFace(FaceUp);
    PrintDigits(0,TimePicture);   PrintDigits(NMines,MinesPicture);
    hGameHandle := logInitGame(NVertTiles,NHorzTiles,NMines,Handle,Err);
    PlaceControls;
end;

procedure TSweepForm.FacePictureBoxClick(Sender: TObject);
begin
    ToggleFace(FaceDown);
end;
procedure TSweepForm.GameGridMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var   I,J                     : LongInt;
      RectD,RectS,R           : TRect;
      pv,row,col    : Integer ;
begin
   MouseDown := False;
   if EatClick Then
   Begin
    EatClick := False;
    Exit;
   End;

   GameGrid.MouseToCell(X,Y,J,I);
   If (mbLeft = Button) Then  Begin
        if (X <  GameGrid.Width  ) and (Y <  GameGrid.Height ) then
           If (Shifted) Then logPlay(hGameHandle,I,J,1)
              Else logPlay(hGameHandle,I,J,0);

        PaintCell(nil, J,I,R,[gdFixed]);
        CheckGameState;
   end
   else
   if (mbRight = Button)  then
      If (not Shifted) Then   Begin
        logSetFlag(hGameHandle,I,J);
        PrintDigits(logGetMineCount(hGameHandle),MinesPicture);
        PaintCell(nil,J,I,R,[gdFixed]);
        CheckGameState;
      End;
   SetShiftedSelection(X,Y,False);
   ReleaseCapture;
end;
procedure TSweepForm.CheckGameState;
   var gameState : Integer;
Begin

gameState := logGetGameState(hGameHandle);
        Case gameState of
         gmstPLAYING:begin ToggleFace(FACEUP);
                           If (GameTimer.Enabled = False) Then
                             GameTimer.Enabled := True;
                     end;
         gmstLOST  : begin  ToggleFace(FACESAD);
                            GameTimer.Enabled := False;
                     end;
         gmstWON   : begin  ToggleFace(FACECOOL);
                            GameTimer.Enabled := False;
                     end;
         else        ToggleFace(FACEUP);
        End;
End;
procedure TSweepForm.GameGridMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var R            : TRect;
    I,J          : Integer;
    II,JJ,Adder  : LongInt;
    Sel          : TGridRect;
begin
 LastX := X; LastY := Y;
 if (ssLeft in Shift) then
  if ((X >= 0 ) and  (X <=GameGrid.Width)     and
      (Y >= 0)  and  (Y <= GameGrid.Height) ) then  begin
          for J := LastSel.Left To LastSel.Right do
              for I := LastSel.Top To LastSel.Bottom do
                  PaintCell(nil, J, I,R,[gdFixed]);
          if (Shifted)    Then
            SetShiftedSelection(X,Y,True);
     end;
end;

procedure TSweepForm.GameGridMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  var  gameState : Integer;
begin
  if (Button = mbLeft) Then  Begin
    SetCapture (GameGrid.Handle);
    MouseDown := True;
    gameState := logGetGameState(hGameHandle);
     if ((gameState = gmstPLAYING) or
         (gameState = gmstWAITING_AFTERRESET)) Then
                    ToggleFace(FaceTense);
    if ((ssShift in Shift) or Shifted) Then
      SetShiftedSelection(X,Y,True);
   End
   Else
   if((Button = mbRight) and  (MouseDown = True)) Then
      SetShiftedSelection(X,Y,TRUE);
end;

procedure TSweepForm.SetShiftedSelection(X,Y : Integer; onOff : Boolean);
var  II,JJ,Adder : LongInt; Sel         : TGridRect;
begin
     GameGrid.MouseToCell(X,Y,II,JJ);
     Shifted := onOff;
     if (onOff) Then  Adder := 1  Else  Adder := 0;

     Sel.Left := II - Adder;    Sel.Right:= II + Adder;
     Sel.Top  := JJ - Adder;    Sel.Bottom := JJ + Adder;

     if (Sel.Left < 0 )                   then    Sel.Left := 0;
     if (Sel.Right >= NHorzTiles)         then    Sel.Right := NHorzTiles - 1;
     if (Sel.Top < 0 )                    then    Sel.Top := 0;
     if (Sel.Bottom >= NVertTiles)        then    Sel.Bottom := NVertTiles - 1;

     GameGrid.Selection := Sel;
end;

procedure TSweepForm.FacePictureBoxMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   ToggleFace(FaceDown);
end;

procedure TSweepForm.ToggleFace(Face : FACETYPE);
 var RectS,RectD : TRect;
begin
    RectD.left := 0;
    RectD.top  := 0;
    rectD.right  := FaceWidth;
    RectD.Bottom := FaceHeight;
    RectS.Top := Ord(Face)*FaceHeight;
    RectS.Left := 0;
    RectS.Bottom := RectS.Top+FaceHeight;
    RectS.Right := FaceWidth;
    FacePictureBox.Canvas.CopyRect(RectD,FaceS.Canvas,RectS );
End;

procedure TSweepForm.FacePictureBoxMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if ((X >= 0 ) and  (X <= FacePictureBox.Width)      and
         (Y >= 0)  and  (Y <= FacePictureBox.Height) )   then begin
       ToggleFace(FaceUP);
       New2Click(nil);
     end;
end;

procedure TSweepForm.FormDestroy(Sender: TObject);
begin
  logFreeGame(hGameHandle);
end;

procedure TSweepForm.FacePictureBoxMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
 if ((X < 0 ) or  (X > FacePictureBox.Width )     or
     (Y < 0)  or  (Y > FacePictureBox.Height) )   then ToggleFace(FaceUP);
end;

procedure TSweepForm.New2Click(Sender: TObject);
var  iErr : Integer;  r    : TRect;
begin
   logFreeGame(hGameHandle);
   hGameHandle := logInitGame(NVertTiles,NHorzTiles, NMines,Handle,iErr);
   PlaceControls;
end;

procedure TSweepForm.HandleGameTime(var msg : TMessage);
Begin
  PrintDigits(msg.WParam,TimePicture);
End;

procedure TSweepForm.HandleFlipCell(var msg : TMessage);
var R : TRect ;
Begin
  PaintCell(nil,msg.LparamHI,msg.LParamLO,R,[gdFixed]);
End;

procedure TSweepForm.GameTimerTimer(Sender: TObject);
begin
  logIncrementGameTime(hGameHandle);
end;

procedure TSweepForm.HandleFocusTo(var msg : TMessage);
Begin
  if (msg.WParam <> Handle) Then
    EatClick := True;
End;

procedure TSweepForm.About1Click(Sender: TObject);
begin
    MessageBox(Handle,'Mark Wardell - Public Domain'#13'75142,415'#13'mwardell@deltanet.com',
                      'Delphi Mine Sweeper ',MB_OK);
end;

end.
