{-------------------------------------------------------------------------}
{UNIT:    Toolbar.Pas - Automatically adjusts and aligns TSpeedButtons to }
{                       panel at run-time.  Optionally, buttons may be    }
{                       aligned from either the right or left by          }
{                       specifying the BtnLeftGrpTag property.  Use the   }
{                       TSpeedButton hint property to store both the hint }
{                       for the bdGlyphOnly style and the caption for the }
{                       bdTextGlyph and bdGlyphOnly styles.  Add          }
{                       SpeedButtons to the toolbar in the order in which }
{                       you wish them to appear (when rearranged).        }
{TARGET:  Delphi 1 only.                                                  }
{AUTHOR:  George L. Roberts                                               }
{EMAIL:   robertsg@nettally.com                                           }
{-------------------------------------------------------------------------}
{WARNING! This software is provided as is.  No warranty is given by the   }
{         author, expressed or implied.  Use this software at your own    }
{         risk.  The author assumes no responsibility for any damage from }
{         the use of this software.                                       }
{NOTE:    This software is freeware which means that it is free for use   }
{         and distribution.  Please do not remove/mask the about property.}
{-------------------------------------------------------------------------}
unit Toolbar;

interface

uses
  Buttons, Classes, Controls, DsgnIntf, ExtCtrls, Suite16, SysUtils;

const
  __OBJNAME:  String  = 'gToolbar';
  __OBJVER:   String  = 'v1.0';

type
  TStyles     = (bdTextGlyph, bdGlyphOnly);
  TAboutToolbar = class(TgPropertyEditor)
    procedure Edit; override;
  end;

  TgToolbar = class(TPanel)
  private
    FAboutBox:  TAboutToolbar;
    FAlign:     TBarAlignment;
    FLeftGrpTag:Integer;
    FSmallSize,
    FBigWidth,
    FBigHeight: Integer;
    FStyle:     TStyles;
    function    GetTop:   Integer;
    function    GetWidth: Integer;
    procedure   SetBarAlignment( Value: TBarAlignment );
    procedure   SetStyle( Value: TStyles );
  public
    constructor Create(AOwner: TComponent); override;
    procedure   Resize( Style: TStyles );
  published
    property    About:        TAboutToolbar read FAboutBox    write FAboutBox;
    property    BarAlign:     TBarAlignment read FAlign       write SetBarAlignment;
    property    BtnBigHeight: Integer       read FBigHeight   write FBigHeight;
    property    BtnBigWidth:  Integer       read FBigWidth    write FBigWidth;
    property    BtnSmallSize: Integer       read FSmallSize   write FSmallSize;
    property    BtnLeftGrpTag:Integer       read FLeftGrpTag  write FLeftGrpTag;
    property    BtnStyle:     TStyles       read FStyle       write SetStyle;
    property    Top:          Integer       read GetTop;
    property    Width:        Integer       read GetWidth;
  end;

  procedure Register;

implementation
{$R TOOLBAR}

constructor TgToolbar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FBigWidth   := 56;
  FBigHeight  := 38;
  FSmallSize  := 25;

  if (inherited Align = alNone) then
    SetBarAlignment( baTop );
  Resize( FStyle );
  inherited Caption := '';
end;

function TgToolbar.GetTop;
begin
  result := inherited Top;
end;
function TgToolbar.GetWidth;
begin
  result := inherited Width;
end;

procedure TgToolbar.SetStyle( Value: TStyles );
begin
  FStyle := Value;
  Resize( Value );
end;
procedure TgToolbar.SetBarAlignment( Value: TBarAlignment );
begin
  if (Value = baBottom) then inherited Align := alBottom
                        else inherited Align := alTop;
end;
{-------------------------------------------------------------------------}
{PROCEDURE: Reset size of Toolbar.                                        }
{-------------------------------------------------------------------------}
procedure TgToolbar.ReSize( Style: TStyles );
var i, intLStop, intRStop: Integer;
    strName:               String;
begin
  intLStop := 0;                                {4Buttons on the left side}
  intRStop := Width;                           {4Buttons on the right side}
  if (Style = bdGlyphOnly) then                                  {Pix only}
  begin
    Height := FSmallSize;
    for i := 0 to (Owner.ComponentCount-1) do              {Traverse index}
    begin
      if (Owner.Components[i] is TSpeedButton) then
      begin
        strName := UpperCase( (Owner.Components[i] as TSpeedButton).Parent.Name );

        if (strName = UpperCase( Name )) then        {Speed btn on Toolbar}
        begin
          (Owner.Components[i] as TSpeedButton).Top      := 0;
          (Owner.Components[i] as TSpeedButton).Height   := FSmallSize;
          (Owner.Components[i] as TSpeedButton).Width    := FSmallSize;
          (Owner.Components[i] as TSpeedButton).ShowHint := True;
          (Owner.Components[i] as TSpeedButton).Caption  := '';

                                                          {Tag 4 Left Btns}
          if ((Owner.Components[i] as TSpeedButton).Tag = FLeftGrpTag) then
          begin
            (Owner.Components[i] as TSpeedButton).Left   := intLStop;
            intLStop := intLStop + FSmallSize;
          end
          else                                              {Right Buttons}
          begin
            intRStop := intRStop - FSmallSize;
            (Owner.Components[i] as TSpeedButton).Left   := intRStop;
          end;
        end;
      end;
    end;                           {End traverse the Owner.Component index}
  end
  else                                                         {Pix & text}
  begin
    Height := FBigHeight;
    for i := 0 to Owner.ComponentCount - 1 do              {Traverse index}
    begin
      if (Owner.Components[i] is TSpeedButton) then
      begin
        strName := UpperCase( (Owner.Components[i] as TSpeedButton).Parent.Name );
        if (strName = UpperCase( Name )) then
        begin
          (Owner.Components[i] as TSpeedButton).Top      := 0;
          (Owner.Components[i] as TSpeedButton).Height   := FBigHeight;
          (Owner.Components[i] as TSpeedButton).ShowHint := False;
          (Owner.Components[i] as TSpeedButton).Caption  :=
            (Owner.Components[i] as TSpeedButton).Hint;

                                                          {Tag 4 Left Btns}
          if ((Owner.Components[i] as TSpeedButton).Tag = FLeftGrpTag) then
          begin
            (Owner.Components[i] as TSpeedButton).Left  := intLStop;
            (Owner.Components[i] as TSpeedButton).Width := FBigWidth;
            intLStop := intLStop + FBigWidth;
          end
          else                                              {Right Buttons}
          begin
            intRStop := intRStop - FBigWidth;
            (Owner.Components[i] as TSpeedButton).Left  := intRStop;
            (Owner.Components[i] as TSpeedButton).Width := FBigWidth;
          end;
        end;
      end;
    end;                           {End traverse the Owner.Component index}
  end;                                                 {End IF ButtType...}
end;                                                  {End ChangeButtons()}

procedure TAboutToolbar.Edit;
begin
  DisplayAbout( __OBJNAME, __OBJVER, __ME, __ADDRESS );
end;

procedure Register;
begin
  RegisterComponents( 'Suite16', [TgToolbar] );
  RegisterPropertyEditor( TypeInfo(TAboutToolbar), TgToolbar, 'ABOUT', TAboutToolbar );
end;


end.
