{-------------------------------------------------------------------------}
{UNIT:    Suite16.Pas (v1.0) - Register all Suite16 components.           }
{TARGET:  Delphi 1 only.                                                  }
{AUTHOR:  George L. Roberts                                               }
{EMAIL:   robertsg@nettally.com                                           }
{-------------------------------------------------------------------------}
{WARNING! This software is provided as is.  No warranty is given by the   }
{         author, expressed or implied.  Use this software at your own    }
{         risk.  The author assumes no responsibility for any damage from }
{         the use of this software.                                       }
{NOTE:    This software is freeware which means that it is free for use   }
{         and distribution.  Please do not remove/mask the about property.}
{-------------------------------------------------------------------------}
unit Suite16;

interface

uses Dialogs, DsgnIntf;

const
  __ME: 			String = 'George L. Roberts';
  __ADDRESS:	String = 'robertsg@nettally.com';

type
  TBarAlignment     = ( baTop, baBottom );
  TgPropertyEditor  = class( TPropertyEditor )
  public
    procedure DisplayAbout( strName, strVer, strAuthor, strAddr: String );
    function  GetAttributes: TPropertyAttributes; override;
    function  GetValue: string; override;
  end;

  procedure Register;

implementation

uses Cal, Combo, OraDb, SpinTime, Status, Toolbar;          {Suite16 units}

{-------------------------------------------------------------------------}
{NOTE:	See individual units for descriptions.                            }
{       See Suite16.wri for installation and usage instructions.          }
{-------------------------------------------------------------------------}
procedure Register;
begin
  Cal.Register;
  Combo.Register;
  OraDb.Register;
  PassDlg.Register;
  SpinTime.Register;
  Status.Register;
  ToolBar.Register;
end;

function TgPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result:= [paMultiSelect, paDialog, paReadOnly];
end;
function TgPropertyEditor.GetValue: string;
begin
  Result:= '(about)';
end;
procedure TgPropertyEditor.DisplayAbout(
  strName, strVer, strAuthor, strAddr: String );
begin
  MessageDlg( strName+' component ('+strVer+')'#13#13+
              'by '+strAuthor+#13+
              strAddr,
              mtInformation, [mbOk], 0 );
end;

end.
