{-------------------------------------------------------------------------}
{UNIT:    Status.Pas - Use to display message status.                     }
{TARGET:  Delphi 1 only.                                                  }
{AUTHOR:  George L. Roberts                                               }
{EMAIL:   robertsg@nettally.com                                           }
{-------------------------------------------------------------------------}
{WARNING! This software is provided as is.  No warranty is given by the   }
{         author, expressed or implied.  Use this software at your own    }
{         risk.  The author assumes no responsibility for any damage from }
{         the use of this software.                                       }
{NOTE:    This software is freeware which means that it is free for use   }
{         and distribution.  Please do not remove/mask the about property.}
{-------------------------------------------------------------------------}
unit Status;

interface

uses
  Classes, Controls, DsgnIntf, ExtCtrls, Graphics, StdCtls, Suite16;

const
  __OBJNAME:  String  = 'gStatusbar';
  __OBJVER:   String  = 'v1.0';

type
  TAboutStatusbar = class(TgPropertyEditor)
    procedure Edit; override;
  end;

  TgStatusBar = class( TCustomPanel )
  private
    FAboutBox:    TAboutStatusbar;
    FAlign:       TStatusBarAlignment;
    FLeftCaption,
    FRightCaption,
    FMidCaption:  String;
    FLeftPanel,
    FRightPanel,
    FMidPanel:    TPanel;
    FMidWidth,
    FRightWidth:  Integer;

    function    GetTop:   Integer;
    function    GetWidth: Integer;
    procedure   SetAlignment( Value: TStatusBarAlignment );
    procedure   SetLeftCaption( Value: String );
    procedure   SetMidCaption( Value: String );
    procedure   SetMidWidth( Value: Integer );
    procedure   SetRightCaption( Value: String );
    procedure   SetRightWidth( Value: Integer );
  public
    constructor Create( AOwner: TComponent ); override;
    destructor  Destroy; override;
  published
    property    About:  TAboutStatusbar     read FAboutBox      write FAboutBox;
    property    Align:  TStatusBarAlignment read FAlign         write SetAlignment;
    property    CaptionLeft:  String        read FLeftCaption   write SetLeftCaption;
    property    CaptionRight: String        read FRightCaption  write SetRightCaption;
    property    CaptionMid:   String        read FMidCaption    write SetMidCaption;
    property    Font;
    property    WidthMid:     Integer       read FMidWidth      write SetMidWidth;
    property    WidthRight:   Integer       read FRightWidth    write SetRightWidth;
    property    Top:          Integer       read GetTop;
    property    Width:        Integer       read GetWidth;
  end;

procedure Register;

implementation

{$R   STATUS}

{ TgStatusbar Methods }

constructor TgStatusbar.Create( AOwner: TComponent );
var intLRPSize: Integer;
begin
  inherited Create( AOwner );
  FMidWidth   := 150;
  FRightWidth := 225;
  SetAlignment( sbaBottom );
  Height      := ABS( Font.Height )+5;

  FLeftPanel  := TPanel.Create( Self );
  FRightPanel := TPanel.Create( Self );
  FMidPanel   := TPanel.Create( Self );

  FLeftPanel.Align        := alClient;
  FLeftPanel.BevelInner   := bvLowered;
  FLeftPanel.BevelOuter   := bvRaised;
  FLeftPanel.Alignment    := taLeftJustify;
  FLeftPanel.Width        := intLRPSize;
  FLeftPanel.BorderWidth  := 0;
  FLeftPanel.Visible      := True;
  FLeftPanel.Parent       := Self;

  FMidPanel.Align         := alRight;
  FMidPanel.BevelInner    := bvLowered;
  FMidPanel.BevelOuter    := bvRaised;
  FMidPanel.Alignment     := taCenter;
  FMidPanel.Width         := FMidWidth;
  FMidPanel.BorderWidth   := 0;
  FMidPanel.Visible       := True;
  FMidPanel.Parent        := Self;

  FRightPanel.Align       := alRight;
  FRightPanel.BevelInner  := bvLowered;
  FRightPanel.BevelOuter  := bvRaised;
  FRightPanel.Alignment   := taRightJustify;
  FRightPanel.Width       := FRightWidth;
  FRightPanel.BorderWidth := 0;
  FRightPanel.Visible     := True;
  FRightPanel.Parent      := Self;

end;

destructor TgStatusbar.Destroy;
begin
  FLeftPanel.Free;
  FMidPanel.Free;
  FRightPanel.Free;
  inherited Destroy;
end;

procedure TgStatusbar.SetAlignment( Value: TStatusBarAlignment );
begin
  if (Value <> FAlign) then
  begin
    FAlign := Value;
    if (Value = sbaTop) then
      inherited Align := alTop
    else
      inherited Align := alBottom;
    Invalidate;
  end;
end;

procedure TgStatusbar.SetLeftCaption( Value: String );
begin
  FLeftCaption        := Value;
  FLeftPanel.Caption  := Value;
end;
procedure TgStatusbar.SetRightCaption( Value: String );
begin
  FRightCaption       := Value;
  FRightPanel.Caption := Value;
end;
procedure TgStatusbar.SetMidCaption( Value: String );
begin
  FMidCaption         := Value;
  FMidPanel.Caption   := Value;
end;

function TgStatusbar.GetTop;
begin
  result := inherited Top;
end;
function TgStatusbar.GetWidth;
begin
  result := inherited Width;
end;
procedure TgStatusbar.SetMidWidth( Value: Integer );
begin
  FMidWidth         := Value;
  FMidPanel.Width   := Value;
end;
procedure TgStatusbar.SetRightWidth( Value: Integer );
begin
  FRightWidth       := Value;
  FRightPanel.Width := Value;
end;

procedure TAboutStatusbar.Edit;
begin
  DisplayAbout( __OBJNAME, __OBJVER, __ME, __ADDRESS );
end;

procedure Register;
begin
  RegisterComponents( 'Suite16', [TgStatusbar] );
  RegisterPropertyEditor( TypeInfo(TAboutStatusbar), TgStatusbar, 'ABOUT', TAboutStatusbar );
end;

end.


