{-------------------------------------------------------------------------}
{UNIT:    PassDlg.Pas - Password style dialog box.                        }
{TARGET:  Delphi 1 only.                                                  }
{AUTHOR:  George L. Roberts                                               }
{EMAIL:   robertsg@nettally.com                                           }
{-------------------------------------------------------------------------}
{WARNING! This software is provided as is.  No warranty is given by the   }
{         author, expressed or implied.  Use this software at your own    }
{         risk.  The author assumes no responsibility for any damage from }
{         the use of this software.                                       }
{NOTE:    This software is freeware which means that it is free for use   }
{         and distribution.  Please do not remove/mask the about property.}
{-------------------------------------------------------------------------}
unit PassDlg;

interface

uses
  Buttons, Controls, Classes, DsgnIntf, Forms, Graphics,
  StdCtrls, Suite16;

const
  __OBJNAME:  String  = 'gPassDlg';
  __OBJVER:   String  = 'v1.0';

type
  TDispMethod = (dmFirst, dmSecond, dmBoth);
  TAboutPassDlg = class(TgPropertyEditor)
    procedure Edit; override;
  end;

  TgPassDlg = class( TComponent ) 														{ TgPassDlg }
  private
    FAboutBox:  TAboutPassDlg;
    FUser,
    FPswd,
    FCaption,
    FLbl1Txt,
    FLbl2Txt:   String;
    FPassEncr:  TDispMethod;
    FPassChar:  Char;
    FFont:      TFont;
		procedure		SetFont(Value: TFont);
  public
    constructor Create( AOwner: TComponent ); override;
    destructor  Destroy; override;
    function    Execute( strDefaultUser: String ): Boolean;
  published
    property    About: TAboutPassDlg      read FAboutBox  write FAboutBox;
    property    Font:         TFont       read FFont      write SetFont;
    property    Password:     String      read FPswd;
    property    FormCaption:  String      read FCaption   write FCaption;
    property    Label1:       String      read FLbl1txt   write FLbl1txt;
    property    Label2:       String      read FLbl2txt   write FLbl2txt;
    property    PasswordChar: Char        read FPassChar  write FPassChar;
    property    PasswEncrypt: TDispMethod read FPassEncr  write FPassEncr;
    property    User:         String      read FUser;
  end;

  procedure Register;

implementation

{$R PASSDLG}

constructor TgPassDlg.Create( AOwner: TComponent );
begin
  inherited Create( AOwner );
  FFont := TFont.Create;

  if (FFont     = nil)  then FFont := Screen.ActiveForm.Font;
  if (FCaption  = '')   then FCaption   := 'Login';
  if (FLbl1Txt  = '')   then FLbl1Txt   := 'User Name:';
  if (FLbl2Txt  = '')   then FLbl2Txt   := 'Password:';
  if (FPassChar = '')   then FPassChar  := #0;
end;

destructor TgPassDlg.Destroy;
begin
  FFont.Free;
  inherited Destroy;
end;

procedure TgPassDlg.SetFont(Value: TFont);
begin
  FFont.Assign(Value);
end;

{-------------------------------------------------------------------------}
{FUNCTION:	Display password dialog box.                                  }
{PARAMETER:	strDefaultUser - Default user name to appear in login screen. }
{RETURNS:		Whether modal result of dialog form is mrOk.                  }
{-------------------------------------------------------------------------}
function TgPassDlg.Execute( strDefaultUser: String ): Boolean;
const Line1:    Integer = 15;
      Line2:    Integer = 50;
      Line3:    Integer = 90;
var   FForm:    TForm;
      intRight, intRStop: Integer;
      FLabel1,  FLabel2:  TLabel;
      FEdit1,   FEdit2:   TEdit;
      FBtn1,    FBtn2:    TBitBtn;
begin

  FForm             := TForm.CreateNew( Application );
  FForm.BorderIcons := [biSystemMenu]; 							 {Initialize variables}
  FForm.BorderStyle := bsDialog;
  FForm.Ctl3d       := True;
  FForm.Position    := poScreenCenter;
  FForm.Caption     := FCaption;
  FForm.Height      := 150;
  FForm.Width 	    := 250;
  FForm.Font.Assign( FFont );

  intRight          := FForm.Left+FForm.Width;             {Absolute right}
  intRStop          := intRight-20;                    {Right minus margin}

  FEdit1            := TEdit.Create( FForm );
  FEdit1.Parent     := FForm;
  FEdit1.Top        := Line1;
  FEdit1.Width      := 100;
  FEdit1.Left       := intRStop-FEdit1.Width;

  if (strDefaultUser <> '') then
    FEdit1.Text := strDefaultUser;
  if (FPassEncr <> dmSecond) then
    FEdit1.PasswordChar := FPassChar;

  FEdit2            := TEdit.Create( FForm );
  FEdit2.Parent     := FForm;
  FEdit2.Top        := Line2;
  FEdit2.Width      := 100;
  FEdit2.Left       := intRStop-FEdit2.Width;
  if (FPassEncr <> dmFirst) then
    FEdit2.PasswordChar := FPassChar;

  FLabel1           := TLabel.Create( FForm );
  FLabel1.Parent    := FForm;
  FLabel1.Top       := Line1;
  FLabel1.Left      := 10;
  FLabel1.Width     := 80;
  FLabel1.Caption   := FLbl1Txt;
  FLabel1.Alignment := taRightJustify;

  FLabel2           := TLabel.Create( FForm );
  FLabel2.Parent    := FForm;
  FLabel2.Top       := Line2;
  FLabel2.Left      := 10;
  FLabel2.Width     := 80;
  FLabel2.Caption   := FLbl2Txt;
  FLabel2.Alignment := taRightJustify;

  FBtn1             := TBitBtn.Create( FForm );
  FBtn1.Parent      := FForm;
  FBtn1.Top         := Line3;
  FBtn1.Left        := 65;
  FBtn1.Height      := 25;
  FBtn1.Width       := 77;
  FBtn1.Kind        := bkOk;

  FBtn2             := TBitBtn.Create( FForm );
  FBtn2.Parent      := FForm;
  FBtn2.Top         := Line3;
  FBtn2.Left        := 150;
  FBtn2.Height      := 25;
  FBtn2.Width       := 77;
  FBtn2.Kind        := bkCancel;

  result  := (FForm.ShowModal = mrOk);
  FUser   := FEdit1.Text;
  FPswd   := FEdit2.Text;
  FForm.Free;
end;

procedure TAboutPassDlg.Edit;
begin
  DisplayAbout( __OBJNAME, __OBJVER, __ME, __ADDRESS );
end;

procedure Register;
begin
  RegisterComponents( 'Suite16', [TgPassDlg] );
  RegisterPropertyEditor( TypeInfo(TAboutPassDlg), TgPassDlg, 'ABOUT', TAboutPassDlg );
end;

end.
