{-------------------------------------------------------------------------}
{UNIT:    Combo.Pas - ComboBox that adds an item search (1st letter only) }
{                     and a keys list.  Only the csDropDown and csSimple  }
{                     styles are supported.  These two styles allow the   }
{                     component user to assign values to the text property}
{TARGET:  Delphi 1 only.                                                  }
{AUTHOR:  George L. Roberts                                               }
{EMAIL:   robertsg@nettally.com                                           }
{-------------------------------------------------------------------------}
{WARNING! This software is provided as is.  No warranty is given by the   }
{         author, expressed or implied.  Use this software at your own    }
{         risk.  The author assumes no responsibility for any damage from }
{         the use of this software.                                       }
{NOTE:    This software is freeware which means that it is free for use   }
{         and distribution.  Please do not remove/mask the about property.}
{-------------------------------------------------------------------------}
unit Combo;

interface

uses
  Classes, Controls, DsgnIntf, Menus, Graphics, StdCtrls,
  Suite16, SysUtils;

const
  __OBJNAME:  String  = 'gCombo';
  __OBJVER:   String  = 'v1.0';

type
  TComboStyle = (gcsDropDown, gcsSimple);
  TAboutCombo = class(TgPropertyEditor)
    procedure Edit; override;
  end;

  TgCombo = class( TCustomComboBox )														{ TgCombo }
  private
    FAboutBox:  TAboutCombo;
    FDropFlag:  Boolean;
    FLastChar:  Char;
    FKeys:      TStrings;                     {Optional list of key values}
    FIndex,
    FNextIndex: Integer;
    FStyle:     TComboStyle;
		procedure 	SetKeys( Value: TStrings );
    procedure   SetStyle( Value: TComboStyle );
  protected
    procedure   Change; override;
    procedure   DropDown; override;
    procedure   DoExit; override;
  public
    constructor Create( AOwner: TComponent ); override;
    destructor  Destroy; override;
  published
    property    About:  TAboutCombo read FAboutBox  write FAboutBox;
    property    Style:  TComboStyle read FStyle     write SetStyle;
{    property    Style;                     {Must be published before Items}
    property    Color;
    property    Ctl3D;
    property    DragMode;
    property    DragCursor;
    property    DropDownCount;
    property    Enabled;
    property    Font;
    property    ItemHeight;
    property    ItemIndex           read FIndex     write FIndex;
    property    Items;
    property    Keys:   TStrings    read FKeys      write SetKeys;
    property    MaxLength;
    property    ParentColor;
    property    ParentCtl3D;
    property    ParentFont;
    property    ParentShowHint;
    property    PopupMenu;
    property    ShowHint;
    property    Sorted;
    property    TabOrder;
    property    TabStop;
    property    Text;
    property    Visible;
    property    OnChange;
    property    OnClick;
    property    OnDblClick;
    property    OnDragDrop;
    property    OnDragOver;
    property    OnDrawItem;
    property    OnDropDown;
    property    OnEndDrag;
    property    OnEnter;
    property    OnExit;
    property    OnKeyDown;
    property    OnKeyPress;
    property    OnKeyUp;
    property    OnMeasureItem;
  end;                                          { End TGCombo declaration }

procedure Register;

implementation

{$R COMBO}

constructor TgCombo.Create( AOwner: TComponent );
begin
  inherited Create( AOwner );
  FKeys       := TStringList.Create;                 {Initialize variables}
  FDropFlag   := False;
  FLastChar   := ' ';
  FIndex      := -1;
  FNextIndex  := 1;
end;
destructor TgCombo.Destroy;
begin
  FKeys.Free;
  inherited Destroy;
end;

procedure TgCombo.DoExit;
begin
  FIndex    := -1;
  FDropFlag := False;
  inherited DoExit;
end;

procedure TgCombo.SetKeys( Value: TStrings );
begin
	FKeys.Assign( Value );
end;

procedure TgCombo.SetStyle( Value: TComboStyle );
begin
  FStyle := Value;
  if (Value = gcsSimple) then
    inherited Style := csSimple
  else
    inherited Style := csDropDown;
end;

procedure TgCombo.DropDown;
begin
  inherited DropDown;
  FDropFlag := True;
end;

procedure TgCombo.Change;
var intCtr:     Integer;
    boolFound:  Boolean;
begin

  if not FDropFlag then
  begin
    boolFound := False;
    if (FLastChar = Text[1]) and (FNextIndex<Items.Count) then
      intCtr := FNextIndex
    else
      intCtr := 0;

    while (not boolFound) and (intCtr < Items.Count) do
    begin
      if (UpperCase( Copy( Items[intCtr], 1, 1 ) ) = UpperCase( Copy( Text, 1, 1 ) )) then
      begin
        boolFound   := True;
        FLastChar   := Text[1];
        ItemIndex   := intCtr;
        Text        := Items[intCtr];
      end;
      Inc( intCtr );
      FNextIndex := intCtr;
    end;

    if boolFound then
      FIndex      := FNextIndex-1
    else
    begin
      FNextIndex  := 1;
      FIndex      := 0;
      Text        := Items[0];
    end;
  end                                            {End IF NOT FDROPFLAG...}
  else
    FIndex  := inherited ItemIndex;

  FDropFlag   := False;
  inherited Change;
end;

procedure TAboutCombo.Edit;
begin
  DisplayAbout( __OBJNAME, __OBJVER, __ME, __ADDRESS );
end;

procedure Register;
begin
  RegisterComponents( 'Suite16', [TgCombo] );
  RegisterPropertyEditor( TypeInfo(TAboutCombo), TgCombo, 'ABOUT', TAboutCombo );
end;

end.
