/////////////////////////////////////////////////////////////////////
//                                                                 //
//  Copyright (c) 1997 Krzysztof A. Swiatkowski                    //
//                     mailto:hobbit@dom.vr.pl                     //
//                     http://www.vr.pl/~hobbit (coming soon)      //
//  FILE: mainwin.pas                                              //
//                                                                 //
//  DATE: 1-10-1997 14:33:30                                       //
//                                                                 //
//  NOTES: This is a TSubClasser component example.                //
//         I wanted to keep this example as simple as possible so  //
//         there are two usage examples in this project.           //
//                                                                 //
//         1. Subclasser is used to provide MDIForm with a nice    //
//            background. It is flicker free because WM_ERASEBKGND //
//            is totally overriden. See what happens if you move   //
//            Subclass1PreProcessMsg procedure to OnPostProcessMsg //
//            event. Of course I wouldn't bother to show this      //
//            example if you could do it otherwise. Check for      //
//            yourself that neither OnPaint nor message handlers   //
//            in TMainWin provide you with that functionality.     //
//            There will be component posted on DSP that has only  //
//            that functionality.                                  //
//         2. Check out title bar of the about box! This time      //
//            subclasser overrides post reaction on several        //
//            messages at once to draw centered caption with       //
//            bitmaps.                                             //
//         I'm sure you will find lots of other opportunities      //
//         to use this component                                   //
//                                                                 //
/////////////////////////////////////////////////////////////////////
unit mainwin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, subclass, ExtCtrls;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File2: TMenuItem;
    Exit1: TMenuItem;
    N2: TMenuItem;
    Close1: TMenuItem;
    New2: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
//    Subclasser1: TSubclasser;
    Bevel1: TBevel;
    Subclasser1: TSubclasser;
    procedure Subclasser1PreProcessMsg(Sender: TObject; var msg: TMessage;
      var bContinue: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure New2Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses childwin,about;

{$R *.DFM}
{$R bkgnd.res}

//-------------------------------------------------------------------------------------//
procedure TMainForm.Subclasser1PreProcessMsg(Sender: TObject;
  var msg: TMessage; var bContinue: Boolean);
var bmp:TBitmap;
    cnv : TCanvas;
    i,k:integer;
    b:boolean;
begin
  if msg.Msg=WM_ERASEBKGND then begin
     // because Delphi compos make life easier I will use them
     // instead of playing with Win32 API functions
     bmp:=TBitmap.Create;
     cnv:=TCanvas.Create;
     try
       cnv.Handle:=TWMEraseBkGnd(Msg).DC;
       try
         bmp.LoadFromResourceName(HInstance,'TLO1');
       except
         exit;
       end;
       // -> below code draws bitmaps in shifted manner
       // run a program to see what I mean 
       i:=0; b:=false;
       while i<ClientHeight do begin
         b:=not b;
         if b then
           k:=0
         else
           k:=-bmp.Width div 2;
         while k<ClientWidth do begin
            cnv.Draw(k,i,bmp);
            k:=k+bmp.Width;
         end;
         i:=i+bmp.Height;
       end;
       // <-
       // we want Windows to assume that message has been handled
       Msg.Result := 1;
       // and just in case disallow to call default procedure it
       // is not needed
       bContinue := false;
     finally
       cnv.Handle := 0;
       bmp.Free;
       cnv.Free;
     end;
  end;
end;

//-------------------------------------------------------------------------------------//
procedure TMainForm.FormCreate(Sender: TObject);
var ico : TIcon;
begin
  try
    Icon.Handle := LoadImage( hInstance, 'ANICON', IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR );
  except end;
  // just in case I'm checking what kind of form I'm at
  if FormStyle = fsMDIForm then
    Subclasser1.SubClassHandle := ClientHandle
  else
    Subclasser1.SubClassHandle := Handle;
end;
//-------------------------------------------------------------------------------------//
// I think below functions are rather self explanatory  
//-------------------------------------------------------------------------------------//
procedure TMainForm.New2Click(Sender: TObject);
var child : TChildForm;
begin
  child := TChildForm.Create( Application );
end;

//-------------------------------------------------------------------------------------//
procedure TMainForm.Close1Click(Sender: TObject);
begin
  ActiveMDIChild.Close;
end;

//-------------------------------------------------------------------------------------//
procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

//-------------------------------------------------------------------------------------//
procedure TMainForm.About1Click(Sender: TObject);
begin
  with TFrmAbout.Create( Application ) do
    try
      ShowModal;
    finally
      Free;
    end;
end;

end.
