////////////////////////////////////////////////////////////////////
//                                                                //
//  Copyright (c) 1997 Krzysztof A. witkowski                   //
//                                                                //
//  FILE: about.pas                                               //
//                                                                //
//  DATE: 4-10-1997 15:09:46                                      //
//                                                                //
//  NOTES: Second subclasser example                              //
//                                                                //
////////////////////////////////////////////////////////////////////
unit about;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, subclass;

type
  TFrmAbout = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    Subclasser1: TSubclasser;
    procedure Subclasser1PostProcessMsg(Sender: TObject; var msg: TMessage;
      var bContinue: Boolean);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmAbout: TFrmAbout;

implementation
{$R *.DFM}

//----------------------------------------------------------------------------//
// below example draws centered italic text surrounded by two bitmaps on forms//
// caption it does not take any caption buttons or SysMenu icon into account  //
// so you'll have to change it for yourself in case you wanted to use this    //
// method elsewhere                                                           //
//----------------------------------------------------------------------------//
procedure TFrmAbout.Subclasser1PostProcessMsg(Sender: TObject; var msg: TMessage;
                                              var bContinue: Boolean);
var dc : HDC;
    canv : TCanvas;
    r : TRect;
    dx,dy : integer;
    s : string;
    AnIcon : HIcon;
begin
  // here four messages are intercepted because it is them who paints the caption
  if ( msg.Msg = WM_PAINT ) or ( msg.Msg = WM_NCPAINT ) or
     ( msg.Msg = WM_NCACTIVATE ) or (msg.Msg = WM_ACTIVATE) then begin
     // this is Dialog Frame thickness in both directions
     dx := GetSystemMetrics(SM_CXDLGFRAME);
     dy := GetSystemMetrics(SM_CYDLGFRAME);
     // here we get our hands on window rectangle including caption
     // I'm not using Width here mainly because it sometimes doesn't work as
     // expected returning old value
     GetWindowRect( Handle, r );
     r.Right := r.Right - r.Left - dx;
     r.Left := dx;   r.Top := dy;
     r.Bottom := r.Top + GetSystemMetrics(SM_CYCAPTION);
     // As Delphi components allow me to paint easily I prefer to use canvas
     Canv := TCanvas.Create;
     // this is API function that gets me access to entire window including caption,
     // menu and frame
     dc := GetWindowDC( Handle );
     try try
       try
         AnIcon := LoadImage(hInstance,'ANICON',IMAGE_ICON,16,16,LR_DEFAULTCOLOR)
       except MessageBeep(-1); end;
       s := Caption;
       Canv.Handle := dc;
       // checking against window being active
       if Active then begin
          Canv.Brush.Color := GetSysColor( COLOR_ACTIVECAPTION );
          Canv.Font.Color := GetSysColor(COLOR_CAPTIONTEXT);
       end
       else begin
         Canv.Brush.Color := GetSysColor( COLOR_INACTIVECAPTION );
         Canv.Font.Color := GetSysColor( COLOR_INACTIVECAPTIONTEXT );
       end;
       // filling caption rectangle
       Canv.FillRect(r);
       // mainly the only reason to use TCanvas here :-)
       Canv.Font.Size := Canv.Font.Size + 2;
       Canv.Font.Style := [fsItalic, fsBold];
       // for unknown reasons Borland omitted this nice API procedure
       // which centers drawing in any direction so I have to use API
       DrawText( Canv.Handle, PChar(s), length(s), r,
                DT_CENTER or DT_SINGLELINE or DT_VCENTER );
       dx := Canv.TextWidth(s);
       dy := (r.Right-r.Left-dx) div 2;
       // this is another dumb thing Borland did if you want to draw icon
       // with VCL it gets drawn 32x32 not 16x16 although icon is 16x16
       // pretty silly  
       DrawIconEx(Canv.Handle, r.left+1+dy-16-2, r.top+1, AnIcon, 16,16,0,0,DI_NORMAL );
       DrawIconEx(Canv.Handle, r.left+1+dy+dx, r.top+1, AnIcon, 16,16,0,0,DI_NORMAL );
     except
     end finally
        Canv.Handle := 0;
        ReleaseDC( Handle, dc );
     end;
  end;
end;

//-------------------------------------------------------------------------------------//
procedure TFrmAbout.Button1Click(Sender: TObject);
begin
  Close;
end;

//-------------------------------------------------------------------------------------//
procedure TFrmAbout.FormCreate(Sender: TObject);
begin
  Subclasser1.SubClassHandle := Handle;
end;

end.
