////////////////////////////////////////////////////////////////////
//                                                                //
//  Copyright (c) 1997 Krzysztof A. Swiatkowski                   //
//                                                                //
//  FILE: drop1.pas                                               //
//                                                                //
//  DATE: 16-10-1997 13:47:02                                     //
//                                                                //
//  NOTES: Another example of what can you do with subclasser toy //
//         Every now and then you need to accept file here is how //
//         Although in Windows 95/NT4 OLE is a prefered way of    //
//         handling drag&drop this works                          //
//                                                                //
////////////////////////////////////////////////////////////////////
unit drop1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  subclass, StdCtrls, ShellAPI, ExtCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Subclasser1: TSubclasser;
    Panel1: TPanel;
    Button1: TButton;
    procedure Subclasser1PreProcessMsg(Sender: TObject; var msg: TMessage; var bContinue: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Subclasser1PreProcessMsg(Sender: TObject; var msg: TMessage; var bContinue: Boolean);
var mdrop : TWMDropFiles;
    s : String[255];
    i,k,n : integer;
begin
  if msg.msg = WM_DROPFILES then begin
     mdrop := TWMDropFiles( msg );
     // checking how many files were dropped ( -1 is whats important )
     n := DragQueryFile( mdrop.Drop, -1, @s[1], 255 );
     for i:= 0 to n-1 do begin
       // geting every dropped file name
       k:=DragQueryFile( mdrop.Drop, i, @s[1], 255 );
       s[0] := char(k);
       ListBox1.Items.Add( s );
     end;
     // we dont need any additional processing
     bContinue := false;
     DragFinish( mdrop.Drop );
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  // Enables WM_DROPFILES message to be sent to ListBox1
  DragAcceptFiles( ListBox1.Handle , true );
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

end.

