unit Sbc2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TfrmSubclass = class(TForm)  {the subclass-test form}
    lbMsg: TListBox;
    cbClear: TButton;
    cbExit: TButton;
    cbStart: TButton;
    cbStop: TButton;
    ebHandle: TEdit;
    stHandle: TLabel;
    chkHex: TCheckBox;
    Label1: TLabel;
    procedure cbExitClick(Sender: TObject);
    procedure cbStartClick(Sender: TObject);
    procedure cbStopClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


var
  frmSubclass: TfrmSubclass;
  pWindowProc : TFarProc;  {pointer to our window function}
  lOldFunction: LongInt;   {prev. window function (LongInt) }
  hForm: hWnd;             {handle to window to subclass}



  {this is the window function to export}
  function NewWindowFunction(handle: hWnd; msg, wParam : Word;
                           lParam : LongInt): LongInt; export;

implementation

{$R *.DFM}

{NewWindowFunction is the new window function for hForm}
function NewWindowFunction(handle: hWnd; msg, wParam : Word;
                           lParam : LongInt): LongInt;
var
   txt : string;
begin
     {add msg to listbox for user to see}
     frmSubclass.lbMsg.Items.Add('NewWindowFunction Called');
     {check for some msgs}
     case msg of
          WM_SETFOCUS: txt := 'WM_SETFOCUS';
          WM_KILLFOCUS: txt := 'WM_KILLFOCUS';
          WM_ACTIVATE: txt := 'WM_ACTIVATE';
          WM_PAINT: txt := 'WM_PAINT';
          WM_COMMAND: txt := 'WM_COMMAND';
     else
         txt := IntToHex(msg,4)
     end;

     {create a msg-received text string}
     txt := txt + ' - wParam:'
         + IntToHex(wParam,4)+ '  lParam:'
         + IntToHex(lParam,8) + #0;
     {add to listbox}
     frmSubclass.lbMsg.Items.Add(txt);

     {call previous window function with all msgs}
     Result := CallWindowProc(TFarProc(lOldFunction), hForm, msg, wParam, lParam);

     {display result of msg}
     frmSubclass.lbMsg.Items.Add('Returned: ' + IntToStr(Result));
end;


function GetHandle: hWnd;
var
   txt : string;
   lHandle : Longint;
begin
   {this function retrieves the handle typed into edit box}
   {and checks it for validity}
   Result := 0;
   if frmSubclass.chkHex.Checked then
      begin
         txt := '$' + frmSubclass.ebHandle.Text;
         Result := hWnd(strtointdef(txt, 0));
      end
   else
      begin
         txt := frmSubclass.ebHandle.Text;
         Result := hWnd(strtointdef(txt, 0));
      end;
   if Result = 0 then
      showmessage('Invalid Handle!');
end;


procedure SubclassBegin;
var
   lResult : LongInt;
begin
   {begin subclassing of window with specified handle}
   frmSubclass.lbMsg.Items.Add('Subclass ON');

   {get long pointer to previous window function}
   lOldFunction := GetWindowLong(hForm, GWL_WNDPROC);

   {get address of our new window function}
   pWindowProc := @NewWindowFunction;

   {display some info in listbox}
   frmSubclass.lbMsg.Items.Add('pWindowProc:'+IntToHex(LongInt(pWindowProc),4));
   frmSubclass.lbMsg.Items.Add('Old Function was:' + IntToHex(lOldFunction,8));

   {install our new window function}
   lResult := SetWindowLong(hForm, GWL_WNDPROC, LongInt(pWindowProc));

   {subclassing is now on}
end;

procedure SubclassEnd;
var
   lResult : LongInt;
begin
   {end subclassing of window with specified handle}

   {reset window function to original function address}
   lResult := SetWindowLong(hForm, GWL_WNDPROC, lOldFunction);

   {display some info in listbox}
   frmSubclass.lbMsg.Items.Add('Subclass OFF');
end;

procedure TfrmSubclass.cbExitClick(Sender: TObject);
begin
     if hForm>0 then
        SubclassEnd;
     frmSubclass.Close;
end;

procedure TfrmSubclass.cbStartClick(Sender: TObject);
begin
     hForm := GetHandle;
     if hForm >0 then
       begin
        frmSubclass.cbStart.Enabled := False;  {disable buttons}
        frmSubclass.ebHandle.Enabled := False;
        frmSubclass.chkHex.Enabled := False;
        frmSubclass.stHandle.Enabled := False;
        frmSubclass.cbStop.Enabled := True;
        SubclassBegin;    {begin subclassing}
       end;
end;

procedure TfrmSubclass.cbStopClick(Sender: TObject);
begin
     SubclassEnd;   {end subclassing}
     frmSubclass.cbStart.Enabled := True;   {enable buttons}
     frmSubclass.ebHandle.Enabled := True;
     frmSubclass.chkHex.Enabled := True;
     frmSubclass.stHandle.Enabled := True;
     frmSubclass.cbStop.Enabled := False;
     hForm := 0;        {reset handle variable}
end;

procedure TfrmSubclass.FormShow(Sender: TObject);
begin
     hForm := 0;
end;

end.
