unit Stringhl;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms;

type
  TStringHolder = class(TComponent)
  private
     FStrings: TStrings;
  protected
     procedure SetStrings( sStrings: TStrings );
  public
     constructor Create( AOwner: TComponent ); override;
     destructor Destroy; override;
  published
     property Strings: TStrings read FStrings write SetStrings;
  end;

procedure Register;

implementation

constructor TStringHolder.Create( AOwner: TComponent );
begin
  inherited Create( AOwner );
  FStrings := TStringList.Create;
end;

destructor TStringHolder.Destroy;
begin
  FStrings.Free;
  inherited Destroy;
end;

procedure TStringHolder.SetStrings( sStrings: TStrings );
begin
  FStrings.Assign( sStrings );
end;

procedure Register;
begin
  RegisterComponents('SilCmd', [TStringHolder]);
end;

end.
