unit Stamps;
{This TTimeStamp Component shows the Application Compile Date as a
 DateTime string or number simply by changing the Display property.
 In the Design mode it shows '12/31/99 12:59:58 PM' or '664758141'.
 It has all the propreties of a TLabel except Caption is not published.
 Put one on your About Dialog and you have instant version control.
 By Bill Murto, CIS 73730,2505. No Copyright. No Fee. No Guarantee. Enjoy!}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Menus, StdCtrls;

type
  TTimeStampDisplayType = (dtString, dtNumber);
  TTimeStamp = class(TCustomLabel)
  private
    { Private declarations }
    fDisplay: TTimeStampDisplayType;
    procedure SetDisplay(Value: TTimeStampDisplayType);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property Align;
    property Alignment;
    property AutoSize;
    property Color;
    property Display: TTimeStampDisplayType read fDisplay write SetDisplay default dtString;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FocusControl;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TTimeStamp]);
end;

constructor TTimeStamp.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  SetDisplay(dtString);
end;

procedure TTimeStamp.SetDisplay(Value: TTimeStampDisplayType);
begin
  fDisplay := Value;
  if csDesigning in ComponentState then
    case fDisplay of
      dtString: Caption := '12/31/99 12:59:58 PM';
      dtNumber: Caption := '664758141';
    end
  else
    case fDisplay of
      dtString: Caption := DateTimeToStr(FileDateToDateTime(Fileage(Application.ExeName)));
      dtNumber: Caption := IntToStr(Fileage(Application.ExeName));
    end;
end;

end.
