unit Ptrfunc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Dyninout, DB, DBTables, StdCtrls;

type
  TForm1 = class(TDynSQLClass)
    Edit1: TEdit;
    Database1: TDatabase;
    Query1: TQuery;
    Delete: TButton;
    Edit2: TEdit;
    Edit3: TEdit;
    NewCancel: TButton;
    AddUpdate: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ListBox1: TListBox;
    FillListBox: TQuery;
    DataSource1: TDataSource;
    FillListBoxSEQNUM: TIntegerField;
    FillListBoxCODE: TStringField;
    FillListBoxDESCRIPTION: TStringField;
    procedure FormCreate(Sender: TObject);
    procedure DeleteClick(Sender: TObject);
    procedure NewCancelClick(Sender: TObject);
    procedure AddUpdateClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure FillListBoxAfterOpen(DataSet: TDataset);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
implementation

{$R *.DFM}

{Example of filling out info for a Delete TQuery component.}
function Query1DeleteSQLInfo(var FieldDef: Pointer; SQLType: string): string; far;
begin
   with TSQLFieldInfo(FieldDef)^ do begin
      ComponentName := 'Query1';
      ExtraParm := 'Delete';
   end;
end;

{Example of filling out info for a Update TQuery component.}
function Query1UpdateSQLInfo(var FieldDef: Pointer; SQLType: string): string; far;
begin
   with TSQLFieldInfo(FieldDef)^ do begin
      ComponentName := 'Query1';
      ExtraParm := 'Update';
   end;
end;

{Example of filling out info for a Insert TQuery component.}
function Query1InsertSQLInfo(var FieldDef: Pointer; SQLType: string): string; far;
begin
   with TSQLFieldInfo(FieldDef)^ do begin
      ComponentName := 'Query1';
      ExtraParm := 'Insert';
   end;
end;

   {Possible fields to fill in FieldDef:
   {  Table            {Table data is associated with.}
   {  Column           {Column in table that data is associated with.}
   {  DataType         {Type of data: N = Number, T = Text String, D = Date}
   {  KeyFlag          {Primary key (P) or Foreign Key (F)... Only really need Primary}

   {  ExtraParm        {Allows extra functionality. Like MaxPlusOne - see below.}

   {  ComponentName    {The value of the Name property of the component.}
   {  StringData       {If the data can be represented as a string you can pass it to me.}
   {  ComponentNumber  {The number of the component (each component has a number within a form)}

   {  ComponentType    {The type of the component: Edit = Edit field, Memo = Memo field}
   {  PtrData          {Can pass the data via a pointer - not yet implimented.}
   {  NextOne          {Pointer to next object - I will be filling this out.}

   {SQLType will either have: Insert, Update or Delete as its value. You can
     use this to alter what you send according to what is about to happen.}

{Example of filling out info for a field.}
function Edit1SQLInfo(var FieldDef: Pointer; SQLType: string): string; far;
begin
   {These fields are mandatory. However, ExtraParm & KeyFlag are only needed for THIS
    primary key. The MaxPlusOne will run a Max(SEQNUM)+1 to generate a unique number for
    this column.}
   with TSQLFieldInfo(FieldDef)^ do begin
      Table := 'Table1';
      Column := 'SEQNUM';
      DataType := 'N';
      ExtraParm := 'MaxPlusOne'; {You can add more parameters here - seperate
                                 each one with a space. So, if you also did not
                                 want the field cleared, set it to: 'MaxPlusOne NoClear'}
      KeyFlag := 'P';

      ComponentName := 'Edit1';

      {I can get this one for ya. You CAN fill it out if you want to.}
      StringData := Form1.Edit1.Text; {This is usually only needed if you need to
                                 pull the data from a control that I do not support.
                                 I put it here as an example. In reality, I can pull
                                 the data from this TEdit component.}
   end;
end;

{Example of filling out info for a field.}
function Edit2SQLInfo(var FieldDef: Pointer; SQLType: string): string; far;
begin
   {These fields are mandatory.}
   with TSQLFieldInfo(FieldDef)^ do begin
      Table := 'Table1';
      Column := 'CODE';
      DataType := 'T';

      ComponentName := 'Edit2';
   end;
end;

{Example of filling out info for a field.}
function Edit3SQLInfo(var FieldDef: Pointer; SQLType: string): string; far;
begin
   {These fields are mandatory.}
   with TSQLFieldInfo(FieldDef)^ do begin
      Table := 'Table1';
      Column := 'DESCRIPTION';
      DataType := 'T';
      ComponentName := 'Edit3';

      {I can get this one for ya. You CAN fill it out if you want to.}
      StringData := Form1.Edit3.Text; {This is usually only needed if you need to
                                 pull the data from a control that I do not support.
                                 I put it here as an example. In reality, I can pull
                                 the data from this TEdit component.}
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  {Will process all SQL using the DynBuild procedures.}
  DynSetSQLProcessType('DynBuild');
 {Can have an array or link list of records. The record MUST contain then
  name of they function type (FuncType in this example) and a pointer to
  the function. This can be filled by me sending the user a message to
  populate it - can then have a message to do a refresh! The functions
  will be used to tell me what I need. Way cool idea! Useful... We'll see.}
  SQLAddFunction(@Query1UpdateSQLInfo, '');
  SQLAddFunction(@Query1InsertSQLInfo, '');
  SQLAddFunction(@Query1DeleteSQLInfo, '');
  SQLAddFunction(@Edit1SQLInfo, '');
  SQLAddFunction(@Edit2SQLInfo, '');
  SQLAddFunction(@Edit3SQLInfo, '');

  inherited FormCreate(Sender); {This calls the parent form create.}
  FillListBox.Close;
  FillListBox.Open;
  Form1.Show;
end;

procedure TForm1.DeleteClick(Sender: TObject);
begin
  inherited DeleteClick(Sender);
  FillListBox.Close;
  FillListBox.Open;
  ListBox1.SetFocus;
end;

procedure TForm1.NewCancelClick(Sender: TObject);
begin
   Inherited NewCancelClick(Sender);
  if (NewCancel.Caption = 'Canc&el') then begin {New button was just hit.}
     ListBox1.Enabled := False;
     Edit2.SetFocus;
  end
  else begin  {Cancel button was just hit.}
     FillListBox.Close;
     FillListBox.Open;
     ListBox1.Enabled := True;
     ListBox1Click(Self);   {Click the list box.}
     ListBox1.SetFocus;
  end;
end;

procedure TForm1.AddUpdateClick(Sender: TObject);
begin
   Inherited AddUpdateClick(Sender, AddUpdate.Caption);
  FillListBox.Close;
  FillListBox.Open;
  if (AddUpdate.Caption = '&Update') then begin
     ListBox1.SetFocus;
  end
  else begin
     {I figure out what fields need to be cleared through a call to Insert because it is
      these fields that will be edited.}
     if (DynGetSQLProcessType = 'DynBuild') then begin
        TypeOfCall := 'CalledLocal';
        SQLRunFunction('Insert');
        TypeOfCall := '';
     end;
     SetDataEntryProp('Clear', nil);
     Edit2.SetFocus;
  end;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
var
   MyIndex: Integer;
begin
   MyIndex := ListBox1.ItemIndex; {Current selection in list box.}
   {I figure out what fields need to be cleared through a call to Insert because it is
    these fields that will be edited.}
   if (DynGetSQLProcessType = 'DynBuild') then begin
      TypeOfCall := 'CalledLocal';
      SQLRunFunction('Insert');
      TypeOfCall := '';
   end;
   SetDataEntryProp('Clear', nil);
   with FillListBox do begin
      first;           {Reset pointer to data grid.}
      MoveBy(MyIndex); {Move to same offset as listbox.}
      {Fill in edit fields.}
      {Yes, this is lame... I will change it later...}
      Edit1.Text := Fields[0].AsString;
      Edit2.Text := Fields[1].AsString;
      Edit3.Text := Fields[2].AsString;
   end;
end;

procedure TForm1.FillListBoxAfterOpen(DataSet: TDataset);
begin
   ListBox1.Clear; {Clear the list box}
   {Fill the list box from the data grid.}
   with FillListBox do begin
      first;
      while (not(EOF)) do begin
        ListBox1.Items.Add(Fields[2].AsString);
        next;
      end;
   end;
   ListBox1.ItemIndex := 0; {Set selection in the list box.}
   ListBox1Click(Self);   {Click the list box.}
end;

end.
