unit Paramsql;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, Dyninout;

type
  TForm2 = class(TDynSQLClass)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Delete: TButton;
    Edit2: TEdit;
    Edit3: TEdit;
    NewCancel: TButton;
    AddUpdate: TButton;
    ListBox1: TListBox;
    DataSource1: TDataSource;
    FillListBox: TQuery;
    FillListBoxSEQNUM: TIntegerField;
    FillListBoxCODE: TStringField;
    FillListBoxDESCRIPTION: TStringField;
    Query1: TQuery;
    Database1: TDatabase;
    procedure FormCreate(Sender: TObject);
    procedure DeleteClick(Sender: TObject);
    procedure NewCancelClick(Sender: TObject);
    procedure AddUpdateClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure FillListBoxAfterOpen(DataSet: TDataset);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.FormCreate(Sender: TObject);
begin
  {Will process all SQL using the DynBuild procedures.}
  DynSetSQLProcessType('ParmBuild');
  inherited FormCreate(Sender); {This calls the parent form create.}
  FillListBox.Active := TRUE;
  FillListBox.Close;
  FillListBox.Open;
end;

procedure TForm2.DeleteClick(Sender: TObject);
begin
  inherited DeleteClick(Sender);
  FillListBox.Close;
  FillListBox.Open;
  ListBox1.SetFocus;
end;

procedure TForm2.NewCancelClick(Sender: TObject);
begin
   Inherited NewCancelClick(Sender);
  if (NewCancel.Caption = 'Canc&el') then begin {New button was just hit.}
     ListBox1.Enabled := False;
     Edit2.SetFocus;
  end
  else begin  {Cancel button was just hit.}
     FillListBox.Close;
     FillListBox.Open;
     ListBox1.Enabled := True;
     ListBox1Click(Self);   {Click the list box.}
     ListBox1.SetFocus;
  end;
end;

procedure TForm2.AddUpdateClick(Sender: TObject);
begin
   Inherited AddUpdateClick(Sender, AddUpdate.Caption);
  FillListBox.Close;
  FillListBox.Open;
  if (AddUpdate.Caption = '&Update') then begin
     ListBox1.SetFocus;
  end
  else begin
     SetDataEntryProp('Clear', nil);
     Edit2.SetFocus;
  end;
end;

procedure TForm2.ListBox1Click(Sender: TObject);
var
   MyIndex: Integer;
begin
   MyIndex := ListBox1.ItemIndex; {Current selection in list box.}
   SetDataEntryProp('Clear', nil);
   with FillListBox do begin
      first;           {Reset pointer to data grid.}
      MoveBy(MyIndex); {Move to same offset as listbox.}
      {Fill in edit fields.}
      {Yes, this is lame... I will change it later...}
      Edit1.Text := Fields[0].AsString;
      Edit2.Text := Fields[1].AsString;
      Edit3.Text := Fields[2].AsString;
   end;
end;

procedure TForm2.FillListBoxAfterOpen(DataSet: TDataset);
begin
   ListBox1.Clear; {Clear the list box}
   {Fill the list box from the data grid.}
   with FillListBox do begin
      first;
      while (not(EOF)) do begin
        ListBox1.Items.Add(Fields[2].AsString);
        next;
      end;
   end;
   ListBox1.ItemIndex := 0; {Set selection in the list box.}
   ListBox1Click(Self);   {Click the list box.}
end;

end.
