{Header file for DynInOut.Pas}

const
  sx_MyMessage = wm_user + 100;

type
  {Will hold the input field names.}
  InOutObject = ^TInOutNames;
  TInOutNames = record
     Column: String[50];
     ColType: String[10];
     KeyFlag,
     CompType,
     ExtraFlag: String[20];
     CompNum,
     DataGroup: Integer;
     NextOne: Pointer;
  end;
  {Will hold information about the Insert, Update, and Delete buttons.}
  SQLButton = ^TButtonInfo;
  TButtonInfo = record
     CompText: String;
     CompNum: Integer;
  end;
  {Will hold information about the list boxes.}
  SQLListBox = ^TListBoxInfo;
  TListBoxInfo = record
     DispCols: String;
     CompNum,
     DataGroup: Integer;
     NextOne: Pointer;
  end;
  {Will hold information about fields to be used in the Insert, Update, and Delete
    of the data.}
  TSQLFieldInfo = ^TSQLFieldInfoRec;
  TSQLFieldInfoRec = record
     Table,                {Table data is associated with.}
     Column,               {Column in table that data is associated with.}
     ExtraParm,            {Allows extra functionality. Like MaxPlusOne - see below
                            Valid values:
                            -------------
                              MaxPlusOne - Runs a max(ColumnName)+1 to generate a unique number
                              NoClear - I will not clear the field at all
                              DeleteMe - I will not add this object to my list.

                              Delete - Used to say that this is the TQuery component to run
                                       the Delete SQL.
                              Insert - Used to say that this is the TQuery component to run
                                       the Insert SQL.
                              Update - Used to say that this is the TQuery component to run
                                       the Update SQL.}
     ComponentName,        {The value of the Name property of the component.}
     ComponentType,        {The type of the component: Edit = Edit field, Memo = Memo field}
     StringData: String;   {If the data can be represented as a string you can pass it to me.}
     DataType,             {Type of data: N = Number, T = Text String, D = Date}
     KeyFlag: String[1];   {Primary key (P) or Foreign Key (F)... Only really need Primary}
     CompNum: Integer;     {The number of the component (each component has a number within a form)}
     PtrData,              {Can pass the data via a pointer - see restrictions below.}
     NextOne: Pointer;     {Pointer to next object}
  end;
  {Dynamic SQL Input/Output functions and arrays.}
  SQLFuncType = function (var FieldDef: Pointer; SQLType: string): string;

  {Will hold information about the list boxes.}
  TSQLFunctions = ^TSQLFuncRec;
  TSQLFuncRec = record
     FuncPtr,
     NextOne: Pointer;
  end;

  {Will hold information (in a TStringList called ListOfControlsByName) about the controls.}
  TSQLControlInfo = ^TSQLControlInfoR;
  TSQLControlInfoR = record
     CICompNumber: integer;
     CICompType: string;
  end;

  {Generic read-in write-out class.}
  TDynSQLClass = class(TForm)
  protected
     {I set this variable if I need to query the user's Dynamic function for informational
      purposes only. It will be empty if I am actually processing a SQL statement.
     At this time the valid value is: CalledByClear}
     TypeOfCall: string;

     {Get the database names for components and clear them.}
     procedure FormCreate(Sender: TObject); dynamic;
     {Click of the New or Cancel button.}
     procedure NewCancelClick(Sender: TObject); dynamic;
     {Click of the Add or Update button}
     procedure AddUpdateClick(Sender: TObject; CaptionText: string); dynamic;
     {Click of the Delete button}
     procedure DeleteClick(Sender: TObject); dynamic;

     {Can allow a property to be set on ALL data entry fields (including the TQuery
      components). It currently (11-23-95) clears all entry fields.}
     procedure SetDataEntryProp(Prop: String; Value: Pointer);
     {Sets the type of SQL processing for the screen.
      Valid types are:
       'ParmBuild' - Build SQL using parameters obtained from TEdit and TMemo fields on FormCreate.
       'DynBuild' - Build the SQL from what is specified by the sub-programs that were identified on FormCreate}
     procedure DynSetSQLProcessType(SQLProcessType: string);
     function DynGetSQLProcessType: string;

    {Member functions to handle Dynamic SQL}
     {Allow user to add functions to the SQL Update, Insert, and Delete list.
      They will be called to prep the Update, Insert, and Delete SQL statements.}
     procedure SQLAddFunction(Func: Pointer; Code: string);
     {Runs all of the functions, building objects to cause an Update, Insert or Delete}
     procedure SQLRunFunction(Code: string);

  private
    { Private declarations }
    {Variables}
     InOutHeadPtr,
     InOutLastPtr,
     UpdateAddBPtr,
     NewCancelBPtr,
     DeleteBPtr,
     LBHeadPtr,
     LBLastPtr,
     DynHeadPtr,
     DynLastPtr,
     DynFuncHeadPtr,
     DynFuncLastPtr: Pointer;
     TypeOfSQLDef,
     AlternateSQLCol,
     AlternateSQLData,
     AlternateSQLStmt: string;
     TotalAltCols: integer;
     ListOfControlsByName: TStringList;

    {Member Functions}
     procedure SXMyMessage(var Msg: TMessage); message sx_MyMessage;

     {Allocates memory for and creates the next InOutObject (which is basically used
      to track database names for components.)}
     function CreateNewInOut(DBColumn: string; I: Integer; ColumnType: string): Pointer;

    {Member functions to build SQL statements}
     {Builds the column and data part of the SQL statement}
     procedure BuildSqlDetail(HoldCol, Data: string; var SqlTmp1, SqlTmp2: string; TypeDet, KeyFlag: string);
     {Pulls the data out of the component and returns it}
     function ReturnText(CompNum: Integer): string;
     {Takes the data from ReturnText and formats it for SQL}
     function ProcessSQLData(Data: string; ColType: string): string;
     {Run an SQL statement in the indicated TQuery object}
     function RunSQL(SQLStmt: string; SqlComp: Integer): Integer;
     {Set up the information on the listbox.}
     procedure SetupListBox(ComponentNum: integer);

    {Member functions for Parameter based SQL building}
     {Set InOutObject list pointers.}
     procedure SetHeadPtr(HeadPtr: Pointer);
     procedure SetLastPtr(LastPtr: Pointer);
     {Delete button clicked - This uses the information collected from the TEdit
      and TMemo text fields.}
     procedure DeleteClickParmBuild(var Table, SqlTmp2: String; var SqlComp: Integer);
     {Add/Update button clicked - This uses the information collected from the TEdit
      and TMemo text fields.}
     procedure AddUpdateClickParmBuild(var Table, SqlTmp1, SqlTmp2, CaptionText: string;
      var SqlComp, MaxFlag: integer);

    {Member functions to handle Dynamic SQL}
     {Set TSQLFieldInfo list pointers.}
     procedure DynSetHeadPtr(HeadPtr: Pointer);
     procedure DynSetLastPtr(LastPtr: Pointer);
     {Deletes Function Object list.}
     procedure SQLDelFunctionList;
     {Deletes Field Object list.}
     procedure SQLDelFieldList;
     {Delete button clicked - This uses the information collected from programmer defined
      functions.}
     procedure DeleteClickDynBuild(var DelTable, SqlTmp2: String; var SqlComp: Integer);
     {Add/Update button clicked - This uses the information collected from the TEdit
       and TMemo text fields.}
     procedure AddUpdateClickDynBuild(var DelTable, SqlTmp1, SqlTmp2, CaptionText: string;
       var SqlComp, MaxFlag: integer);
 public
     { Public declarations }
     constructor Create(AOwner: TComponent); override;
     destructor Destroy; override;
     procedure NotifyMe(ToWhom, Msg: Pointer);

     {Processes: Can allow a property to be set on ALL data entry fields (including the TQuery
       components). It currently (11-23-95) clears all entry fields.}
     procedure ProcessSetDataEntryProp(Prop: String; Value: Pointer; CompNum: Integer);

     {Returns the first word from a string - Seperates string by Sep string}
     function ReturnFirstWord(Data: string; Sep: string): string;
     {Returns the string, minus the first word from a string - Seperates string by Sep string}
     function TakeFirstWordOff(Data: string; Sep: string): string;

     {Get InOutObject list pointers.}
     function GetHeadPtr: Pointer;
     function GetLastPtr: Pointer;
     {Get TSQLFieldInfo list pointers.}
     function DynGetHeadPtr: Pointer;
     function DynGetLastPtr: Pointer;
  end;


