unit Untdemo3;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Mchsprt, ExtCtrls, MChSpBg, StdCtrls;

type
  TForm1 = class(TForm)
    MChSpriteBgr1: TMChSpriteBgr;
    MChSprite1: TMChSprite;
    MChSprite2: TMChSprite;
    MChSprite3: TMChSprite;
    MChSprite4: TMChSprite;
    MChSprite5: TMChSprite;
    MChSprite6: TMChSprite;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function Sprite3PosFunc(AtTime: TDateTime):TPoint;
function Sprite4PosFunc(AtTime: TDateTime):TPoint;
function Sprite6PosFunc(AtTime: TDateTime):TPoint;
procedure OnCollide(SprCollided: TMChSprite; AtTime: TDateTime);
procedure NoCollide(AtTime: TDateTime);
procedure OnExplosion(SprCollided: TMChSprite; AtTime: TDateTime);

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
  CollideFlip, Exploding: Boolean;

function Sprite3PosFunc(AtTime: TDateTime):TPoint;
  var
    x,y,alpha: double;
  begin
  alpha:=-2*Pi*(AtTime-Form1.MChSprite3.SprTimeStarted)*24.0*60.0+(90.0-180.0)/180.0*Pi;
  x := Form1.MChSpriteBgr1.ClientWidth /2.0 +
      (Form1.MChSpriteBgr1.ClientWidth /3.0)*cos(alpha);
  y := Form1.MChSpriteBgr1.ClientHeight*0.5 +
    - (Form1.MChSpriteBgr1.ClientWidth *0.55)*sin(alpha);
  Sprite3PosFunc:=Point(round(x),round(y));
  if x>Form1.MChSpriteBgr1.ClientWidth div 2
    then Form1.MChSprite3.SprSetScaleX( (1-1.0*sin(alpha)))
    else Form1.MChSprite3.SprSetScaleX(-(1-1.0*sin(alpha)));
  if y<Form1.MChSpriteBgr1.ClientHeight div 2
    then Form1.MChSprite3.SprSetScaleY( (1-1.0*sin(alpha)))
    else Form1.MChSprite3.SprSetScaleY(-(1-1.0*sin(alpha)));
  end;

function Sprite4PosFunc(AtTime: TDateTime):TPoint;
  var
    x,y,alpha: double;
  begin
  alpha:= 2*Pi*(AtTime-Form1.MChSprite4.SprTimeStarted)*24.0*60.0+(90.0+0.0)/180.0*Pi;
  x := Form1.MChSpriteBgr1.ClientWidth /2.0 +
      (Form1.MChSpriteBgr1.ClientWidth /3.0)*cos(alpha);
  y := Form1.MChSpriteBgr1.ClientHeight /2.0 +
    - (Form1.MChSpriteBgr1.ClientWidth /3.0)*sin(alpha);
  Sprite4PosFunc:=Point(round(x),round(y));
  Form1.MChSprite4.SprSetScale(1-0.9*sin(alpha));
  end;

function Sprite6PosFunc(AtTime: TDateTime):TPoint;
  begin
  Sprite6PosFunc:=Point(Form1.MChSpriteBgr1.ClientWidth  div 2,
                        Form1.MChSpriteBgr1.ClientHeight div 2);
  Form1.MChSprite6.SprSetScale(1.25*(AtTime-Form1.MChSprite6.SprTimeStarted)
         *24.0*60.0*60.0*5.0);
  if (AtTime-Form1.MChSprite6.SprTimeStarted)*24.0*60.0*60.0>17 then
    Form1.MChSprite6.SprHide;
  end;

procedure TForm1.FormCreate(Sender: TObject);
  begin
  Exploding:=False;
  MChSprite2.SprShowAt(Point(Form1.MChSpriteBgr1.ClientWidth  div 2,
                             Form1.MChSpriteBgr1.ClientHeight div 2));
  MChSprite3.SprPosFunc:=Sprite3PosFunc;
  MChSprite4.SprPosFunc:=Sprite4PosFunc;
  MChSprite6.SprPosFunc:=Sprite6PosFunc;
  MChSprite6.SprHideAfter:=True;
  MChSprite6.SprOnCollide:=OnExplosion;
  MChSprite4.SprOnCollide:=OnCollide;
  MChSprite4.SprNoCollide:=NoCollide;
  MChSprite3.SprCruise(-1);
  MChSprite4.SprCruise(-1);
  MChSprite6.SprMoveTo(Point(Form1.MChSpriteBgr1.ClientWidth  div 2,
                             Form1.MChSpriteBgr1.ClientHeight div 2));
  end;

procedure OnCollide(SprCollided: TMChSprite; AtTime: TDateTime);
  begin
  if SprCollided=Form1.MChSprite3 then
    begin
    if not CollideFlip then
      begin
      MessageBeep(MB_ICONASTERISK);
      CollideFlip:=True;
      end;
    if Form1.MChSprite4.SprNextPos.x<Form1.MChSpriteBgr1.ClientWidth div 2 then
      begin
      if Form1.MChSprite4.SprIndex<Form1.MChSprite3.SprIndex then
        Form1.MChSpriteBgr1.BgrSprIndexExchangeZ(Form1.MChSprite4.SprIndex,
          Form1.MChSprite3.SprIndex);
      end
    else
      begin
      if Form1.MChSprite4.SprIndex>Form1.MChSprite3.SprIndex then
        Form1.MChSpriteBgr1.BgrSprIndexExchangeZ(Form1.MChSprite4.SprIndex,
          Form1.MChSprite3.SprIndex);
      end;
    end;
  end;

procedure OnExplosion(SprCollided: TMChSprite; AtTime: TDateTime);
  begin
  if Exploding then
    begin
    SprCollided.SprStop;
    SprCollided.SprHide;
    end;
  if (not Exploding) and (SprCollided=Form1.MChSprite1) then
    begin
    Exploding:=True;
    Form1.MChSprite2.SprColliding:=True;
    Form1.MChSprite5.SprColliding:=True;
    Form1.MChSprite6.SprCruise(20);
    end;
  end;

procedure NoCollide(AtTime: TDateTime);
  begin
  if CollideFlip then
    begin
    MessageBeep(MB_OK);
    end;
  CollideFlip:=False;
  end;

procedure TForm1.Button1Click(Sender: TObject);
  begin
  Exploding:=False;
  MChSprite6.SprSetScale(0.2);
  MChSprite6.SprMoveTo(Point(Form1.MChSpriteBgr1.ClientWidth  div 2,
                             Form1.MChSpriteBgr1.ClientHeight div 2));
  Form1.MChSprite1.SprColliding:=True;
  Form1.MChSprite6.SprColliding:=True;
  Form1.MChSprite1.SprGo( Point(Form1.MChSpriteBgr1.ClientWidth,0),
             Point(Form1.MChSpriteBgr1.ClientWidth  div 2,
                   Form1.MChSpriteBgr1.ClientHeight div 2), 5 );
  end;

procedure TForm1.Button2Click(Sender: TObject);
  begin
  MChSprite5.SprColliding:=False;
  MChSprite5.SprHideAfter:=True;
  MChSprite5.SprGo(Point(Form1.MChSpriteBgr1.ClientWidth,
                         Form1.MChSpriteBgr1.ClientHeight),
                   Point(0,0), 20);
  end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
  begin
  MChSpriteBgr1.MChSpriteBgrMouseDown(Sender,Button,Shift,X,Y);
  if MChSpriteBgr1.BgrSprHitted=MChSprite5 then
    begin
    MChSprite5.SprHideAfter:=False;
    MChSprite5.SprStop;
    end;
  end;

procedure TForm1.Button3Click(Sender: TObject);
  begin
  Exploding:=False;
  MChSprite1.SprColliding:=False;
  MChSprite2.SprColliding:=False;
  MChSprite5.SprColliding:=False;
  MChSprite6.SprColliding:=False;
  MChSprite6.SprHide;
  MChSprite5.SprHideAfter:=True;
  MChSprite2.SprShowAt(Point(Form1.MChSpriteBgr1.ClientWidth  div 2,
                             Form1.MChSpriteBgr1.ClientHeight div 2));
  MChSprite3.SprCruise(-1);
  MChSprite4.SprCruise(-1);
  end;

end.
