unit Untdemo2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Mchsprt, ExtCtrls, MChSpBg;

type
  TForm1 = class(TForm)
    MChSpriteBgr1: TMChSpriteBgr;
    MChSprite1: TMChSprite;
    MChSprite2: TMChSprite;
    MChSprite3: TMChSprite;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function Sprite2PosFunc(AtTime: TDateTime):TPoint;
function Sprite3PosFunc(AtTime: TDateTime):TPoint;
procedure OnCollide(SprCollided: TMChSprite; AtTime: TDateTime);
procedure NoCollide(AtTime: TDateTime);

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
  CollideFlip: Boolean;

function Sprite3PosFunc(AtTime: TDateTime):TPoint;
  var
    x,y,alpha: double;
  begin
  alpha:= 2*Pi*(AtTime-Form1.MChSprite3.SprTimeStarted)*24.0*60.0+(90.0+0.0)/180.0*Pi;
  x := Form1.MChSpriteBgr1.ClientWidth /2.0 +
      (Form1.MChSpriteBgr1.ClientWidth /3.0)*cos(alpha);
  y := Form1.MChSpriteBgr1.ClientHeight /2.0 +
    - (Form1.MChSpriteBgr1.ClientWidth /3.0)*sin(alpha);
  Sprite3PosFunc:=Point(round(x),round(y));
  Form1.MChSprite3.SprSetScale(1-1.0*sin(alpha));
  end;

function Sprite2PosFunc(AtTime: TDateTime):TPoint;
  var
    x,y,alpha: double;
  begin
  alpha:=-2*Pi*(AtTime-Form1.MChSprite2.SprTimeStarted)*24.0*60.0+(90.0-180.0)/180.0*Pi;
  x := Form1.MChSpriteBgr1.ClientWidth /2.0 +
      (Form1.MChSpriteBgr1.ClientWidth /3.0)*cos(alpha);
  y := Form1.MChSpriteBgr1.ClientHeight*0.5 +
    - (Form1.MChSpriteBgr1.ClientWidth *0.55)*sin(alpha);
  Sprite2PosFunc:=Point(round(x),round(y));
  if x>Form1.MChSpriteBgr1.ClientWidth div 2
    then Form1.MChSprite2.SprSetScaleX( (1-1.0*sin(alpha)))
    else Form1.MChSprite2.SprSetScaleX(-(1-1.0*sin(alpha)));
  if y<Form1.MChSpriteBgr1.ClientHeight div 2
    then Form1.MChSprite2.SprSetScaleY( (1-1.0*sin(alpha)))
    else Form1.MChSprite2.SprSetScaleY(-(1-1.0*sin(alpha)));
  end;

procedure TForm1.FormCreate(Sender: TObject);
  begin
  MChSprite3.SprPosFunc:=Sprite3PosFunc;
  MChSprite2.SprPosFunc:=Sprite2PosFunc;
  MChSprite3.SprOnCollide:=OnCollide;
  MChSprite3.SprNoCollide:=NoCollide;
  MChSprite3.SprCruise(-1);
  MChSprite2.SprCruise(-1);
  MChSprite1.SprShowAt(Point(Form1.MChSpriteBgr1.ClientWidth  div 2,
                             Form1.MChSpriteBgr1.ClientHeight div 2));
  end;

procedure OnCollide(SprCollided: TMChSprite; AtTime: TDateTime);
  begin
  if SprCollided=Form1.MChSprite2 then
    begin
    if not CollideFlip then
      begin
      MessageBeep(MB_ICONASTERISK);
      CollideFlip:=True;
      end;
    if Form1.MChSprite3.SprNextPos.x<Form1.MChSpriteBgr1.ClientWidth div 2 then
      begin
      if Form1.MChSprite3.SprIndex<Form1.MChSprite2.SprIndex then
        Form1.MChSpriteBgr1.BgrSprIndexExchangeZ(Form1.MChSprite3.SprIndex,
          Form1.MChSprite2.SprIndex);
      end
    else
      begin
      if Form1.MChSprite3.SprIndex>Form1.MChSprite2.SprIndex then
        Form1.MChSpriteBgr1.BgrSprIndexExchangeZ(Form1.MChSprite3.SprIndex,
          Form1.MChSprite2.SprIndex);
      end;
    end;
  end;

procedure NoCollide(AtTime: TDateTime);
  begin
  if CollideFlip then
    begin
    MessageBeep(MB_OK);
    end;
  CollideFlip:=False;
  end;

end.
