unit Unit4;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Splitctl, Grids, VBXCtrl, Vtss,
  Vtssdll;

type
  TForm2 = class(TForm)
    Splitter1: TSplitter;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    Panel1: TPanel;
    Sheet1: TSheet;
    procedure Sheet1KeyDown(Sender: TObject; var KeyCode, Shift: Integer);
    procedure Sheet1KeyPress(Sender: TObject; var KeyAscii: Integer);
    procedure Sheet1EndEdit(Sender: TObject; var EditString: TBasicString;
      var Cancel: Integer);
    procedure Sheet1CancelEdit(Sender: TObject);
    procedure Panel1Resize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.Sheet1KeyDown(Sender: TObject; var KeyCode,
  Shift: Integer);
begin
  if GetKeyState(VK_Control)<0 then begin
    case chr(KeyCode) of
      'C' : SSEditCopy(Sheet1.SS);
      'X' : SSEditCut(Sheet1.SS);
      'V' : SSEditPaste(Sheet1.SS);
      else Exit;
    end;
  end;
end;

procedure TForm2.Sheet1KeyPress(Sender: TObject; var KeyAscii: Integer);
begin
  if chr(KeyAscii) in [^X,^C,^V] then Exit;
  Sheet1.AllowInCellEditing := true;
end;

procedure TForm2.Sheet1EndEdit(Sender: TObject;
  var EditString: TBasicString; var Cancel: Integer);
begin
  Sheet1.AllowInCellEditing := false;
end;

procedure TForm2.Sheet1CancelEdit(Sender: TObject);
begin
  Sheet1.AllowInCellEditing := false;
end;

procedure TForm2.Panel1Resize(Sender: TObject);
begin
  Sheet1.BoundsRect := Panel1.ClientRect;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  Sheet1.BoundsRect := Panel1.ClientRect;
end;

end.
