{
Splitter control v1.03.00  by Cerny Robert

Installation: standard, if you want to install it into D2, open the
              *.DCR file with ImagEdit and save it before installing.

Usage:        Drop it on the form and set the "ResizingControl" property.
              This link control can be any windowed control with alignment
              other than client or none. Then change it's color, if you
              wish. No coding required. A demo project included in zip.
New properties:
    property MinSize - minimum size of ResizingControl;
    property MinLeft - minimum left for other controls;

Comments:     Mail comments to: Robert.Cerny@eunet.si
Copyright:    This VC is free, but keep this comment header

This version removes a bug that sometimes cluttered other controls,
when you had several splitters on the form.

  Enjoy it!
}

unit Splitctl;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Controls,
  Graphics, ExtCtrls;

type
  TSplitter = class(TCustomPanel)
  private
    { Private declarations }
    MX,MY,PX,PY : integer;
    fMinSize,
    fMinLeft:integer;
    FResizingControl : TWinControl;
    FOnMoving : TMouseMoveEvent;
    FUpdate : integer;
    procedure SetResizingControl(Value:TWinControl);
    procedure DrawFocusRect(var R:TRect);
    procedure WMSize(var Msg); message WM_Size;
    procedure WMMove(var Msg); message WM_Move;
  protected
    { Protected declarations }
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    { Public declarations }
    constructor Create(AOwner:TComponent); override;
  published
    { Published declarations }
    property Color;
    property Enabled;
    property ParentColor;
    property ResizingControl : TWinControl read FResizingControl write SetResizingControl;
    property MinSize : integer read fMinSize write fMinSize;
    property MinLeft : integer read fMinLeft write fMinLeft;
    property Width;
    property Height;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnMoving : TMouseMoveEvent read FOnMoving write FOnMoving;
  end;

procedure Register;

implementation

uses
    DsgnIntf;
const
    DefSplitterWidth = 4;

function GetClipDC ( Control : TWinControl ) : hDC;
var
   ClipRect : tRect;
   ClipRgn  : hRgn;
begin
  ClipRect := Control.ClientRect;
  MapWindowPoints(Control.Handle,0,ClipRect,2);
  Inc(ClipRect.Right);
  Inc(ClipRect.Bottom);
  Result := GetDC ( 0 );
  SetViewPortOrgEx ( Result, ClipRect.Left, ClipRect.Top,nil );
  ClipRgn := CreateRectRgnIndirect ( ClipRect );
  SelectClipRgn ( Result, ClipRgn );
  DeleteObject ( ClipRgn );
end;

constructor TSplitter.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  Caption := '';
  FUpdate := 0;
end;

procedure TSplitter.DrawFocusRect(var R:TRect);
var
   DC : hDC;
   OldBrush:hBrush;
begin
  DC := GetClipDC ( Parent );
  SetROP2 ( DC, R2_NOT );
  OldBrush := SelectObject ( DC, GetStockObject ( HOLLOW_BRUSH ) );
  With R Do Rectangle ( DC, Left, Top, Right, Bottom );
  SelectObject ( DC, OldBrush );
  ReleaseDC ( 0, DC );
end;

procedure TSplitter.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var R,RM,RW : TRect;
    A : integer;
    WW : TWinControl;
    EqualAlign : boolean;
begin
  if (FResizingControl<>nil) and (Button = mbLeft) and not (ssDouble in Shift) then begin
    R := Parent.ClientRect;
    RM := BoundsRect;
    InflateRect(R,-DefSplitterWidth,-DefSplitterWidth);
    case Align of
      alTop :
        begin
          R.Top := FResizingControl.Top+DefSplitterWidth+fMinSize;
          Dec(R.Bottom,fMinLeft);
        end;
      alBottom :
        begin
          R.Bottom := FResizingControl.Top+FResizingControl.height-DefSplitterWidth-fMinSize;
          Inc(R.Top,fMinLeft);
        end;
      alLeft :
        begin
          R.Left := FResizingControl.Left+DefSplitterWidth+fMinSize;
          Dec(R.Right,fMinLeft);
        end;
      alRight :
        begin
          R.Right := FResizingControl.Left+FResizingControl.Width-DefSplitterWidth-fMinSize;
          Inc(R.Left,fMinLeft);
        end;
    end;
    for A := 0 to Parent.ControlCount-1 do begin
      WW := TWinControl(Parent.Controls[A]);
      RW := WW.BoundsRect;
      EqualAlign := WW.Align=Align;
      if (WW is TWinControl) and (WW.Align <> alNone) then case Align of
        alTop :
          if EqualAlign and (RW.Top>RM.Top) then
            Dec(R.Bottom,RW.Bottom-RW.Top)
          else if (RW.Top=RM.Bottom) and (R.Bottom >= RW.Bottom-DefSplitterWidth-1 ) then
            R.Bottom := RW.Bottom-DefSplitterWidth-1;
        alBottom :
          if EqualAlign and (RW.Bottom<RM.Bottom) then
            Inc(R.Top,RW.Bottom-RW.Top)
          else if (RW.Bottom=RM.Top) and (RW.Top+DefSplitterWidth+1>R.Top) then
            R.Top := RW.Top+DefSplitterWidth+1;
        alLeft :
          if EqualAlign and (RW.Left>RM.Left) then
            Dec(R.Right,RW.Right-RW.Left)
          else if (RW.Left=RM.Right) and (R.Right >= RW.Right-DefSplitterWidth-1 ) then
            R.Right := RW.Right-DefSplitterWidth-1;
        alRight :
          if EqualAlign and (RW.Right<RM.Right) then
            Inc(R.Left,RW.Right-RW.Left)
          else if (RW.Right=RM.Left) and (RW.Left+DefSplitterWidth+1>R.Left) then
            R.Left := RW.Left+DefSplitterWidth+1;
      end;
    end;
    MapWindowPoints(Parent.handle,0,R,2);
    ClipCursor(@R);
    R := BoundsRect;
    DrawFocusRect(R);
    MX := X;
    MY := Y;
    PX := X;
    PY := Y;
  end;
  inherited MouseDown(Button,Shift,X,Y);
end;

procedure TSplitter.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var R : TRect;
begin
  if (FResizingControl<>nil) and (Button = mbLeft) then begin
    R := BoundsRect;
    case Align of
      alTop,
      alBottom :
        begin
          OffsetRect(R,0,PY-MY);
          DrawFocusRect(R);
        end;
      alLeft,
      alRight :
        begin
          OffsetRect(R,PX-MX,0);
          DrawFocusRect(R);
        end;
    end;
    ClipCursor(nil);
    R := FResizingControl.BoundsRect;
    case Align of
      alTop : Inc(R.Bottom,Y-MY);
      alBottom : Inc(R.Top,Y-MY);
      alLeft : Inc(R.Right,X-MX);
      alRight : Inc(R.Left,X-MX);
    end;
    inc(FUpdate);
    FResizingControl.BoundsRect := R;
    SetResizingControl(FResizingControl);
    dec(FUpdate);
  end;
  inherited MouseUp(Button,Shift,X,Y);
end;

procedure TSplitter.MouseMove(Shift: TShiftState; X, Y: Integer);
var R : TRect;
begin
  if (FResizingControl<>nil) and (ssLeft in Shift) and (GetCaptureControl=Self)then begin
    R := BoundsRect;
    case Align of
      alTop,
      alBottom :
        begin
          OffsetRect(R,0,PY-MY);
          DrawFocusRect(R);
          OffsetRect(R,0,Y-PY);
          DrawFocusRect(R);
        end;
      alLeft,
      alRight :
        begin
          OffsetRect(R,PX-MX,0);
          DrawFocusRect(R);
          OffsetRect(R,X-PX,0);
          DrawFocusRect(R);
        end;
    end;
    PX := X;
    PY := Y;
    if Assigned(FOnMoving) then FOnMoving(Self,Shift,X,Y);
  end;
  inherited MouseMove(Shift,X,Y);
end;

procedure TSplitter.SetResizingControl(Value:TWinControl);
begin
  if Value = nil then begin
    FResizingControl := nil;
    Align := alNone;
    Exit;
  end;
{$ifdef win32}
  if Assigned(Value) then Value.FreeNotification(Self);
{$endif}
  if (Value.Align = alNone) or (Value.Align=alClient) then begin
    SetResizingControl(nil);
    Raise Exception.Create('Control''s align must be left, right, top or bottom');
  end;
  Inc(FUpdate);
  Align := Value.Align;
  Caption := '';
  case Value.Align of
    alTop,
    alBottom :
      begin
        Cursor := crVSplit;
        if Value.Align<>Align then Height := DefSplitterWidth;
      end;
    alLeft,
    alRight :
      begin
        Cursor := crHSplit;
        if Value.Align<>Align then Width := DefSplitterWidth;
      end;
  end;
  case Value.Align of
    alTop : Top := Value.Top+Value.Height;
    alBottom : Top := Value.Top-Height;
    alLeft: Left := Value.Left+Value.Width;
    alRight : Left := Value.Left-Width;
  end;
  Dec(FUpdate);
  FResizingControl := Value;
end;

procedure TSplitter.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (Operation = opRemove) and (AComponent=FResizingControl) then
    SetResizingControl(nil);
  inherited Notification(AComponent,Operation);
end;

procedure TSplitter.WMSize(var Msg);
begin
  inherited;
  if FUpdate = 0 then
    SetResizingControl(FResizingControl);
end;

procedure TSplitter.WMMove(var Msg);
begin
  inherited;
  if FUpdate = 0 then
    SetResizingControl(FResizingControl);
end;

{property editor}

type
    TResizeControlEditor = class(TComponentProperty)
    public
      procedure GetValues(Proc: TGetStrProc); override;
    end;

procedure TResizeControlEditor.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
  Splitter : TSplitter;
  P,P1 : TWinControl;
begin
  Values := TStringList.Create;
  try
    Splitter := GetComponent(0) as TSplitter;
    P := Splitter.Parent;
    for I := 0 to P.ControlCount-1 do begin
      P1 := TWinControl(P.Controls[I]);
      if (P1 is TWinControl)
        and (P1<>Splitter)
        and (P1.Align in [alLeft,alRight,alTop,alBottom])
        and (P1.Name <> '') then
          Values.Add(P1.Name);
    end;
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TSplitter]);
  RegisterPropertyEditor(TypeInfo(TWinControl),TSplitter,'ResizingControl',TResizeControlEditor);
end;

end.

