unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, SLGgraph, StdCtrls, Unit2;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button3: TButton;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    GroupBox3: TGroupBox;
    Label4: TLabel;
    Button2: TButton;
    SLGgraph1: TSLGgraph;
    procedure CalculateSpline;
    procedure Splint(Xcalc: Single; var Yspline: Single);
    procedure PlotSpline;
    procedure PlotTheData;

    procedure InitializeData;
    procedure UpdateArray(Xplot,YPlot: Single; Xpix, Ypix: Integer);
    procedure PlotPoint(X: Integer; Y: Integer);
    procedure SLGgraph1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button3Click(Sender: TObject);
    procedure SLGgraph1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SLGgraph1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  GoodPoint: Boolean;
  x, y, y2: Array [1..20] of Single;
  xp, yp: Array [1..20] of Integer;
  NaturalLowerBoundary, NaturalUpperBoundary: Boolean;
  yp1, ypn: Single;
  DataCount: Integer;
  FirstSpline: Boolean;
implementation

{$R *.DFM}

procedure TForm1.SLGgraph1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
   Xplot,Yplot: Single;
   Xpix, Ypix: Integer;
begin
   With SLGgraph1 do
   If CursorInPlotArea(X,Y) then begin
      Screen.Cursor := crCross;
      GetValues (X,Y,XPlot,YPlot,Xpix,Ypix);
      Label2.Caption := 'X = ' + FloatToStrF(XPlot,ffFixed,7,3);
      Label3.Caption := 'Y = ' + FloatToStrF(YPlot,ffFixed,7,3);
   end
   else
      Screen.Cursor := crDefault;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   SLGgraph1.Refresh; {Clear the graph}
   InitializeData;    {Initialize the data arrays}
end;

procedure TForm1.SLGgraph1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
   Xplot, Yplot: Single;
   Xpix, Ypix: Integer;
   i: Integer;
begin
   If SLGgraph1.CursorInPlotArea(X,Y) then begin
      GoodPoint := True;
      SLGgraph1.GetValues (X,Y,XPlot,YPlot,Xpix,Ypix); {Get the data where the mouse was clicked}
      If Not(FirstSpline) then begin                   {Erase the Last Spline and replot the points}
         SLGgraph1.PenColor := clWhite;
         PlotSpline;
         SLGgraph1.PenColor := clBlack;
         PlotTheData;
      end;
      UpdateArray(XPlot,YPlot,Xpix,Ypix);              {Put the point in the data arrays}
   end
   else
      GoodPoint := False;
end;

procedure TForm1.SLGgraph1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   If (DataCount >= 2) and (GoodPoint) then begin      {Must have at least 2 points}
      CalculateSpline;
      PlotSpline;
      FirstSpline := False;
   end;
end;


procedure TForm1.UpdateArray(Xplot,YPlot: Single; Xpix, Ypix: Integer);
var
   i, j: Integer;
begin
   Slggraph1.PenColor := clBlue;
   If DataCount = 20 then begin                      {Check the point count}
     Screen.Cursor := crDefault;
     ShowMessage ('You May Enter No More Than 20 Data Points.');
     exit;
   end;

   For i := 1 to DataCount do                        {Can't have two points with}
      If X[i] = Xplot then begin                     {the same x value.}
         Screen.Cursor := crDefault;
         ShowMessage ('May Not Have Two Points With the Same X Value.');
         exit;
      end;

   SLGgraph1.PenColor := clBlack;
   PlotPoint(Xpix,YPix);                             {Plot the point}
   SLGgraph1.PenColor := clBlue;

   {This routine opens up a spot in the arrays for the new data}

   j := 0;
   Repeat                                            {Pick where to put the new value}
      j := j + 1;
   Until Xplot < X[j];

   For i := DataCount+1 downto j do begin            {Make room for the new value}
      X[i] := X[i-1];
      Y[i] := Y[i-1];
      Xp[i] := Xp[i-1];
      Yp[i] := Yp[i-1];
   end;

   X[j] := XPlot;                                    {Insert the new data}
   Y[j] := YPlot;
   Xp[j] := Xpix;                                    {Save the Pixel coordinates for replotting}
   Yp[j] := Ypix;
   DataCount := DataCount + 1;                       {Bump the counter}

end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   Application.Terminate
end;

procedure TForm1.PlotPoint(X: Integer; Y: Integer);
begin
   With SLGgraph1 do begin
      MoveTo(X,Y);
      LineTo(X,Y+3);
      LineTo(X-3,Y+3);
      LineTo(X-3,Y-3);
      LineTo(X+3,Y-3);
      LineTo(X+3,Y+3);
      LineTo(X,Y+3)
   end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   InitializeData;  {Initialize the data arrays}
end;

procedure TForm1.InitializeData;
var
   i: Integer;
begin
   FirstSpline := True;
   DataCount := 0;
   For i := 1 to 20 do begin
      X[i] := 99;
   end;
end;

{==========================================================================================}
{=                                                                                        =}
{= Procedure CalculateSpline                                                              =}
{=                                                                                        =}
{= This is the routine that calculates the spline. It has been translated from code       =}
{= presented in the book Numerical Recipes for Fortran (Cambridge Press). SLG Data        =}
{= Systems makes no claims as to the accuracy of the translation, and may not be held     =}
{= liable for damage or loss of profit due to its installation and use. This code may be  =}
{= legally redistributed if and only if due recognition is given to Cambridge press.      =}
{=                                                                                        =}
{= Given arrays XData[1..n] and YData[1..n] containing a tabulated function               =}
{= ( i.e. y[i] := f(x[i]) with x[1] < x[2] ... < x[n] ), this routine calculates an array =}
{= Y2[1..n] which contains the second derivatives of the interpolating function at the    =}
{= at the tabulated points x[i]                                                           =}
{=                                                                                        =}
{= If either of the Boolean variables NaturalLowerBoundary or NaturalUpperBoundary is set =}
{= True, the routine calculates sets the corresponding boundary condition for a natural   =}
{= spline, with zero second derivative on that boundary. If either variable is false, the =}
{= variables Yp1 and/or Ypn are used to supply the first derivative of the interpolating  =}
{= function at the appropriate boundary                                                   =}
{=                                                                                        =}
{= This routine is called only once to to process the entire function. Once this has been =}
{= done, values of the interpolated function for any value of x may be obtained by        =}
{= calling routine EvaluateSpline, one call per interpolated value desired.               =}
{==========================================================================================}

{ In this implementation, the Data arrays are X and Y, and contain DataCount
  points (all Form level variables). The Boolean variables NaturalLowerBoundary and
  NaturalUpperBoundary, the Y2 array, and the boundary derivatives Yp1 and Ypn are also
  declared at the Form level }

Procedure TForm1.CalculateSpline;
var
   i, k: Integer;
   p, qn, sig, un: Single;
   u: Array[1..20] of Single;
begin
   if NaturalLowerBoundary then begin
      y2[1] := 0;                                       {Natural lower boundary condition}
      u[1] := 0 end
   else begin
      y2[1] := 0.5;                                     {Specified first derivative}
      u[1] := (3/(x[2]-x[1])) * ((y[2]-y[1])/(x[2]-x[1])-yp1) end;

   For i := 2 to DataCount-1 do begin                   {This is the decomposition loop}
      sig := (x[i]-x[i-1]) / (x[i+1]-x[i-1]);           {of the tridiagonal algorithm}
      p := sig*y2[i-1] + 2;                             {y2 and u are used for temporary}
      y2[i] := (sig-1) / p;                             {storage of the decomposed factors}
      u[i] := (6*((y[i+1]-y[i]) / (x[i+1]-x[i])-(y[i]-y[i-1])/(x[i]-x[i-1])) /
              (x[i+1]-x[i-1])-sig*u[i-1]) / p
   end;

   if NaturalUpperBoundary then begin
      qn := 0;                                          {Natural upper boundary condition}
      un := 0 end
   else begin
      qn := 0.5;                                        {Specified first derivative}
      un := (3/(x[DataCount]-x[DataCount-1])) *
            (ypn-(y[DataCount]-y[DataCount-1])/(x[DataCount]-x[DataCount-1])) end;

   y2[DataCount] := (un-qn*u[DataCount-1]) / (qn*y2[DataCount-1]+1);

   for k := DataCount-1 downto 1 do
      y2[k] := y2[k] * y2[k+1] + u[k]                   {Back substitution of the tridiagonal
                                                         algorithm}
end;

{==========================================================================================}
{= Procedure Splint(X,Y)                                                                  =}
{=                                                                                        =}
{= This is the routine that evaluates the spline. It has been translated from code        =}
{= presented in the book Numerical Recipes for Fortran (Cambridge Press). SLG Data        =}
{= Systems makes no claims as to the accuracy of the translation, and may not be held     =}
{= liable for damage or loss of profit due to its installation and use. This code may be  =}
{= legally redistributed if and only if due recognition is given to Cambridge press.      =}
{=                                                                                        =}
{= Given arrays XData[1..n] and YData[1..n] containing a tabulated function               =}
{= ( i.e. y[i] := f(x[i]) with x[1] < x[2] ... < x[n] ), the array Y2[1..n] from the      =}
{= CalculateSpline Routine above, and a value of X, this routine returns a cubic-spline   =}
{= interpolated value Y                                                                   =}
{==========================================================================================}
procedure TForm1.Splint(Xcalc: Single; var Yspline: Single);
var
   k, khi, klo: Integer;
   a, b, h: Single;
begin
   klo := 1;
   khi := DataCount;

   While (khi-klo) > 1 do begin  { This finds the right spot in the table by means of      }
      k := (khi+klo) div 2;      { bisection. This is optimal if sequential calls are at   }
      if X[k] > Xcalc then       { random values of X. If sequentical calls are in order,  }
         khi := k                { and are closely spaced, it would be better to store the }
      else                       { previous values of klo and khi, and see if they remain  }
         klo := k;               { appropriate on the next call                            }
   end;

   h := X[khi] - X[klo]; { klo and khi bracket the input value of X                }

   { In this demo, the check for 2 identical X values has already been done }

   {if h = 0 then
      ShowMessage 'Spline Evaluation Error - 2 X values identical')}

   a := (X[khi]-Xcalc) / h;      {Evaluate the Spline}
   b := (Xcalc-X[klo]) / h;

   Yspline := a*Y[klo] + b*Y[khi] +
        ((a*a*a - a)*y2[klo] + (b*b*b -b)*y2[khi]) * h*h / 6
end;

procedure TForm1.PlotSpline;
const
   DeltaX: Single = 0.5;
var
   Xind, YSpline: Single;
   NextX: Integer;
   Plot: Boolean;
begin
   Plot := False;
   Xind := X[1] - DeltaX;
   NextX := 2;

   Repeat
      Xind := Xind + DeltaX;           {Xind is the independent variable for the plot}
      If Xind > X[NextX] then begin
         Xind := X[NextX];             {Make sure the data points are included}
         NextX := NextX + 1;
      end;
      Splint(Xind,YSpline);            {Get the Spline Value and plot}
      With Slggraph1 do
         if Plot then
            LineScaledTo(Xind,Yspline)
         else begin
            MoveScaledTo(Xind,Yspline);
            Plot := True;  end
   Until Xind >= X[DataCount];

end;

procedure TForm1.PlotTheData;
var
   i: Integer;
begin
   For i:= 1 to DataCount do
      PlotPoint(Xp[i],Yp[i]);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   Form2.ShowModal
end;

end.
