{# description
//
// Translated from GNU Regex 0.12 regex.h
//
// Author:
// Ezio Vernacotola
// River Software House S.r.l.
// via degli Agricoltori, 57
// 00052 CIVITAVECCHIA (RM)
// ITALY
// email: ezio@etruria.net
//
// Date: 15 Sep 1996
//
}
{# freeware}
{# include 'regex.dll'}

unit GnuRegex;

interface

type
  reg_syntax_t = cardinal;

const
  RE_BACKSLASH_ESCAPE_IN_LISTS = 1;
  RE_BK_PLUS_QM  = (RE_BACKSLASH_ESCAPE_IN_LISTS shl 1);
  RE_CHAR_CLASSES = (RE_BK_PLUS_QM shl 1);
  RE_CONTEXT_INDEP_ANCHORS = (RE_CHAR_CLASSES shl 1);
  RE_CONTEXT_INDEP_OPS  = (RE_CONTEXT_INDEP_ANCHORS shl 1);
  RE_CONTEXT_INVALID_OPS = (RE_CONTEXT_INDEP_OPS shl 1);
  RE_DOT_NEWLINE = (RE_CONTEXT_INVALID_OPS shl 1);
  RE_DOT_NOT_NULL = (RE_DOT_NEWLINE shl 1);
  RE_HAT_LISTS_NOT_NEWLINE = (RE_DOT_NOT_NULL shl 1);
  RE_INTERVALS = (RE_HAT_LISTS_NOT_NEWLINE shl 1);
  RE_LIMITED_OPS = (RE_INTERVALS shl 1);
  RE_NEWLINE_ALT = (RE_LIMITED_OPS shl 1);
  RE_NO_BK_BRACES = (RE_NEWLINE_ALT shl 1);
  RE_NO_BK_PARENS = (RE_NO_BK_BRACES shl 1);
  RE_NO_BK_REFS = (RE_NO_BK_PARENS shl 1);
  RE_NO_BK_VBAR = (RE_NO_BK_REFS shl 1);
  RE_NO_EMPTY_RANGES = (RE_NO_BK_VBAR shl 1);
  RE_UNMATCHED_RIGHT_PAREN_ORD = (RE_NO_EMPTY_RANGES shl 1);


  RE_SYNTAX_EMACS = 0;

  RE_SYNTAX_AWK	=
  (RE_BACKSLASH_ESCAPE_IN_LISTS or RE_DOT_NOT_NULL
   or RE_NO_BK_PARENS           or RE_NO_BK_REFS
   or RE_NO_BK_VBAR             or RE_NO_EMPTY_RANGES
   or RE_UNMATCHED_RIGHT_PAREN_ORD);

  RE_SYNTAX_GREP =
  (RE_BK_PLUS_QM               or RE_CHAR_CLASSES
   or RE_HAT_LISTS_NOT_NEWLINE or RE_INTERVALS
   or RE_NEWLINE_ALT);

  RE_SYNTAX_EGREP =
  (RE_CHAR_CLASSES         or RE_CONTEXT_INDEP_ANCHORS
   or RE_CONTEXT_INDEP_OPS or RE_HAT_LISTS_NOT_NEWLINE
   or RE_NEWLINE_ALT       or RE_NO_BK_PARENS
   or RE_NO_BK_VBAR);

  RE_SYNTAX_POSIX_EGREP	=
  (RE_SYNTAX_EGREP or RE_INTERVALS or RE_NO_BK_BRACES);


  _RE_SYNTAX_POSIX_COMMON	=
  (RE_CHAR_CLASSES or RE_DOT_NEWLINE      or RE_DOT_NOT_NULL
   or RE_INTERVALS or RE_NO_EMPTY_RANGES);

  RE_SYNTAX_POSIX_BASIC	=
  (_RE_SYNTAX_POSIX_COMMON or RE_BK_PLUS_QM);

  RE_SYNTAX_POSIX_MINIMAL_BASIC =
  (_RE_SYNTAX_POSIX_COMMON or RE_LIMITED_OPS);

  RE_SYNTAX_POSIX_EXTENDED =
  (_RE_SYNTAX_POSIX_COMMON or RE_CONTEXT_INDEP_ANCHORS
   or RE_CONTEXT_INDEP_OPS or RE_NO_BK_BRACES
   or RE_NO_BK_PARENS      or RE_NO_BK_VBAR
   or RE_UNMATCHED_RIGHT_PAREN_ORD);

  RE_SYNTAX_POSIX_MINIMAL_EXTENDED =
  (_RE_SYNTAX_POSIX_COMMON   or RE_CONTEXT_INDEP_ANCHORS
   or RE_CONTEXT_INVALID_OPS or RE_NO_BK_BRACES
   or RE_NO_BK_PARENS        or RE_NO_BK_REFS
   or RE_NO_BK_VBAR	     or RE_UNMATCHED_RIGHT_PAREN_ORD);


  RE_SYNTAX_POSIX_AWK = (RE_SYNTAX_POSIX_EXTENDED or RE_BACKSLASH_ESCAPE_IN_LISTS);
  RE_SYNTAX_ED = RE_SYNTAX_POSIX_BASIC;
  RE_SYNTAX_SED = RE_SYNTAX_POSIX_BASIC;

  // POSIX `cflags' bits (i.e., information for `regcomp').
  REG_EXTENDED = 1;
  REG_ICASE = (REG_EXTENDED shl 1);
  REG_NEWLINE = (REG_ICASE shl 1);
  REG_NOSUB = (REG_NEWLINE shl 1);

  // POSIX `eflags' bits (i.e., information for regexec).
  REG_NOTBOL = 1;
  REG_NOTEOL = (1 shl 1);



type
  reg_errcode_t = (
    REG_NOERROR,	  // Success.
    REG_NOMATCH,	  // Didn't find a match (for regexec).

    // POSIX regcomp return error codes.  In the order listed in the
    //   standard.
    REG_BADPAT,		  // Invalid pattern.
    REG_ECOLLATE,	  // Not implemented.
    REG_ECTYPE,		  // Invalid character class name.
    REG_EESCAPE,	  // Trailing backslash.
    REG_ESUBREG,	  // Invalid back reference.
    REG_EBRACK,		  // Unmatched left bracket.
    REG_EPAREN,		  // Parenthesis imbalance.
    REG_EBRACE,		  // Unmatched \//.
    REG_BADBR,		  // Invalid contents of \//\
    REG_ERANGE,		  // Invalid range end.
    REG_ESPACE,		  // Ran out of memory.
    REG_BADRPT,		  // No preceding re for repetition op.

    // Error codes we've added.
    REG_EEND,		  // Premature end.
    REG_ESIZE,		  // Compiled pattern bigger than 2^16 bytes.
    REG_ERPAREN		  // Unmatched ) or \); not returned from regcomp.
  );


  re_pattern_buffer = record
  	// Space that holds the compiled pattern.
    buffer : pchar;

  	// Number of bytes to which `buffer' points.
    allocated : cardinal;

  	// Number of bytes actually used in `buffer'.
    used : cardinal;

    // Syntax setting with which the pattern was compiled.
    syntax : reg_syntax_t ;

    // Pointer to a fastmap, if any, otherwise zero.  re_search uses
    // the fastmap, if there is one, to skip over impossible
    // starting points for matches.
    fastmap : pchar;

    // Either a translate table to apply to all characters before
    // comparing them, or zero for no translation.  The translation
    // is applied to a pattern when it is compiled and to a string
    // when it is matched.
    translate : pchar;

  	// Number of subexpressions found by the compiler.
    re_nsub : cardinal;

    // unsigned can_be_null : 1;
    // Zero if this pattern cannot match the empty string, one else.
    // Well, in truth it's used only in `re_search_2', to see
    // whether or not we should use the fastmap, so we don't set
    // this absolutely perfectly; see `re_compile_fastmap' (the
    //`duplicate' case).

    // unsigned regs_allocated : 2;
    // If REGS_UNALLOCATED, allocate space in the `regs' structure
    // for `max (RE_NREGS, re_nsub + 1)' groups.
    // If REGS_REALLOCATE, reallocate space if necessary.
    // If REGS_FIXED, use what's there.  
    //  REGS_UNALLOCATED 0
    //  REGS_REALLOCATE 1
    //  REGS_FIXED 2

    // unsigned fastmap_accurate : 1;
    // Set to zero when `regex_compile' compiles a pattern; set to one
    // by `re_compile_fastmap' if it updates the fastmap.

    // unsigned no_sub : 1;
    // If set, `re_match_2' does not return information about
    // subexpressions.

    // unsigned not_bol : 1;
    // If set, a beginning-of-line anchor doesn't match at the
    // beginning of the string.

    // unsigned not_eol : 1;    
    // Similarly for an end-of-line anchor.

    // unsigned newline_anchor : 1;    
    // If true, an anchor at a newline matches.

    flags : byte;
  end;

  regex_t = re_pattern_buffer ;

  pregoff_t = ^regoff_t;
  regoff_t = integer;

  paregoff_t = ^aregoff_t;
  aregoff_t = array[0..0] of regoff_t;

  re_registers = record
    num_regs : cardinal;
    start : paregoff_t;
    endr  : paregoff_t;
  end;

const
  RE_NREGS = 30;

type
  // POSIX specification for registers.  Aside from the different names than
  // `re_registers', POSIX uses an array of structures, instead of a
  //  structure of arrays.  */
  regmatch_t = record
     rm_so : regoff_t;     // Byte offset from string's start to substring's start.
     rm_eo : regoff_t ;    // Byte offset from string's start to substring's end.
  end;


// Sets the current default syntax to SYNTAX, and return the old syntax.
function re_set_syntax(syntax : reg_syntax_t) : reg_syntax_t; stdcall;

// Compile the regular expression PATTERN, with length LENGTH
// and syntax given by the global `re_syntax_options', into the buffer
// BUFFER.  Return NULL if successful, and an error string if not.  
function re_compile_pattern(const pattern: pchar; length: integer;
                             var buffer : re_pattern_buffer): pchar; stdcall;

// Compile a fastmap for the compiled pattern in BUFFER; used to
// accelerate searches.  Return 0 if successful and -2 if was an
 //internal error.
function re_compile_fastmap(var buffer : re_pattern_buffer): integer; stdcall;



// Search in the string STRING (with length LENGTH) for the pattern
// compiled into BUFFER.  Start searching at position START, for RANGE
// characters.  Return the starting position of the match, -1 for no
// match, or -2 for an internal error.  Also return register
// information in REGS (if REGS and BUFFER->no_sub are nonzero).  
function re_search(var buffer : re_pattern_buffer; const s: pchar;
            length, start, range : integer; var regs : re_registers) : integer; stdcall;



// Like `re_search', but search in the concatenation of STRING1 and
// STRING2.  Also, stop searching at index START + STOP.
function re_search_2(var buffer : re_pattern_buffer; const string1 : pchar;
             length1 : integer; const string2 : pchar; length2,
             start, range : integer ) : integer; stdcall;


// Like `re_search', but return how many characters in STRING the regexp
// in BUFFER matched, starting at position START.
function re_match(var buffer : re_pattern_buffer; const s : pchar;
             length, start : integer; var regs : re_registers) : integer; stdcall;



// Relates to `re_match' as `re_search_2' relates to `re_search'.
function re_match_2(var buffer : re_pattern_buffer; const string1 : pchar;
             length1 : integer; const string2: pchar; length2, start : integer;
             var regs : re_registers; stop : integer) : integer; stdcall;


procedure re_set_registers(var buffer : re_pattern_buffer; var regs : re_registers;
             num_regs : cardinal; var starts : regoff_t; var ends : regoff_t ); stdcall;


// 4.2 bsd compatibility.
function re_comp(const s: pchar) : pchar; stdcall;
function re_exec(const s: pchar) : integer; stdcall;

// POSIX compatibility.
function regcomp(var preg : regex_t; const pattern : pchar; cflags : integer): integer; stdcall;
function regexec(const preg : regex_t; const s : pchar; nmatch : cardinal;
              pmatch : array of regmatch_t; eflags : integer) : integer; stdcall;
function regerror(errcode  : integer; const preg : regex_t; errbuf : pchar;
             errbuf_size : cardinal): integer; stdcall;
procedure regfree(var preg : regex_t ); stdcall;


implementation

const
  regexdll = 'regex.dll';

function re_set_syntax(syntax : reg_syntax_t) : reg_syntax_t; external regexdll;
function re_compile_pattern(const pattern: pchar; length: integer;
                             var buffer : re_pattern_buffer): pchar; external regexdll;

function re_compile_fastmap(var buffer : re_pattern_buffer): integer; external regexdll;
function re_search(var buffer : re_pattern_buffer; const s: pchar;
            length, start, range : integer; var regs : re_registers) : integer; external regexdll;
function re_search_2(var buffer : re_pattern_buffer; const string1 : pchar;
             length1 : integer; const string2 : pchar; length2,
             start, range : integer ) : integer; external regexdll;
function re_match(var buffer : re_pattern_buffer; const s : pchar;
             length, start : integer; var regs : re_registers) : integer; external regexdll;
function re_match_2(var buffer : re_pattern_buffer; const string1 : pchar;
             length1 : integer; const string2: pchar; length2, start : integer;
             var regs : re_registers; stop : integer) : integer; external regexdll;
procedure re_set_registers(var buffer : re_pattern_buffer; var regs : re_registers;
             num_regs : cardinal; var starts : regoff_t; var ends : regoff_t ); external regexdll;
function re_comp(const s: pchar) : pchar; external regexdll;
function re_exec(const s: pchar) : integer; external regexdll;
function regcomp(var preg : regex_t; const pattern : pchar; cflags : integer): integer; external regexdll;
function regexec(const preg : regex_t; const s : pchar; nmatch : cardinal;
              pmatch : array of regmatch_t; eflags : integer) : integer; external regexdll;
function regerror(errcode  : integer; const preg : regex_t; errbuf : pchar;
             errbuf_size : cardinal): integer; external regexdll;
procedure regfree(var preg : regex_t ); external regexdll;


end.
