{$B-,D-,L-,Y-}
unit skTable;

interface
uses
   Classes,
   SysUtils,
   DB,
   dbTables,
   Forms,
   Comp;

type
   TEvalProc = procedure of object;
   TCondition = function : Boolean of object;

type
   (*TskTable is a TTable enhancement:
  ____________________
  - Assign method is added;
  - DoBeforeClose checks for unsaved changes;
  - dbEval works like its Clipper counterpart (spins through the range
  defined by bForCondition and bWhileCondition Boolean functions and
  calls bBlock for every record in the range);
  *)
  TskTable = class(TTable)
  protected
     procedure DoBeforeClose; override;
  public
     procedure Assign(Source: TPersistent); override;
     procedure dbEval(bBlock : TEvalProc;
        bForCondition, bWhileCondition : TCondition);
     function CompareBookMarks(x,y : TBookMark) : Boolean;
  end;{TskTable}
procedure Register;

implementation
uses Dialogs, DbiTypes, DbiProcs;

procedure TskTable.Assign(Source : TPersistent);
begin
   if Source is TTable then with TTable(Source) do try
      if Active then Close;

      Self.AutoCalcFields := AutoCalcFields;
      Self.DataBaseName   := DataBaseName;
      Self.Exclusive      := Exclusive;
      Self.KeyExclusive   := KeyExclusive;
      Self.KeyFieldCount  := KeyFieldCount;
      Self.IndexName      := IndexName;
      Self.MasterFields   := MasterFields;
      Self.MasterSource   := MasterSource;
      Self.ReadOnly       := ReadOnly;
      Self.TableName      := TableName;
      Self.TableType      := TableType;
      Self.FieldDefs.Assign( FieldDefs );
      Self.IndexDefs.Assign( IndexDefs );
      if Active then begin
         Self.Open;
         Self.GoToCurrent(TTable(Source))
      end;
   finally
      {do nothing}
   end{try}
   else inherited Assign(Source);
end;

procedure TskTable.dbEval(bBlock : TEvalProc;
   bForCondition, bWhileCondition : TCondition);
var withFor, withWhile : Boolean;
begin
   if not Assigned(bBlock) then Exit;{nothing to dbEvaluate}
   withFor := Assigned(bForCondition);
   withWhile := Assigned(bWhileCondition);
   if withFor then First;
   while not Eof do begin
      {if while expression is not true - quit}
      if withWhile and not bWhileCondition then
         Break;
      {call bBlock if there is no for condition or for expression is true}
      if (not withFor) or bForCondition then
         bBlock;
      Next
   end;{while}
end;{dbEval}

{if there are unsaved changes then prompt the user}
procedure TskTable.DoBeforeClose;
begin
   if Modified and (State in [dsInsert, dsEdit]) then
      if UpCase( InputBox( 'Save changes',
      'Do you want to save changes made to the table: ' + TableName,
         'Yes')[1] ) = 'Y' then
         Post
end;{DoBeforeClose}

function TskTable.CompareBookMarks(x,y : TBookMark) : Boolean;
var
   CursorProps: CurProps;
begin
{FBookMarkSize is a private field of TDataSet, therefore we
don't have access to it and have to recalculate it ourselves.}
   DbiGetCursorProps(Handle, CursorProps);
   Result := MemCmp(x^, y^, CursorProps.iBookmarkSize) = 0;
end;

procedure Register;
begin
   RegisterComponents('Data Access', [TskTable])
end;{Register}

end.
