{$D-,L-,Y-}
unit Comp;
{********************************************************
*Unit:      Comp                                        *
*Purpose:   TypInfo unit extensions                     *
*Author:    Syarzhuk Kazachehnka, bamboo7431@hotmail.com*
*Copyright: 1997 - 1998 Syarzhuk Kazachehnka           *
*********************************************************

This code can be freely used in applications of any kind provided that:
 1. User notifies the Author about the it (email-ware).
 2. All the changes to the original code are submitted to Author for approval.
 3. Copyright message is left untouched.

Version history:
 04/03/98 - Addition - added MemCmp function
 10/09/97 - Enhancement - objects passed as arguments for the Compare function
            now do not have to be of the same class type (but one still should
            inherit from the other).
 08/14/97 - Initial release}

interface
uses TypInfo, Classes, SysUtils;

type
   EIncompatibleTypes = class( Exception );
   ENoPublished = class( Exception );

{TypInfo lacks these two methods}
function GetClassProp(Instance: TObject; PropInfo: PPropInfo): TObject;
procedure SetClassProp(Instance : TObject; PropInfo : PPropInfo;
          const Value : TObject );

{generic Compare function; compares any two objects(TPersistent descendents),
 reading the values of all published properties and comparing them}
function Compare( Obj1, Obj2 : TObject ) : Boolean;

{that's a generic memory comparison function}
function MemCmp(var a, b; Len : Cardinal):Integer;

implementation

function GetClassProp(Instance: TObject; PropInfo: PPropInfo): TObject;
begin
   Result := TObject( GetOrdProp( Instance, PropInfo ) )
end;{GetClassProp}

procedure SetClassProp(Instance : TObject; PropInfo : PPropInfo;
          const Value : TObject );
begin
   SetOrdProp( Instance, PropInfo, LongInt( Value ))
end;{SetClassProp}

function CompareMethods( Method1, Method2 : TMethod ) : Boolean;
begin
   Result := ( Method1.Code = Method2.Code ) and
             ( Method1.Data = Method2.Data )
end;{CompareMethods}

function Compare( Obj1, Obj2 : TObject ) : Boolean;
var
   Iterator,
   PropCnt  : SmallInt;
   PInfo    : PPropInfo;
   PropLst  : PPropList;
   Temp     : TObject;
begin
   if ( Obj1 = Obj2 )
      then begin
         Result := True;
         Exit
      end;
   if ( Obj1 = nil ) or ( Obj2 = nil )
      then begin
         Result := False;
         Exit
      end;
   if not (Obj1 is TPersistent)
      then raise ENoPublished.Create( 'Objects to compare should be descendants of TPersistent ' );

   {if the objects are of different types}
   if Obj1.ClassType <> Obj2.ClassType
      then begin{then one should inherit from the other}
         if not ( Obj1.InheritsFrom( Obj2.ClassType ) or
                ( Obj2.InheritsFrom( Obj1.ClassType ) ) )
            then raise EIncompatibleTypes.Create(
               'Class types are incompatible' )
            else {second object should inherit from the first object's classtype}
               if Obj1.InheritsFrom( Obj2.ClassType )
                  then begin{swap Obj1 and Obj2}
                     Temp := Obj1;
                     Obj1 := Obj2;
                     Obj2 := Temp
                  end;{swap}
      end;{different types}

   Result  := True;
   PropCnt := GetTypeData( Obj1.ClassInfo )^.PropCount;
   try
      GetMem( PropLst, PropCnt * SizeOf( Pointer ) );
      GetPropInfos( Obj1.ClassInfo, PropLst );
      for Iterator := 0 to PropCnt - 1 do begin
         PInfo := PropLst^[ Iterator ];
          case PInfo^.PropType^.Kind of
             tkInteger,
             tkChar,
             tkEnumeration,
             tkSet: if CompareText( PInfo^.PropType^.Name, 'TTabOrder' ) <> 0
                       then Result := GetOrdProp( Obj1, PInfo ) =
                                      GetOrdProp( Obj2, PInfo );
             tkString : {Component names are unique; we ignore them}
                if CompareText( PInfo^.PropType^.Name, 'TComponentName' ) <> 0
                   then Result := GetStrProp( Obj1, PInfo ) =
                                  GetStrProp( Obj2, PInfo );
             tkFloat  : Result := GetFloatProp( Obj1, PInfo ) =
                                  GetFloatProp( Obj2, PInfo );
             tkMethod : Result := CompareMethods(
                                  GetMethodProp( Obj1, PInfo ),
                                  GetMethodProp( Obj2, PInfo ) );
             tkClass  : Result := Compare(GetClassProp(Obj1, PInfo),
                                          GetClassProp(Obj2, PInfo) );
          end;{case}
          if not Result then Break
      end{for}
   finally
      FreeMem( PropLst, PropCnt * SizeOf( Pointer ) )
   end{try}
end;{Compare}

type
   TMemArray = array[0..0] of byte;

function MemCmp(var a, b; Len : Cardinal):Integer;
var
   x : TMemArray absolute a;
   y : TMemArray absolute b;
   i    : Cardinal;
begin
   Result := 0;
   i := 0;
   for i := 0 to Len - 1 do begin
      if x[i] > y[i] then begin Result := 1; Exit end
      else if y[i] < x[i] then begin Result := -1; Exit end
   end;
end;{MemCmp}

end.
